/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine;

import icyllis.arc3d.core.MathUtil;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;

public final class CpuBuffer
extends RefCnt {
    private final long mSize;
    private final long mData;

    private CpuBuffer(long size, long data) {
        this.mSize = size;
        this.mData = data;
    }

    @Nullable
    @SharedPtr
    public static CpuBuffer make(long size) {
        assert (size > 0L);
        long data = MemoryUtil.nmemAlloc((long)size);
        if (data == 0L) {
            return null;
        }
        assert (MathUtil.isAlign8(data));
        return new CpuBuffer(size, data);
    }

    public long size() {
        return this.mSize;
    }

    public long data() {
        return this.mData;
    }

    @Override
    protected void deallocate() {
        MemoryUtil.nmemFree((long)this.mData);
    }
}

