/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine;

import icyllis.arc3d.core.ColorInfo;
import icyllis.arc3d.engine.BackendFormat;
import icyllis.arc3d.engine.ContextOptions;
import icyllis.arc3d.engine.DataUtils;
import icyllis.arc3d.engine.DriverBugWorkarounds;
import icyllis.arc3d.engine.GpuRenderTarget;
import icyllis.arc3d.engine.IResourceKey;
import icyllis.arc3d.engine.ImageDesc;
import icyllis.arc3d.engine.PipelineDesc;
import icyllis.arc3d.engine.PipelineKey;
import icyllis.arc3d.engine.RenderPassDesc;
import icyllis.arc3d.engine.ShaderCaps;
import icyllis.arc3d.engine.trash.GraphicsPipelineDesc_Old;
import icyllis.arc3d.engine.trash.PipelineKey_old;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Caps {
    public static final int MAX_COLOR_TARGETS = 8;
    public static final int MAX_VERTEX_ATTRIBUTES = 32;
    public static final int MAX_VERTEX_BINDINGS = 32;
    protected final ShaderCaps mShaderCaps = new ShaderCaps();
    protected boolean mAnisotropySupport = false;
    protected boolean mGpuTracingSupport = false;
    protected boolean mConservativeRasterSupport = false;
    protected boolean mTransferPixelsToRowBytesSupport = false;
    protected boolean mMustSyncGpuDuringDiscard = true;
    protected boolean mTextureBarrierSupport = false;
    protected boolean mUseCpuStagingBuffers = false;
    protected boolean mDepthClipNegativeOneToOne = false;
    protected boolean mClampToBorderSupport = true;
    protected boolean mDynamicStateArrayGeometryProcessorTextureSupport = false;
    protected BlendEquationSupport mBlendEquationSupport = BlendEquationSupport.BASIC;
    protected int mMapBufferFlags;
    protected int mMaxRenderTargetSize = 1;
    protected int mMaxPreferredRenderTargetSize = 1;
    protected int mMaxVertexAttributes = 16;
    protected int mMaxVertexBindings = 16;
    protected int mMaxTextureSize = 1;
    protected int mInternalMultisampleCount = 0;
    protected int mMaxPushConstantsSize = 0;
    protected int mMaxColorAttachments = 4;
    protected int mMinUniformBufferOffsetAlignment = 256;
    protected int mMinStorageBufferOffsetAlignment = 256;
    protected final DriverBugWorkarounds mDriverBugWorkarounds = new DriverBugWorkarounds();

    public Caps(ContextOptions options) {
        this.mDriverBugWorkarounds.applyOverrides(options.mDriverBugWorkarounds);
    }

    public final ShaderCaps shaderCaps() {
        return this.mShaderCaps;
    }

    public final boolean npotTextureTileSupport() {
        return true;
    }

    public final boolean mipmapSupport() {
        return true;
    }

    public final boolean hasAnisotropySupport() {
        return this.mAnisotropySupport;
    }

    public final boolean gpuTracingSupport() {
        return this.mGpuTracingSupport;
    }

    public final boolean oversizedStencilSupport() {
        return true;
    }

    public final boolean textureBarrierSupport() {
        return true;
    }

    public final boolean sampleLocationsSupport() {
        return true;
    }

    public final boolean drawInstancedSupport() {
        return true;
    }

    public final boolean conservativeRasterSupport() {
        return this.mConservativeRasterSupport;
    }

    public final boolean wireframeSupport() {
        return true;
    }

    public final boolean msaaResolvesAutomatically() {
        return false;
    }

    public final boolean preferDiscardableMSAAAttachment() {
        return false;
    }

    public final boolean halfFloatVertexAttributeSupport() {
        return true;
    }

    public final boolean usePrimitiveRestart() {
        return false;
    }

    public final boolean preferClientSideDynamicBuffers() {
        return false;
    }

    public final boolean preferFullscreenClears() {
        return false;
    }

    public final boolean discardStencilValuesAfterRenderPass() {
        return this.preferFullscreenClears();
    }

    public final boolean twoSidedStencilRefsAndMasksMustMatch() {
        return false;
    }

    public final boolean preferVRAMUseOverFlushes() {
        return true;
    }

    public final boolean avoidStencilBuffers() {
        return false;
    }

    public final boolean avoidWritePixelsFastPath() {
        return false;
    }

    public final boolean requiresManualFBBarrierAfterTessellatedStencilDraw() {
        return false;
    }

    public final boolean nativeDrawIndexedIndirectIsBroken() {
        return false;
    }

    public final BlendEquationSupport blendEquationSupport() {
        return this.mBlendEquationSupport;
    }

    public final boolean advancedBlendEquationSupport() {
        return this.mBlendEquationSupport != BlendEquationSupport.BASIC;
    }

    public final boolean advancedCoherentBlendEquationSupport() {
        return this.mBlendEquationSupport == BlendEquationSupport.ADVANCED_COHERENT;
    }

    public final boolean shouldCollapseSrcOverToSrcWhenAble() {
        return false;
    }

    public final boolean mustSyncGpuDuringDiscard() {
        return this.mMustSyncGpuDuringDiscard;
    }

    public final boolean supportsTextureBarrier() {
        return this.mTextureBarrierSupport;
    }

    public final boolean reducedShaderMode() {
        return this.mShaderCaps.mReducedShaderMode;
    }

    public final boolean reuseScratchTextures() {
        return true;
    }

    public final boolean reuseScratchBuffers() {
        return true;
    }

    public final boolean useCpuStagingBuffers() {
        return this.mUseCpuStagingBuffers;
    }

    public final int minUniformBufferOffsetAlignment() {
        return this.mMinUniformBufferOffsetAlignment;
    }

    public final int minStorageBufferOffsetAlignment() {
        return this.mMinStorageBufferOffsetAlignment;
    }

    public final int maxVertexAttributes() {
        return this.mMaxVertexAttributes;
    }

    public final int maxVertexBindings() {
        return this.mMaxVertexBindings;
    }

    public final int maxRenderTargetSize() {
        return this.mMaxRenderTargetSize;
    }

    public final int maxPreferredRenderTargetSize() {
        return this.mMaxPreferredRenderTargetSize;
    }

    public final int maxTextureSize() {
        return this.mMaxTextureSize;
    }

    public final int maxPushConstantsSize() {
        return this.mMaxPushConstantsSize;
    }

    public final int maxColorAttachments() {
        return this.mMaxColorAttachments;
    }

    public final int transferBufferAlignment() {
        return 1;
    }

    public abstract boolean isFormatTexturable(BackendFormat var1);

    public abstract int getMaxRenderTargetSampleCount(BackendFormat var1);

    public final int getInternalMultisampleCount(BackendFormat format) {
        return Math.min(this.mInternalMultisampleCount, this.getMaxRenderTargetSampleCount(format));
    }

    public abstract boolean isFormatRenderable(int var1, BackendFormat var2, int var3);

    public abstract boolean isFormatRenderable(BackendFormat var1, int var2);

    public abstract int getRenderTargetSampleCount(int var1, BackendFormat var2);

    public abstract long getSupportedWriteColorType(int var1, ImageDesc var2, int var3);

    public final long getSupportedReadColorType(int srcColorType, BackendFormat srcFormat, int dstColorType) {
        int channelFlags;
        long read = this.onSupportedReadColorType(srcColorType, srcFormat, dstColorType);
        int colorType = (int)(read & 0xFFFFFFFFL);
        long transferOffsetAlignment = read >>> 32;
        if (colorType == 5) {
            transferOffsetAlignment = 0L;
        }
        if (((channelFlags = ColorInfo.colorTypeChannelFlags(colorType)) == 15 || channelFlags == 7 || channelFlags == 8 || channelFlags == 16) && ColorInfo.bytesPerPixel(colorType) == 4) {
            switch ((int)(transferOffsetAlignment & 3L)) {
                case 0: {
                    break;
                }
                case 2: {
                    transferOffsetAlignment *= 2L;
                    break;
                }
                default: {
                    transferOffsetAlignment *= 4L;
                }
            }
        }
        return (long)colorType | transferOffsetAlignment << 32;
    }

    protected abstract long onSupportedReadColorType(int var1, BackendFormat var2, int var3);

    public final boolean writePixelsRowBytesSupport() {
        return true;
    }

    public final boolean transferPixelsToRowBytesSupport() {
        return this.mTransferPixelsToRowBytesSupport;
    }

    public final boolean readPixelsRowBytesSupport() {
        return true;
    }

    public final boolean transferFromSurfaceToBufferSupport() {
        return true;
    }

    public final boolean transferFromBufferToTextureSupport() {
        return true;
    }

    public final boolean mustClearUploadedBufferData() {
        return false;
    }

    public final boolean shouldInitializeTextures() {
        return false;
    }

    public final boolean fenceSyncSupport() {
        return true;
    }

    public final boolean semaphoreSupport() {
        return true;
    }

    public final boolean crossContextTextureSupport() {
        return true;
    }

    public final boolean dynamicStateArrayGeometryProcessorTextureSupport() {
        return this.mDynamicStateArrayGeometryProcessorTextureSupport;
    }

    public final boolean performPartialClearsAsDraws() {
        return false;
    }

    public final boolean performColorClearsAsDraws() {
        return false;
    }

    public final boolean avoidLargeIndexBufferDraws() {
        return false;
    }

    public final boolean performStencilClearsAsDraws() {
        return false;
    }

    public final boolean clampToBorderSupport() {
        return this.mClampToBorderSupport;
    }

    public final boolean depthClipNegativeOneToOne() {
        return this.mDepthClipNegativeOneToOne;
    }

    public final boolean validateSurfaceParams(int width, int height, BackendFormat format, int sampleCount, int surfaceFlags) {
        if (width < 1 || height < 1) {
            return false;
        }
        if ((surfaceFlags & 8) != 0 && !this.isFormatTexturable(format)) {
            return false;
        }
        if ((surfaceFlags & 0x20) != 0) {
            int maxSize = this.maxRenderTargetSize();
            if (width > maxSize || height > maxSize) {
                return false;
            }
            return this.isFormatRenderable(format, sampleCount);
        }
        int maxSize = this.maxTextureSize();
        if (width > maxSize || height > maxSize) {
            return false;
        }
        return sampleCount == 1;
    }

    public final boolean validateAttachmentParams(int width, int height, BackendFormat format, int sampleCount) {
        if (width < 1 || height < 1) {
            return false;
        }
        int maxSize = this.maxRenderTargetSize();
        if (width > maxSize || height > maxSize) {
            return false;
        }
        return this.isFormatRenderable(format, sampleCount);
    }

    public final boolean isFormatCompatible(int colorType, BackendFormat format) {
        if (colorType == 0) {
            return false;
        }
        int compression = format.getCompressionType();
        if (compression != 0) {
            return colorType == (DataUtils.compressionTypeIsOpaque(compression) ? 5 : 6);
        }
        return this.onFormatCompatible(colorType, format);
    }

    protected abstract boolean onFormatCompatible(int var1, BackendFormat var2);

    @Nullable
    public ImageDesc getDefaultColorImageDesc(int imageType, int colorType, int width, int height, int depthOrArraySize, int imageFlags) {
        return this.getDefaultColorImageDesc(imageType, colorType, width, height, depthOrArraySize, 0, 0, imageFlags);
    }

    @Nullable
    public ImageDesc getDefaultColorImageDesc(int imageType, int colorType, int width, int height, int depthOrArraySize, int mipLevelCount, int sampleCount, int imageFlags) {
        return null;
    }

    @Nullable
    public ImageDesc getDefaultDepthStencilImageDesc(int depthBits, int stencilBits, int width, int height, int sampleCount, int imageFlags) {
        return null;
    }

    @Nullable
    public ImageDesc getImageDescForSampledCopy(ImageDesc src, int width, int height, int depthOrArraySize, int imageFlags) {
        return null;
    }

    @Nullable
    public final BackendFormat getDefaultBackendFormat(int colorType, boolean renderable) {
        if (colorType == 0) {
            return null;
        }
        BackendFormat format = this.onGetDefaultBackendFormat(colorType);
        if (format == null || !this.isFormatTexturable(format)) {
            return null;
        }
        if (!this.isFormatCompatible(colorType, format)) {
            return null;
        }
        if (renderable && !this.isFormatRenderable(colorType, format, 1)) {
            return null;
        }
        return format;
    }

    @Nullable
    protected abstract BackendFormat onGetDefaultBackendFormat(int var1);

    @Nullable
    public abstract BackendFormat getCompressedBackendFormat(int var1);

    @Nonnull
    public abstract PipelineKey_old makeDesc(PipelineKey_old var1, GpuRenderTarget var2, GraphicsPipelineDesc_Old var3);

    @Nonnull
    public abstract PipelineKey makeGraphicsPipelineKey(PipelineKey var1, PipelineDesc var2, RenderPassDesc var3);

    public final short getReadSwizzle(ImageDesc desc, int colorType) {
        int compression = desc.getCompressionType();
        if (compression != 0) {
            if (colorType == 5 || colorType == 6) {
                return 12816;
            }
            assert (false);
            return 12816;
        }
        return this.onGetReadSwizzle(desc, colorType);
    }

    protected abstract short onGetReadSwizzle(ImageDesc var1, int var2);

    public abstract short getWriteSwizzle(ImageDesc var1, int var2);

    public abstract IResourceKey computeImageKey(ImageDesc var1, IResourceKey var2);

    public final DriverBugWorkarounds workarounds() {
        return this.mDriverBugWorkarounds;
    }

    protected final void finishInitialization(ContextOptions options) {
        this.mShaderCaps.applyOptionsOverrides(options);
        this.onApplyOptionsOverrides(options);
        this.mInternalMultisampleCount = options.mInternalMultisampleCount;
        this.mMaxRenderTargetSize = Math.min(this.mMaxRenderTargetSize, this.mMaxTextureSize);
        this.mMaxPreferredRenderTargetSize = Math.min(this.mMaxPreferredRenderTargetSize, this.mMaxRenderTargetSize);
    }

    protected void onApplyOptionsOverrides(ContextOptions options) {
        this.mDriverBugWorkarounds.applyOverrides(options.mDriverBugWorkarounds);
    }

    public static enum BlendEquationSupport {
        BASIC,
        ADVANCED,
        ADVANCED_COHERENT;

    }
}

