/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core.effects;

import icyllis.arc3d.core.ColorSpace;
import icyllis.arc3d.core.MathUtil;
import icyllis.arc3d.core.Size;
import icyllis.arc3d.core.effects.ColorFilter;
import javax.annotation.Nullable;

public final class ColorMatrixColorFilter
implements ColorFilter {
    private final float[] mMatrix = new float[20];
    private final boolean mAlphaUnchanged;

    public ColorMatrixColorFilter(@Size(value=20L) float[] matrix) {
        this.mAlphaUnchanged = MathUtil.isApproxZero(matrix[3]) && MathUtil.isApproxZero(matrix[7]) && MathUtil.isApproxZero(matrix[11]) && MathUtil.isApproxZero(matrix[19]) && MathUtil.isApproxEqual(matrix[15], 1.0f);
        System.arraycopy(matrix, 0, this.mMatrix, 0, 20);
    }

    @Nullable
    public static ColorFilter make(@Size(value=20L) float[] matrix) {
        float prod = 0.0f;
        for (int i = 0; i < 20; ++i) {
            prod *= matrix[i];
        }
        if (prod != 0.0f) {
            return null;
        }
        return new ColorMatrixColorFilter(matrix);
    }

    public float[] getMatrix() {
        return this.mMatrix;
    }

    @Override
    public boolean isAlphaUnchanged() {
        return this.mAlphaUnchanged;
    }

    @Override
    public void filterColor4f(float[] col, float[] out, ColorSpace dstCS) {
        float a = 1.0f / col[3];
        if (!Float.isFinite(a)) {
            a = 0.0f;
        }
        float[] m = this.mMatrix;
        float x = MathUtil.clamp(m[0] * col[0] * a + m[4] * col[1] * a + m[8] * col[2] * a + m[12] * col[3] + m[16], 0.0f, 1.0f);
        float y = MathUtil.clamp(m[1] * col[0] * a + m[5] * col[1] * a + m[9] * col[2] * a + m[13] * col[3] + m[17], 0.0f, 1.0f);
        float z = MathUtil.clamp(m[2] * col[0] * a + m[6] * col[1] * a + m[10] * col[2] * a + m[14] * col[3] + m[18], 0.0f, 1.0f);
        float w = MathUtil.clamp(m[3] * col[0] * a + m[7] * col[1] * a + m[11] * col[2] * a + m[15] * col[3] + m[19], 0.0f, 1.0f);
        out[0] = x * w;
        out[1] = y * w;
        out[2] = z * w;
        out[3] = w;
    }

    @Override
    public void ref() {
    }

    @Override
    public void unref() {
    }
}

