/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core.effects;

import icyllis.arc3d.core.BlendMode;
import icyllis.arc3d.core.ColorSpace;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.core.Size;
import icyllis.arc3d.core.effects.ColorFilter;
import java.util.Arrays;
import javax.annotation.Nullable;

public final class BlendModeColorFilter
implements ColorFilter {
    private final float[] mColor;
    private final BlendMode mMode;

    BlendModeColorFilter(@Size(value=4L) float[] color, BlendMode mode) {
        this.mColor = color;
        this.mMode = mode;
    }

    @Nullable
    @SharedPtr
    public static BlendModeColorFilter make(@Size(value=4L) float[] color, @Nullable ColorSpace colorSpace, BlendMode mode) {
        if (mode == null) {
            return null;
        }
        float[] srgb = Arrays.copyOfRange(color, 0, 4);
        if (colorSpace != null && !colorSpace.isSrgb()) {
            ColorSpace.connect(colorSpace).transform(srgb);
        }
        float alpha = srgb[3];
        if (mode == BlendMode.CLEAR) {
            Arrays.fill(srgb, 0.0f);
            mode = BlendMode.SRC;
        } else if (mode == BlendMode.SRC_OVER) {
            if (alpha == 0.0f) {
                mode = BlendMode.DST;
            } else if (alpha == 1.0f) {
                mode = BlendMode.SRC;
            }
        }
        if (mode == BlendMode.DST) {
            return null;
        }
        if (alpha == 0.0f) {
            switch (mode) {
                case DST_OVER: 
                case DST_OUT: 
                case SRC_ATOP: 
                case XOR: 
                case PLUS: 
                case PLUS_CLAMPED: 
                case MINUS: 
                case MINUS_CLAMPED: {
                    return null;
                }
            }
            if (mode.isAdvanced()) {
                return null;
            }
        }
        if (alpha == 1.0f && mode == BlendMode.DST_IN) {
            return null;
        }
        return new BlendModeColorFilter(srgb, mode);
    }

    public float[] getColor() {
        return this.mColor;
    }

    public BlendMode getMode() {
        return this.mMode;
    }

    @Override
    public boolean isAlphaUnchanged() {
        return switch (this.mMode) {
            case BlendMode.SRC_ATOP, BlendMode.DST -> true;
            default -> false;
        };
    }

    @Override
    public void filterColor4f(float[] col, float[] out, ColorSpace dstCS) {
        float[] blendColor = (float[])this.mColor.clone();
        if (dstCS != null && !dstCS.isSrgb()) {
            ColorSpace.connect(ColorSpace.get(ColorSpace.Named.SRGB), dstCS).transform(blendColor);
        }
        int i = 0;
        while (i < 3) {
            int n = i++;
            blendColor[n] = blendColor[n] * blendColor[3];
        }
        this.mMode.apply(blendColor, col, out);
    }

    @Override
    public void ref() {
    }

    @Override
    public void unref() {
    }
}

