/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core;

import icyllis.arc3d.core.Glyph;
import icyllis.arc3d.core.Path;
import icyllis.arc3d.core.ScalerContext;
import icyllis.arc3d.core.StrikeCache;
import icyllis.arc3d.core.StrikeDesc;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public final class Strike {
    private final StrikeDesc mStrikeDesc;
    private final StrikeCache mStrikeCache;
    private final ReentrantLock mLock = new ReentrantLock();
    @GuardedBy(value="mLock")
    private final Int2ObjectOpenHashMap<Glyph> mGlyphs = new Int2ObjectOpenHashMap();
    @GuardedBy(value="mLock")
    private final ScalerContext mScalerContext;
    @GuardedBy(value="mLock")
    private long mMemoryIncrease;
    Strike mNext;
    Strike mPrev;
    long mMemoryUsed;
    boolean mRemoved;

    @ApiStatus.Internal
    public Strike(@Nonnull StrikeCache strikeCache, @Nonnull StrikeDesc strikeDesc, @Nonnull ScalerContext scalerContext) {
        this.mStrikeDesc = strikeDesc;
        this.mStrikeCache = strikeCache;
        this.mScalerContext = scalerContext;
        this.mMemoryUsed = 224L;
    }

    public void lock() {
        this.mLock.lock();
        this.mMemoryIncrease = 0L;
    }

    public void unlock() {
        long increase = this.mMemoryIncrease;
        this.mLock.unlock();
        if (increase > 0L) {
            this.mStrikeCache.mLock.lock();
            try {
                this.mMemoryUsed += increase;
                if (!this.mRemoved) {
                    this.mStrikeCache.mTotalMemoryUsed += increase;
                }
            }
            finally {
                this.mStrikeCache.mLock.unlock();
            }
        }
    }

    @Nonnull
    public Glyph getGlyph(int glyphID) {
        return this.digestFor(0, glyphID);
    }

    @Nonnull
    public Glyph digestFor(int actionType, int glyphID) {
        assert (this.mLock.isLocked());
        Glyph glyph = (Glyph)this.mGlyphs.get(glyphID);
        if (glyph != null && glyph.actionFor(actionType) != 0) {
            return glyph;
        }
        if (glyph == null) {
            Path path;
            glyph = this.mScalerContext.makeGlyph(glyphID);
            glyph.initActions();
            this.mGlyphs.put(glyphID, (Object)glyph);
            this.mMemoryIncrease += 48L;
            if (glyph.setPathHasBeenCalled() && (path = glyph.getPath()) != null) {
                this.mMemoryIncrease += path.estimatedByteSize();
            }
        }
        glyph.setActionFor(actionType, this);
        return glyph;
    }

    public boolean prepareForImage(@Nonnull Glyph glyph) {
        assert (this.mLock.isLocked());
        if (glyph.setImage(this.mScalerContext)) {
            this.mMemoryIncrease += (long)(glyph.getImageSize() + 16);
        }
        return glyph.getImageBase() != null;
    }

    public boolean prepareForPath(Glyph glyph) {
        assert (this.mLock.isLocked());
        if (glyph.setPath(this.mScalerContext)) {
            this.mMemoryIncrease += glyph.getPath().estimatedByteSize();
        }
        return glyph.getPath() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Glyph[] getMetrics(@Nonnull int[] glyphs, int glyphOffset, int glyphCount, @Nonnull Glyph[] results) {
        assert (results.length >= glyphCount);
        this.lock();
        try {
            int i = glyphOffset;
            int e = glyphOffset + glyphCount;
            int j = 0;
            while (i < e) {
                Glyph glyph;
                results[j] = glyph = this.getGlyph(glyphs[i]);
                ++i;
                ++j;
            }
            Glyph[] glyphArray = results;
            return glyphArray;
        }
        finally {
            this.unlock();
        }
    }

    public StrikeDesc getStrikeDesc() {
        return this.mStrikeDesc;
    }
}

