/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core;

import icyllis.arc3d.core.MathUtil;
import icyllis.arc3d.core.Rect2fc;
import icyllis.arc3d.core.Rect2i;
import icyllis.arc3d.core.Rect2ic;
import javax.annotation.Nonnull;

public class Rect2f
implements Rect2fc {
    private static final Rect2fc EMPTY = new Rect2f();
    public float mLeft;
    public float mTop;
    public float mRight;
    public float mBottom;

    public Rect2f() {
    }

    public Rect2f(float left, float top, float right, float bottom) {
        this.mLeft = left;
        this.mTop = top;
        this.mRight = right;
        this.mBottom = bottom;
    }

    public Rect2f(@Nonnull Rect2fc r) {
        r.store(this);
    }

    public Rect2f(@Nonnull Rect2ic r) {
        r.store(this);
    }

    @Nonnull
    public static Rect2fc empty() {
        return EMPTY;
    }

    @Override
    public final boolean isEmpty() {
        return !(this.mLeft < this.mRight) || !(this.mTop < this.mBottom);
    }

    @Override
    public final boolean isSorted() {
        return this.mLeft <= this.mRight && this.mTop <= this.mBottom;
    }

    @Override
    public final boolean isFinite() {
        return MathUtil.isFinite(this.mLeft, this.mTop, this.mRight, this.mBottom);
    }

    @Override
    public final float x() {
        return this.mLeft;
    }

    @Override
    public final float y() {
        return this.mTop;
    }

    @Override
    public final float left() {
        return this.mLeft;
    }

    @Override
    public final float top() {
        return this.mTop;
    }

    @Override
    public final float right() {
        return this.mRight;
    }

    @Override
    public final float bottom() {
        return this.mBottom;
    }

    @Override
    public final float width() {
        return this.mRight - this.mLeft;
    }

    @Override
    public final float height() {
        return this.mBottom - this.mTop;
    }

    @Override
    public final float centerX() {
        return (float)(((double)this.mLeft + (double)this.mRight) * 0.5);
    }

    @Override
    public final float centerY() {
        return (float)(((double)this.mTop + (double)this.mBottom) * 0.5);
    }

    public final float halfWidth() {
        return (float)(((double)(-this.mLeft) + (double)this.mRight) * 0.5);
    }

    public final float halfHeight() {
        return (float)(((double)(-this.mTop) + (double)this.mBottom) * 0.5);
    }

    public final void setEmpty() {
        this.mBottom = 0.0f;
        this.mTop = 0.0f;
        this.mRight = 0.0f;
        this.mLeft = 0.0f;
    }

    @Override
    public void store(@Nonnull Rect2f dst) {
        dst.mLeft = this.mLeft;
        dst.mTop = this.mTop;
        dst.mRight = this.mRight;
        dst.mBottom = this.mBottom;
    }

    @Override
    public void store(@Nonnull Rect2i dst) {
        dst.mLeft = (int)this.mLeft;
        dst.mTop = (int)this.mTop;
        dst.mRight = (int)this.mRight;
        dst.mBottom = (int)this.mBottom;
    }

    public final void set(float left, float top, float right, float bottom) {
        this.mLeft = left;
        this.mTop = top;
        this.mRight = right;
        this.mBottom = bottom;
    }

    public final void set(Rect2fc src) {
        src.store(this);
    }

    public final void set(Rect2ic src) {
        src.store(this);
    }

    public final boolean setBounds(float[] pts, int offset, int count) {
        float maxY;
        float maxX;
        if (count <= 0) {
            this.setEmpty();
            return true;
        }
        float minX = maxX = pts[offset++];
        float minY = maxY = pts[offset++];
        --count;
        float prodX = 0.0f * minX;
        float prodY = 0.0f * minY;
        for (int i = 0; i < count; ++i) {
            float x = pts[offset++];
            float y = pts[offset++];
            prodX *= x;
            prodY *= y;
            minX = Math.min(minX, x);
            minY = Math.min(minY, y);
            maxX = Math.max(maxX, x);
            maxY = Math.max(maxY, y);
        }
        if (prodX == 0.0f && prodY == 0.0f) {
            this.set(minX, minY, maxX, maxY);
            return true;
        }
        this.setEmpty();
        return false;
    }

    public final void setBoundsNoCheck(float[] pts, int offset, int count) {
        if (!this.setBounds(pts, offset, count)) {
            this.set(Float.NaN, Float.NaN, Float.NaN, Float.NaN);
        }
    }

    public final void offset(float dx, float dy) {
        this.mLeft += dx;
        this.mTop += dy;
        this.mRight += dx;
        this.mBottom += dy;
    }

    public final void offsetTo(float newLeft, float newTop) {
        this.mRight += newLeft - this.mLeft;
        this.mBottom += newTop - this.mTop;
        this.mLeft = newLeft;
        this.mTop = newTop;
    }

    public final void inset(float dx, float dy) {
        this.mLeft += dx;
        this.mTop += dy;
        this.mRight -= dx;
        this.mBottom -= dy;
    }

    public final void outset(float dx, float dy) {
        this.mLeft -= dx;
        this.mTop -= dy;
        this.mRight += dx;
        this.mBottom += dy;
    }

    public final void inset(float left, float top, float right, float bottom) {
        this.mLeft += left;
        this.mTop += top;
        this.mRight -= right;
        this.mBottom -= bottom;
    }

    public final void inset(Rect2fc insets) {
        this.mLeft += insets.left();
        this.mTop += insets.top();
        this.mRight -= insets.right();
        this.mBottom -= insets.bottom();
    }

    public final void inset(Rect2ic insets) {
        this.mLeft += (float)insets.left();
        this.mTop += (float)insets.top();
        this.mRight -= (float)insets.right();
        this.mBottom -= (float)insets.bottom();
    }

    public final void adjust(float left, float top, float right, float bottom) {
        this.mLeft += left;
        this.mTop += top;
        this.mRight += right;
        this.mBottom += bottom;
    }

    public final void adjust(Rect2fc adjusts) {
        this.mLeft += adjusts.left();
        this.mTop += adjusts.top();
        this.mRight += adjusts.right();
        this.mBottom += adjusts.bottom();
    }

    public final void adjust(Rect2ic adjusts) {
        this.mLeft += (float)adjusts.left();
        this.mTop += (float)adjusts.top();
        this.mRight += (float)adjusts.right();
        this.mBottom += (float)adjusts.bottom();
    }

    @Override
    public final boolean contains(float x, float y) {
        return x >= this.mLeft && x < this.mRight && y >= this.mTop && y < this.mBottom;
    }

    @Override
    public final boolean contains(float left, float top, float right, float bottom) {
        return this.mLeft < this.mRight && this.mTop < this.mBottom && this.mLeft <= left && this.mTop <= top && this.mRight >= right && this.mBottom >= bottom;
    }

    @Override
    public final boolean contains(@Nonnull Rect2fc r) {
        return this.mLeft < this.mRight && this.mTop < this.mBottom && this.mLeft <= r.left() && this.mTop <= r.top() && this.mRight >= r.right() && this.mBottom >= r.bottom();
    }

    @Override
    public final boolean contains(@Nonnull Rect2ic r) {
        return this.mLeft < this.mRight && this.mTop < this.mBottom && this.mLeft <= (float)r.left() && this.mTop <= (float)r.top() && this.mRight >= (float)r.right() && this.mBottom >= (float)r.bottom();
    }

    public static boolean subtract(Rect2fc a, Rect2fc b, Rect2f out) {
        assert (out != b);
        if (a.isEmpty() || b.isEmpty() || !Rect2f.intersects(a, b)) {
            if (out != a) {
                out.set(a);
            }
            return true;
        }
        float aHeight = a.height();
        float aWidth = a.width();
        float leftArea = 0.0f;
        float rightArea = 0.0f;
        float topArea = 0.0f;
        float bottomArea = 0.0f;
        int positiveCount = 0;
        if (b.left() > a.left()) {
            leftArea = (b.left() - a.left()) / aWidth;
            ++positiveCount;
        }
        if (a.right() > b.right()) {
            rightArea = (a.right() - b.right()) / aWidth;
            ++positiveCount;
        }
        if (b.top() > a.top()) {
            topArea = (b.top() - a.top()) / aHeight;
            ++positiveCount;
        }
        if (a.bottom() > b.bottom()) {
            bottomArea = (a.bottom() - b.bottom()) / aHeight;
            ++positiveCount;
        }
        if (positiveCount == 0) {
            assert (b.contains(a));
            out.setEmpty();
            return true;
        }
        if (out != a) {
            out.set(a);
        }
        if (leftArea > rightArea && leftArea > topArea && leftArea > bottomArea) {
            out.mRight = b.left();
        } else if (rightArea > topArea && rightArea > bottomArea) {
            out.mLeft = b.right();
        } else if (topArea > bottomArea) {
            out.mBottom = b.top();
        } else {
            assert (bottomArea > 0.0f);
            out.mTop = b.bottom();
        }
        assert (!Rect2f.intersects(out, b));
        return positiveCount == 1;
    }

    public final boolean intersect(float left, float top, float right, float bottom) {
        float tmpL = Math.max(this.mLeft, left);
        float tmpT = Math.max(this.mTop, top);
        float tmpR = Math.min(this.mRight, right);
        float tmpB = Math.min(this.mBottom, bottom);
        if (tmpR <= tmpL || tmpB <= tmpT) {
            return false;
        }
        this.mLeft = tmpL;
        this.mTop = tmpT;
        this.mRight = tmpR;
        this.mBottom = tmpB;
        return true;
    }

    public final boolean intersect(Rect2fc r) {
        return this.intersect(r.left(), r.top(), r.right(), r.bottom());
    }

    public final boolean intersect(Rect2ic r) {
        return this.intersect(r.left(), r.top(), r.right(), r.bottom());
    }

    public final void intersectNoCheck(float left, float top, float right, float bottom) {
        this.mLeft = Math.max(this.mLeft, left);
        this.mTop = Math.max(this.mTop, top);
        this.mRight = Math.min(this.mRight, right);
        this.mBottom = Math.min(this.mBottom, bottom);
    }

    public final void intersectNoCheck(Rect2fc r) {
        this.intersectNoCheck(r.left(), r.top(), r.right(), r.bottom());
    }

    public final void intersectNoCheck(Rect2ic r) {
        this.intersectNoCheck(r.left(), r.top(), r.right(), r.bottom());
    }

    public final boolean intersect(Rect2fc a, Rect2fc b) {
        float tmpL = Math.max(a.left(), b.left());
        float tmpT = Math.max(a.top(), b.top());
        float tmpR = Math.min(a.right(), b.right());
        float tmpB = Math.min(a.bottom(), b.bottom());
        if (tmpR <= tmpL || tmpB <= tmpT) {
            return false;
        }
        this.mLeft = tmpL;
        this.mTop = tmpT;
        this.mRight = tmpR;
        this.mBottom = tmpB;
        return true;
    }

    @Override
    public final boolean intersects(float left, float top, float right, float bottom) {
        float tmpL = Math.max(this.mLeft, left);
        float tmpT = Math.max(this.mTop, top);
        float tmpR = Math.min(this.mRight, right);
        float tmpB = Math.min(this.mBottom, bottom);
        return tmpR > tmpL && tmpB > tmpT;
    }

    @Override
    public final boolean intersects(@Nonnull Rect2fc r) {
        return this.intersects(r.left(), r.top(), r.right(), r.bottom());
    }

    @Override
    public final boolean intersects(@Nonnull Rect2ic r) {
        return this.intersects(r.left(), r.top(), r.right(), r.bottom());
    }

    public static boolean intersects(Rect2fc a, Rect2fc b) {
        float tmpL = Math.max(a.left(), b.left());
        float tmpT = Math.max(a.top(), b.top());
        float tmpR = Math.min(a.right(), b.right());
        float tmpB = Math.min(a.bottom(), b.bottom());
        return tmpR > tmpL && tmpB > tmpT;
    }

    public static boolean rectsOverlap(Rect2fc a, Rect2fc b) {
        assert (!a.isFinite() || a.left() <= a.right() && a.top() <= a.bottom());
        assert (!b.isFinite() || b.left() <= b.right() && b.top() <= b.bottom());
        return a.right() > b.left() && a.bottom() > b.top() && b.right() > a.left() && b.bottom() > a.top();
    }

    public static boolean rectsTouchOrOverlap(Rect2fc a, Rect2fc b) {
        assert (!a.isFinite() || a.left() <= a.right() && a.top() <= a.bottom());
        assert (!b.isFinite() || b.left() <= b.right() && b.top() <= b.bottom());
        return a.right() >= b.left() && a.bottom() >= b.top() && b.right() >= a.left() && b.bottom() >= a.top();
    }

    @Override
    public final void round(@Nonnull Rect2i dst) {
        dst.set(Math.round(this.mLeft), Math.round(this.mTop), Math.round(this.mRight), Math.round(this.mBottom));
    }

    @Override
    public final void roundIn(@Nonnull Rect2i dst) {
        dst.set((int)Math.ceil(this.mLeft), (int)Math.ceil(this.mTop), (int)Math.floor(this.mRight), (int)Math.floor(this.mBottom));
    }

    @Override
    public final void roundOut(@Nonnull Rect2i dst) {
        dst.set((int)Math.floor(this.mLeft), (int)Math.floor(this.mTop), (int)Math.ceil(this.mRight), (int)Math.ceil(this.mBottom));
    }

    @Override
    public final void round(@Nonnull Rect2f dst) {
        dst.set(Math.round(this.mLeft), Math.round(this.mTop), Math.round(this.mRight), Math.round(this.mBottom));
    }

    @Override
    public final void roundIn(@Nonnull Rect2f dst) {
        dst.set((float)Math.ceil(this.mLeft), (float)Math.ceil(this.mTop), (float)Math.floor(this.mRight), (float)Math.floor(this.mBottom));
    }

    @Override
    public final void roundOut(@Nonnull Rect2f dst) {
        dst.set((float)Math.floor(this.mLeft), (float)Math.floor(this.mTop), (float)Math.ceil(this.mRight), (float)Math.ceil(this.mBottom));
    }

    public final void join(float left, float top, float right, float bottom) {
        if (left >= right || top >= bottom) {
            return;
        }
        if (this.mLeft < this.mRight && this.mTop < this.mBottom) {
            if (this.mLeft > left) {
                this.mLeft = left;
            }
            if (this.mTop > top) {
                this.mTop = top;
            }
            if (this.mRight < right) {
                this.mRight = right;
            }
            if (this.mBottom < bottom) {
                this.mBottom = bottom;
            }
        } else {
            this.mLeft = left;
            this.mTop = top;
            this.mRight = right;
            this.mBottom = bottom;
        }
    }

    public final void join(Rect2fc r) {
        this.join(r.left(), r.top(), r.right(), r.bottom());
    }

    public final void join(Rect2ic r) {
        this.join(r.left(), r.top(), r.right(), r.bottom());
    }

    public final void joinNoCheck(float left, float top, float right, float bottom) {
        this.mLeft = Math.min(this.mLeft, left);
        this.mTop = Math.min(this.mTop, top);
        this.mRight = Math.max(this.mRight, right);
        this.mBottom = Math.max(this.mBottom, bottom);
    }

    public final void joinNoCheck(Rect2fc r) {
        this.joinNoCheck(r.left(), r.top(), r.right(), r.bottom());
    }

    public final void joinNoCheck(Rect2ic r) {
        this.joinNoCheck(r.left(), r.top(), r.right(), r.bottom());
    }

    public final void join(float x, float y) {
        if (this.mLeft < this.mRight && this.mTop < this.mBottom) {
            if (x < this.mLeft) {
                this.mLeft = x;
            } else if (x > this.mRight) {
                this.mRight = x;
            }
            if (y < this.mTop) {
                this.mTop = y;
            } else if (y > this.mBottom) {
                this.mBottom = y;
            }
        } else {
            this.mLeft = this.mRight = x;
            this.mTop = this.mBottom = y;
        }
    }

    public final void sort() {
        float temp;
        if (this.mLeft > this.mRight) {
            temp = this.mLeft;
            this.mLeft = this.mRight;
            this.mRight = temp;
        }
        if (this.mTop > this.mBottom) {
            temp = this.mTop;
            this.mTop = this.mBottom;
            this.mBottom = temp;
        }
    }

    public int hashCode() {
        int result = this.mLeft != 0.0f ? Float.floatToIntBits(this.mLeft) : 0;
        result = 31 * result + (this.mTop != 0.0f ? Float.floatToIntBits(this.mTop) : 0);
        result = 31 * result + (this.mRight != 0.0f ? Float.floatToIntBits(this.mRight) : 0);
        result = 31 * result + (this.mBottom != 0.0f ? Float.floatToIntBits(this.mBottom) : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Rect2fc)) {
            return false;
        }
        Rect2fc r = (Rect2fc)o;
        return this.mLeft == r.left() && this.mTop == r.top() && this.mRight == r.right() && this.mBottom == r.bottom();
    }

    public String toString() {
        return "Rect2f(" + this.mLeft + ", " + this.mTop + ", " + this.mRight + ", " + this.mBottom + ")";
    }
}

