/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core;

import icyllis.arc3d.core.BlendMode;
import icyllis.arc3d.core.Blender;
import icyllis.arc3d.core.ColorInt;
import icyllis.arc3d.core.ColorSpace;
import icyllis.arc3d.core.ImageFilter;
import icyllis.arc3d.core.MathUtil;
import icyllis.arc3d.core.PathEffect;
import icyllis.arc3d.core.RawPtr;
import icyllis.arc3d.core.Rect2f;
import icyllis.arc3d.core.Rect2fc;
import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.core.Size;
import icyllis.arc3d.core.StrokeRec;
import icyllis.arc3d.core.effects.ColorFilter;
import icyllis.arc3d.core.shaders.Shader;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;

public class Paint
implements AutoCloseable {
    public static final int FILL = 0;
    public static final int STROKE = 1;
    public static final int STROKE_AND_FILL = 2;
    public static final int FILL_AND_STROKE = 2;
    private static final int STYLE_SHIFT = 0;
    private static final int STYLE_MASK = 3;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    @ApiStatus.Internal
    public static final int CAP_COUNT = 3;
    private static final int CAP_SHIFT = 2;
    private static final int CAP_MASK = 12;
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_BEVEL = 2;
    @ApiStatus.Internal
    public static final int JOIN_COUNT = 3;
    private static final int JOIN_SHIFT = 4;
    private static final int JOIN_MASK = 48;
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_INSIDE = 1;
    public static final int ALIGN_OUTSIDE = 2;
    @ApiStatus.Internal
    public static final int ALIGN_COUNT = 3;
    private static final int ALIGN_SHIFT = 6;
    private static final int ALIGN_MASK = 192;
    private static final int ANTI_ALIAS_MASK = 65536;
    private static final int DITHER_MASK = 131072;
    private static final int DEFAULT_FLAGS = 65556;
    private float mR;
    private float mG;
    private float mB;
    private float mA;
    private float mWidth;
    private float mMiterLimit;
    private PathEffect mPathEffect;
    @SharedPtr
    private Shader mShader;
    @SharedPtr
    private ColorFilter mColorFilter;
    @SharedPtr
    private Blender mBlender;
    private int mFlags;

    public Paint() {
        this.reset();
    }

    public Paint(@Nullable Paint paint) {
        this.set(paint);
    }

    public void reset() {
        this.mR = 1.0f;
        this.mG = 1.0f;
        this.mB = 1.0f;
        this.mA = 1.0f;
        this.mWidth = 1.0f;
        this.mMiterLimit = 4.0f;
        this.mPathEffect = null;
        this.mShader = RefCnt.move(this.mShader);
        this.mColorFilter = RefCnt.move(this.mColorFilter);
        this.mBlender = RefCnt.move(this.mBlender);
        this.mFlags = 65556;
    }

    public void set(Paint paint) {
        if (paint == null) {
            this.reset();
        } else {
            this.mR = paint.mR;
            this.mG = paint.mG;
            this.mB = paint.mB;
            this.mA = paint.mA;
            this.mWidth = paint.mWidth;
            this.mMiterLimit = paint.mMiterLimit;
            this.mPathEffect = paint.mPathEffect;
            this.mShader = RefCnt.create(this.mShader, paint.mShader);
            this.mColorFilter = RefCnt.create(this.mColorFilter, paint.mColorFilter);
            this.mBlender = RefCnt.create(this.mBlender, paint.mBlender);
            this.mFlags = paint.mFlags;
        }
    }

    @Override
    public void close() {
        this.mShader = RefCnt.move(this.mShader);
        this.mColorFilter = RefCnt.move(this.mColorFilter);
        this.mBlender = RefCnt.move(this.mBlender);
    }

    @ColorInt
    public int getColor() {
        return (int)(this.mA * 255.0f + 0.5f) << 24 | (int)(this.mR * 255.0f + 0.5f) << 16 | (int)(this.mG * 255.0f + 0.5f) << 8 | (int)(this.mB * 255.0f + 0.5f);
    }

    public void setColor(@ColorInt int color) {
        this.mA = (float)(color >>> 24) * 0.003921569f;
        this.mR = (float)(color >> 16 & 0xFF) * 0.003921569f;
        this.mG = (float)(color >> 8 & 0xFF) * 0.003921569f;
        this.mB = (float)(color & 0xFF) * 0.003921569f;
    }

    public final float r() {
        return this.mR;
    }

    public final float g() {
        return this.mG;
    }

    public final float b() {
        return this.mB;
    }

    public final float a() {
        return this.mA;
    }

    public final void getColor4f(@Nonnull @Size(value=4L) float[] dst) {
        dst[0] = this.mR;
        dst[1] = this.mG;
        dst[2] = this.mB;
        dst[3] = this.mA;
    }

    public final void setColor4f(float r, float g, float b, float a) {
        this.mR = MathUtil.pin(r, 0.0f, 1.0f);
        this.mG = MathUtil.pin(g, 0.0f, 1.0f);
        this.mB = MathUtil.pin(b, 0.0f, 1.0f);
        this.mA = MathUtil.pin(a, 0.0f, 1.0f);
    }

    public final void setColor4f(float r, float g, float b, float a, @Nullable ColorSpace colorSpace) {
        if (colorSpace != null && !colorSpace.isSrgb()) {
            float[] c = ColorSpace.connect(colorSpace).transform(r, g, b);
            this.setColor4f(c[0], c[1], c[2], a);
        } else {
            this.setColor4f(r, g, b, a);
        }
    }

    public float getAlphaF() {
        return this.mA;
    }

    public int getAlpha() {
        return (int)(this.mA * 255.0f + 0.5f);
    }

    public void setAlphaF(float a) {
        this.mA = MathUtil.pin(a, 0.0f, 1.0f);
    }

    public void setAlpha(int a) {
        this.mA = MathUtil.pin((float)a * 0.003921569f, 0.0f, 1.0f);
    }

    public final void setRGB(int r, int g, int b) {
        this.mR = MathUtil.pin((float)r * 0.003921569f, 0.0f, 1.0f);
        this.mG = MathUtil.pin((float)g * 0.003921569f, 0.0f, 1.0f);
        this.mB = MathUtil.pin((float)b * 0.003921569f, 0.0f, 1.0f);
    }

    public final void setRGBA(int r, int g, int b, int a) {
        this.mR = MathUtil.pin((float)r * 0.003921569f, 0.0f, 1.0f);
        this.mG = MathUtil.pin((float)g * 0.003921569f, 0.0f, 1.0f);
        this.mB = MathUtil.pin((float)b * 0.003921569f, 0.0f, 1.0f);
        this.mA = MathUtil.pin((float)a * 0.003921569f, 0.0f, 1.0f);
    }

    public void setARGB(int a, int r, int g, int b) {
        this.mA = MathUtil.pin((float)a * 0.003921569f, 0.0f, 1.0f);
        this.mR = MathUtil.pin((float)r * 0.003921569f, 0.0f, 1.0f);
        this.mG = MathUtil.pin((float)g * 0.003921569f, 0.0f, 1.0f);
        this.mB = MathUtil.pin((float)b * 0.003921569f, 0.0f, 1.0f);
    }

    public final boolean isAntiAlias() {
        return (this.mFlags & 0x10000) != 0;
    }

    public final void setAntiAlias(boolean aa) {
        this.mFlags = aa ? (this.mFlags |= 0x10000) : (this.mFlags &= 0xFFFEFFFF);
    }

    public final boolean isDither() {
        return (this.mFlags & 0x20000) != 0;
    }

    public final void setDither(boolean dither) {
        this.mFlags = dither ? (this.mFlags |= 0x20000) : (this.mFlags &= 0xFFFDFFFF);
    }

    public int getStyle() {
        return (this.mFlags & 3) >>> 0;
    }

    public void setStyle(int style) {
        this.mFlags = this.mFlags & 0xFFFFFFFC | style << 0 & 3;
    }

    public final void setStroke(boolean stroke) {
        this.mFlags = this.mFlags & 0xFFFFFFFC | (stroke ? 1 : 0);
    }

    public int getStrokeCap() {
        return (this.mFlags & 0xC) >>> 2;
    }

    public void setStrokeCap(int cap) {
        this.mFlags = this.mFlags & 0xFFFFFFF3 | cap << 2 & 0xC;
    }

    public int getStrokeJoin() {
        return (this.mFlags & 0x30) >>> 4;
    }

    public void setStrokeJoin(int join) {
        this.mFlags = this.mFlags & 0xFFFFFFCF | join << 4 & 0x30;
    }

    public final int getStrokeAlign() {
        return (this.mFlags & 0xC0) >>> 6;
    }

    public final void setStrokeAlign(int align) {
        this.mFlags = this.mFlags & 0xFFFFFF3F | align << 6 & 0xC0;
    }

    public float getStrokeWidth() {
        return this.mWidth;
    }

    public void setStrokeWidth(float width) {
        if (width >= 0.0f) {
            this.mWidth = width;
        }
    }

    public float getStrokeMiter() {
        return this.mMiterLimit;
    }

    public void setStrokeMiter(float miter) {
        if (miter >= 0.0f) {
            this.mMiterLimit = miter;
        }
    }

    @Nullable
    @RawPtr
    public Shader getShader() {
        return this.mShader;
    }

    @Nullable
    @SharedPtr
    public Shader refShader() {
        return RefCnt.create(this.mShader);
    }

    public void setShader(@Nullable @SharedPtr Shader shader) {
        this.mShader = RefCnt.move(this.mShader, shader);
    }

    @Nullable
    @RawPtr
    public ColorFilter getColorFilter() {
        return this.mColorFilter;
    }

    @Nullable
    @SharedPtr
    public ColorFilter refColorFilter() {
        return RefCnt.create(this.mColorFilter);
    }

    public void setColorFilter(@Nullable @SharedPtr ColorFilter colorFilter) {
        this.mColorFilter = RefCnt.move(this.mColorFilter, colorFilter);
    }

    @Nullable
    public BlendMode getBlendMode() {
        return this.mBlender != null ? this.mBlender.asBlendMode() : BlendMode.SRC_OVER;
    }

    public final boolean isSrcOver() {
        return this.mBlender == null || this.mBlender.asBlendMode() == BlendMode.SRC_OVER;
    }

    public void setBlendMode(@Nullable BlendMode mode) {
        this.setBlender(mode == BlendMode.SRC_OVER ? null : mode);
    }

    @Nullable
    @RawPtr
    public final Blender getBlender() {
        return this.mBlender;
    }

    @Nullable
    @SharedPtr
    public Blender refBlender() {
        return RefCnt.create(this.mBlender);
    }

    public final void setBlender(@Nullable @SharedPtr Blender blender) {
        this.mBlender = RefCnt.move(this.mBlender, blender);
    }

    public final PathEffect getPathEffect() {
        return this.mPathEffect;
    }

    public final void setPathEffect(@Nullable PathEffect pathEffect) {
        this.mPathEffect = pathEffect;
    }

    public boolean nothingToDraw() {
        BlendMode mode = this.getBlendMode();
        if (mode != null) {
            boolean checkAlpha;
            switch (mode) {
                case SRC_OVER: 
                case DST_OVER: 
                case DST_OUT: 
                case SRC_ATOP: 
                case XOR: 
                case PLUS: 
                case PLUS_CLAMPED: 
                case MINUS: 
                case MINUS_CLAMPED: {
                    checkAlpha = true;
                    break;
                }
                case DST: {
                    return true;
                }
                default: {
                    checkAlpha = mode.isAdvanced();
                }
            }
            if (checkAlpha && this.getAlphaF() == 0.0f) {
                return !Paint.isBlendedColorFilter(this.mColorFilter);
            }
        }
        return false;
    }

    @ApiStatus.Internal
    public final boolean canComputeFastBounds(@Nullable @RawPtr ImageFilter imageFilter) {
        return imageFilter == null || imageFilter.canComputeFastBounds();
    }

    @ApiStatus.Internal
    public final void computeFastBounds(@Nullable @RawPtr ImageFilter imageFilter, Rect2fc orig, Rect2f storage) {
        int style = this.getStyle();
        if (style == 0 && imageFilter == null) {
            storage.set(orig);
            return;
        }
        storage.set(orig);
        if (style != 0) {
            float stroke = StrokeRec.getInflationRadius(this.mWidth, this.getStrokeCap(), this.getStrokeJoin(), this.getStrokeAlign(), this.mMiterLimit);
            storage.outset(stroke, stroke);
        }
        if (imageFilter != null) {
            imageFilter.computeFastBounds(storage, storage);
        }
    }

    public int hashCode() {
        int result = this.mFlags;
        result = 31 * result + Float.floatToIntBits(this.mR);
        result = 31 * result + Float.floatToIntBits(this.mG);
        result = 31 * result + Float.floatToIntBits(this.mB);
        result = 31 * result + Float.floatToIntBits(this.mA);
        result = 31 * result + Float.floatToIntBits(this.mWidth);
        result = 31 * result + Float.floatToIntBits(this.mMiterLimit);
        result = 31 * result + Objects.hashCode(this.mPathEffect);
        result = 31 * result + Objects.hashCode(this.mShader);
        result = 31 * result + Objects.hashCode(this.mColorFilter);
        result = 31 * result + Objects.hashCode(this.mBlender);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Paint)) {
            return false;
        }
        Paint paint = (Paint)o;
        return this.equals(paint);
    }

    protected final boolean equals(Paint paint) {
        return this.mFlags == paint.mFlags && this.mR == paint.mR && this.mG == paint.mG && this.mB == paint.mB && this.mA == paint.mA && this.mWidth == paint.mWidth && this.mMiterLimit == paint.mMiterLimit && Objects.equals(this.mPathEffect, paint.mPathEffect) && Objects.equals(this.mShader, paint.mShader) && Objects.equals(this.mColorFilter, paint.mColorFilter) && Objects.equals(this.mBlender, paint.mBlender);
    }

    public String toString() {
        StringBuilder s = new StringBuilder("Paint{");
        s.append("mColor4f=(");
        s.append(this.mR);
        s.append(", ");
        s.append(this.mG);
        s.append(", ");
        s.append(this.mB);
        s.append(", ");
        s.append(this.mA);
        int style = this.getStyle();
        s.append("), mStyle=");
        if (style == 0) {
            s.append("FILL");
        } else if (style == 1) {
            s.append("STROKE");
        } else {
            s.append("STROKE_AND_FILL");
        }
        int cap = this.getStrokeCap();
        s.append(", mCap=");
        if (cap == 1) {
            s.append("ROUND");
        } else if (cap == 2) {
            s.append("SQUARE");
        } else {
            s.append("BUTT");
        }
        int join = this.getStrokeJoin();
        s.append(", mJoin=");
        if (join == 1) {
            s.append("ROUND");
        } else if (join == 2) {
            s.append("BEVEL");
        } else {
            s.append("MITER");
        }
        int align = this.getStrokeAlign();
        s.append(", mAlign=");
        if (align == 0) {
            s.append("CENTER");
        } else if (align == 1) {
            s.append("INSIDE");
        } else {
            s.append("OUTSIDE");
        }
        s.append(", mAntiAlias=");
        s.append(this.isAntiAlias());
        s.append(", mDither=");
        s.append(this.isDither());
        s.append(", mWidth=");
        s.append(this.mWidth);
        s.append(", mMiterLimit=");
        s.append(this.mMiterLimit);
        s.append(", mPathEffect=");
        s.append(this.mPathEffect);
        s.append(", mShader=");
        s.append(this.mShader);
        s.append(", mColorFilter=");
        s.append(this.mColorFilter);
        s.append(", mBlender=");
        s.append(this.mBlender);
        s.append('}');
        return s.toString();
    }

    @ApiStatus.Internal
    public static int getAlphaDirect(@Nullable Paint paint) {
        return paint != null ? paint.getAlpha() : 255;
    }

    @ApiStatus.Internal
    public static BlendMode getBlendModeDirect(@Nullable Paint paint) {
        if (paint != null) {
            return paint.getBlendMode();
        }
        return BlendMode.SRC_OVER;
    }

    @ApiStatus.Internal
    public static boolean isBlendedShader(@Nullable Shader shader) {
        return shader != null && !shader.isOpaque();
    }

    @ApiStatus.Internal
    public static boolean isBlendedColorFilter(@Nullable ColorFilter filter) {
        return filter != null && !filter.isAlphaUnchanged();
    }

    @ApiStatus.Internal
    public static boolean isBlendedImageFilter(@Nullable ImageFilter filter) {
        return filter != null;
    }

    @ApiStatus.Internal
    public static boolean isOpaquePaint(@Nullable Paint paint) {
        if (paint == null) {
            return true;
        }
        if (paint.getAlphaF() != 1.0f || Paint.isBlendedShader(paint.mShader) || Paint.isBlendedColorFilter(paint.mColorFilter)) {
            return false;
        }
        BlendMode mode = Paint.getBlendModeDirect(paint);
        return mode == BlendMode.SRC_OVER || mode == BlendMode.SRC;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Align {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Join {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Cap {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Style {
    }
}

