/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core;

import icyllis.arc3d.core.MathUtil;
import icyllis.arc3d.core.Path;
import icyllis.arc3d.core.Rect2f;
import icyllis.arc3d.core.Rect2i;
import icyllis.arc3d.core.ScalerContext;
import icyllis.arc3d.core.Strike;
import javax.annotation.Nonnull;
import sun.misc.Unsafe;

public final class Glyph {
    public static final int kUnset_Action = 0;
    public static final int kAccept_Action = 1;
    public static final int kReject_Action = 2;
    public static final int kDrop_Action = 3;
    static final int kActionMask = 3;
    public static final int kDirectMask = 0;
    public static final int kTransformedMask = 2;
    public static final int kPath = 4;
    public static final int kDrawable = 6;
    public static final int kSDF = 8;
    public static final int kMSDF = 10;
    private static final int kMaxGlyphWidth = 8192;
    static final int kSizeOf = 48;
    public static final int BILERP_GLYPH_BORDER = 1;
    public static final int MAX_ATLAS_DIMENSION = 256;
    public static final int MAX_BILERP_ATLAS_DIMENSION = 254;
    private final int mID;
    short mTop = 0;
    short mLeft = 0;
    short mWidth = 0;
    short mHeight = 0;
    Object mImage;
    Path mPath;
    boolean mPathIsRequested;
    byte mMaskFormat;
    private short mActions;

    public Glyph(int id2) {
        this.mID = id2;
    }

    public int getGlyphID() {
        return this.mID;
    }

    public int getLeft() {
        return this.mLeft;
    }

    public int getTop() {
        return this.mTop;
    }

    public int getWidth() {
        return this.mWidth & 0xFFFF;
    }

    public int getHeight() {
        return this.mHeight & 0xFFFF;
    }

    public int getMaxDimension() {
        return Math.max(this.getWidth(), this.getHeight());
    }

    public void getBounds(@Nonnull Rect2i dst) {
        dst.set(this.mLeft, this.mTop, this.mLeft + this.getWidth(), this.mTop + this.getHeight());
    }

    public void getBounds(@Nonnull Rect2f dst) {
        dst.set(this.mLeft, this.mTop, this.mLeft + this.getWidth(), this.mTop + this.getHeight());
    }

    public boolean isEmpty() {
        return this.mWidth == 0 || this.mHeight == 0;
    }

    public byte getMaskFormat() {
        return this.mMaskFormat;
    }

    public boolean isColor() {
        return this.mMaskFormat == 3;
    }

    public boolean imageIsTooLarge() {
        return this.getWidth() >= 8192;
    }

    public boolean setImage(ScalerContext scalerContext) {
        if (!this.setImageHasBeenCalled()) {
            int size = this.getImageSize();
            assert (size > 0);
            if (this.mMaskFormat == 3) {
                assert (MathUtil.isAlign4(size));
                this.mImage = new int[size >> 2];
            } else {
                assert (this.mMaskFormat == 0 || this.mMaskFormat == 1);
                this.mImage = new byte[size];
            }
            scalerContext.getImage(this);
            return true;
        }
        return false;
    }

    public boolean setImageHasBeenCalled() {
        return this.mImage != null || this.isEmpty() || this.imageIsTooLarge();
    }

    public Object getImageBase() {
        assert (this.setImageHasBeenCalled());
        return this.mImage;
    }

    public long getImageAddress() {
        assert (this.setImageHasBeenCalled());
        if (this.mImage instanceof byte[]) {
            return Unsafe.ARRAY_BYTE_BASE_OFFSET;
        }
        if (this.mImage instanceof int[]) {
            return Unsafe.ARRAY_INT_BASE_OFFSET;
        }
        return 0L;
    }

    public int getRowBytes() {
        int width = this.getWidth();
        return switch (this.mMaskFormat) {
            case 0 -> width + 7 >> 3;
            case 1 -> width;
            case 3 -> width << 2;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                yield 0;
            }
        };
    }

    public int getImageSize() {
        if (this.isEmpty() || this.imageIsTooLarge()) {
            return 0;
        }
        return this.getRowBytes() * this.getHeight();
    }

    public boolean setPath(ScalerContext scalerContext) {
        if (!this.setPathHasBeenCalled()) {
            scalerContext.getPath(this);
            assert (this.setPathHasBeenCalled());
            return this.getPath() != null;
        }
        return false;
    }

    public boolean setPath(Path path) {
        if (!this.setPathHasBeenCalled()) {
            this.mPathIsRequested = true;
            if (path != null) {
                this.mPath = new Path(path);
                this.mPath.updateBoundsCache();
            }
            return this.getPath() != null;
        }
        return false;
    }

    public boolean setPathHasBeenCalled() {
        return this.mPathIsRequested;
    }

    public Path getPath() {
        assert (this.setPathHasBeenCalled());
        return this.mPath;
    }

    public int actionFor(int actionType) {
        return this.mActions >>> actionType & 3;
    }

    void setActionFor(int actionType, Strike strike) {
        if (this.actionFor(actionType) == 0) {
            int action = 2;
            switch (actionType) {
                case 0: {
                    if (this.getMaxDimension() > 256) break;
                    action = 1;
                    break;
                }
                case 2: {
                    if (this.getMaxDimension() > 254) break;
                    action = 1;
                    break;
                }
                case 4: {
                    if (!strike.prepareForPath(this)) break;
                    action = 1;
                }
            }
            this.mActions = (short)(this.mActions | (short)(action << actionType));
        }
    }

    void initActions() {
        this.mActions = (short)(this.isEmpty() ? 4095 : 0);
    }
}

