/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core;

import icyllis.arc3d.core.Matrixc;
import icyllis.arc3d.core.Typeface;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.ApiStatus;

public class Font {
    public static final int kAlias_Edging = 0;
    public static final int kAntiAlias_Edging = 1;
    static final int kLinearMetrics_Flag = 4;
    private Typeface mTypeface;
    private float mSize;
    private byte mFlags;
    private byte mEdging;

    public Font() {
    }

    public Font(@Nonnull Font other) {
        this.set(other);
    }

    public void set(@Nonnull Font other) {
        this.mTypeface = other.mTypeface;
        this.mSize = other.mSize;
        this.mFlags = other.mFlags;
        this.mEdging = other.mEdging;
    }

    public void setTypeface(Typeface typeface) {
        this.mTypeface = typeface;
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    public float getSize() {
        return this.mSize;
    }

    public void setSize(float size) {
        if (size >= 0.0f) {
            this.mSize = size;
        }
    }

    public int getEdging() {
        return this.mEdging;
    }

    public void setEdging(int edging) {
        this.mEdging = (byte)edging;
    }

    public boolean isLinearMetrics() {
        return (this.mFlags & 4) != 0;
    }

    public void setLinearMetrics(boolean linearMetrics) {
        this.mFlags = linearMetrics ? (byte)(this.mFlags | 4) : (byte)(this.mFlags & 0xFFFFFFFB);
    }

    @ApiStatus.Internal
    public float approximateTransformedFontSize(Matrixc matrix, float centerX, float centerY) {
        if (matrix.hasPerspective()) {
            float scaleSq = matrix.differentialAreaScale(centerX, centerY);
            if (scaleSq <= 1.0E-5f || !Float.isFinite(scaleSq)) {
                return -this.mSize;
            }
            return (float)((double)this.mSize * Math.sqrt(scaleSq));
        }
        return this.mSize * matrix.getMaxScale();
    }

    public int hashCode() {
        int result = this.mTypeface != null ? this.mTypeface.hashCode() : 0;
        result = 31 * result + Float.floatToIntBits(this.mSize);
        result = 31 * result + this.mFlags;
        result = 31 * result + this.mEdging;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Font font = (Font)o;
        if (this.mSize != font.mSize) {
            return false;
        }
        if (this.mFlags != font.mFlags) {
            return false;
        }
        if (this.mEdging != font.mEdging) {
            return false;
        }
        return Objects.equals(this.mTypeface, font.mTypeface);
    }
}

