/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.compiler.tree;

import icyllis.arc3d.compiler.Context;
import icyllis.arc3d.compiler.tree.Expression;
import icyllis.arc3d.compiler.tree.Node;
import icyllis.arc3d.compiler.tree.TreeVisitor;
import icyllis.arc3d.compiler.tree.Type;
import javax.annotation.Nonnull;

public final class TypeReference
extends Expression {
    private final Type mValue;

    private TypeReference(int position, Type value, Type type) {
        super(position, type);
        this.mValue = value;
    }

    @Nonnull
    public static TypeReference make(@Nonnull Context context, int position, @Nonnull Type value) {
        return new TypeReference(position, value, context.getTypes().mInvalid);
    }

    @Override
    public Node.ExpressionKind getKind() {
        return Node.ExpressionKind.TYPE_REFERENCE;
    }

    @Override
    public boolean accept(@Nonnull TreeVisitor visitor) {
        return visitor.visitTypeReference(this);
    }

    public Type getValue() {
        return this.mValue;
    }

    @Override
    @Nonnull
    public Expression clone(int position) {
        return new TypeReference(position, this.mValue, this.getType());
    }

    @Override
    @Nonnull
    public String toString(int parentPrecedence) {
        return this.mValue.getName();
    }
}

