/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.compiler.tree;

import icyllis.arc3d.compiler.Context;
import icyllis.arc3d.compiler.tree.Expression;
import icyllis.arc3d.compiler.tree.Node;
import icyllis.arc3d.compiler.tree.Statement;
import icyllis.arc3d.compiler.tree.TreeVisitor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ExpressionStatement
extends Statement {
    private Expression mExpression;

    public ExpressionStatement(Expression expression) {
        super(expression.mPosition);
        this.mExpression = expression;
    }

    @Nullable
    public static Statement convert(@Nonnull Context context, Expression expr) {
        if (expr.isIncomplete(context)) {
            return null;
        }
        return ExpressionStatement.make(expr);
    }

    public static Statement make(Expression expr) {
        return new ExpressionStatement(expr);
    }

    @Override
    public Node.StatementKind getKind() {
        return Node.StatementKind.EXPRESSION;
    }

    @Override
    public boolean accept(@Nonnull TreeVisitor visitor) {
        if (visitor.visitExpression(this)) {
            return true;
        }
        return this.mExpression.accept(visitor);
    }

    public Expression getExpression() {
        return this.mExpression;
    }

    public void setExpression(Expression expression) {
        this.mExpression = expression;
    }

    @Override
    @Nonnull
    public String toString() {
        return this.mExpression.toString(18) + ";";
    }
}

