/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.compiler.tree;

import icyllis.arc3d.compiler.ConstantFolder;
import icyllis.arc3d.compiler.Context;
import icyllis.arc3d.compiler.tree.ConstructorCall;
import icyllis.arc3d.compiler.tree.Expression;
import icyllis.arc3d.compiler.tree.Literal;
import icyllis.arc3d.compiler.tree.Node;
import icyllis.arc3d.compiler.tree.Type;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ConstructorScalarCast
extends ConstructorCall {
    private ConstructorScalarCast(int position, Type type, Expression ... arguments) {
        super(position, type, arguments);
        assert (arguments.length == 1);
    }

    @Nullable
    public static Expression convert(@Nonnull Context context, int pos, @Nonnull Type type, @Nonnull List<Expression> args) {
        assert (type.isScalar());
        if (args.size() != 1) {
            context.error(pos, "invalid arguments to '" + type + "' constructor, (expected exactly 1 argument, but found " + args.size() + ")");
            return null;
        }
        Type argType = args.get(0).getType();
        if (!argType.isScalar()) {
            String swizzleHint = "";
            if (argType.getComponentType().matches(type)) {
                if (argType.isVector()) {
                    swizzleHint = "; use '.x' instead";
                } else if (argType.isMatrix()) {
                    swizzleHint = "; use '[0][0]' instead";
                }
            }
            context.error(pos, "'" + argType + "' is not a valid parameter to '" + type + "' constructor" + swizzleHint);
            return null;
        }
        return ConstructorScalarCast.make(context, pos, type, args.get(0));
    }

    public static Expression make(@Nonnull Context context, int position, Type type, Expression arg) {
        assert (type.isScalar());
        assert (arg.getType().isScalar());
        if (arg.getType().matches(type)) {
            return arg;
        }
        if ((arg = ConstantFolder.makeConstantValueForVariable(position, arg)) instanceof Literal) {
            Literal literal = (Literal)arg;
            double value = literal.getValue();
            if (type.isNumeric() && (value < type.getMinValue() || value > type.getMaxValue())) {
                context.error(position, String.format("value is out of range for type '%s': %.0f", type.getName(), value));
                value = 0.0;
            }
            return Literal.make(position, value, type);
        }
        return new ConstructorScalarCast(position, type, arg);
    }

    @Override
    public Node.ExpressionKind getKind() {
        return Node.ExpressionKind.CONSTRUCTOR_SCALAR_CAST;
    }

    @Override
    @Nonnull
    public Expression clone(int position) {
        return new ConstructorScalarCast(position, this.getType(), this.cloneArguments());
    }
}

