/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.compiler.lex;

import icyllis.arc3d.compiler.lex.DFA;
import icyllis.arc3d.compiler.lex.DFAState;
import icyllis.arc3d.compiler.lex.NFA;
import icyllis.arc3d.compiler.lex.NFAState;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.Unmodifiable;

public class NFAtoDFA {
    public static final char START_CHAR = '\t';
    public static final char END_CHAR = '~';
    private final NFA mNFA;
    private final Map<IntList, DFAState> mStates = new HashMap<IntList, DFAState>();
    private final List<IntList> mTransitions = new ArrayList<IntList>();
    private final IntList mCharMappings = new IntArrayList();
    private final IntList mAccepts = new IntArrayList();

    public NFAtoDFA(NFA NFA2) {
        this.mNFA = NFA2;
    }

    @Nonnull
    public DFA convert() {
        this.getOrCreate(IntList.of());
        IntArrayList n = new IntArrayList(this.mNFA.mStartStates);
        n.sort(null);
        DFAState start = this.getOrCreate((IntList)n);
        this.traverse(start);
        this.computeMappings();
        int[][] transitions = new int[this.mTransitions.size()][];
        Arrays.setAll(transitions, i -> this.mTransitions.get(i).toIntArray());
        return new DFA(this.mCharMappings.toIntArray(), transitions, this.mAccepts.toIntArray());
    }

    @Nonnull
    private DFAState getOrCreate(@Unmodifiable IntList states) {
        DFAState result = this.mStates.get(states);
        if (result == null) {
            int index = this.mStates.size();
            result = new DFAState(index, states);
            this.mStates.put(states, result);
        }
        return result;
    }

    private void add(int index, IntList states) {
        NFAState state = this.mNFA.get(index);
        if (state instanceof NFAState.Replace) {
            NFAState.Replace replace = (NFAState.Replace)state;
            IntListIterator intListIterator = replace.mShadow.iterator();
            while (intListIterator.hasNext()) {
                int i = (Integer)intListIterator.next();
                this.add(i, states);
            }
        } else if (!states.contains(index)) {
            states.add(index);
        }
    }

    private void addTransition(char c, int curr, int next) {
        while (this.mTransitions.size() <= c) {
            this.mTransitions.add((IntList)new IntArrayList());
        }
        IntList row = this.mTransitions.get(c);
        while (row.size() <= curr) {
            row.add(-1);
        }
        row.set(curr, next);
    }

    private void traverse(@Nonnull DFAState curr) {
        curr.mScanned = true;
        for (char c = '\t'; c <= '~'; c = (char)(c + '\u0001')) {
            IntArrayList n = new IntArrayList();
            int best = Integer.MAX_VALUE;
            IntListIterator intListIterator = curr.mStates.iterator();
            while (intListIterator.hasNext()) {
                int index = (Integer)intListIterator.next();
                NFAState state = this.mNFA.get(index);
                if (!state.accept(c)) continue;
                IntListIterator intListIterator2 = state.next().iterator();
                while (intListIterator2.hasNext()) {
                    int i = (Integer)intListIterator2.next();
                    NFAState nFAState = this.mNFA.get(i);
                    if (nFAState instanceof NFAState.Accept) {
                        NFAState.Accept e = (NFAState.Accept)nFAState;
                        best = Math.min(best, e.mToken);
                    }
                    this.add(i, (IntList)n);
                }
            }
            n.sort(null);
            DFAState next = this.getOrCreate((IntList)n);
            this.addTransition(c, curr.mIndex, next.mIndex);
            if (best != Integer.MAX_VALUE) {
                while (this.mAccepts.size() <= next.mIndex) {
                    this.mAccepts.add(-1);
                }
                this.mAccepts.set(next.mIndex, best);
            }
            if (next.mScanned) continue;
            this.traverse(next);
        }
    }

    private void computeMappings() {
        ArrayList<IntList> uniques = new ArrayList<IntList>();
        for (IntList transition : this.mTransitions) {
            int found = uniques.indexOf(transition);
            if (found == -1) {
                found = uniques.size();
                uniques.add(transition);
            }
            this.mCharMappings.add(found);
        }
        this.mTransitions.clear();
        this.mTransitions.addAll(uniques);
    }
}

