/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.compiler;

import icyllis.arc3d.compiler.BuiltinTypes;
import icyllis.arc3d.compiler.CompileOptions;
import icyllis.arc3d.compiler.ShaderKind;
import icyllis.arc3d.compiler.SymbolTable;
import icyllis.arc3d.compiler.analysis.SymbolUsage;
import icyllis.arc3d.compiler.tree.Node;
import icyllis.arc3d.compiler.tree.TopLevelElement;
import icyllis.arc3d.compiler.tree.TreeVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public final class TranslationUnit
extends Node
implements Iterable<TopLevelElement> {
    private final char[] mSource;
    private final int mSourceOffset;
    private final int mSourceLength;
    private final ShaderKind mKind;
    private final CompileOptions mOptions;
    private final BuiltinTypes mTypes;
    private final SymbolTable mSymbolTable;
    private final ArrayList<TopLevelElement> mUniqueElements;
    private final ArrayList<TopLevelElement> mSharedElements;
    private final List<Map.Entry<String, String>> mExtensions;
    private final SymbolUsage mUsage;

    public TranslationUnit(char[] source, int sourceOffset, int sourceLength, ShaderKind kind, CompileOptions options, BuiltinTypes types, SymbolTable symbolTable, ArrayList<TopLevelElement> uniqueElements, List<Map.Entry<String, String>> extensions) {
        super(-1);
        this.mSource = source;
        this.mSourceOffset = sourceOffset;
        this.mSourceLength = sourceLength;
        this.mKind = kind;
        this.mOptions = options;
        this.mTypes = types;
        this.mSymbolTable = symbolTable;
        this.mUniqueElements = uniqueElements;
        this.mExtensions = extensions;
        this.mSharedElements = new ArrayList();
        this.mUsage = new SymbolUsage();
        this.mUsage.add(this);
    }

    public char[] getSource() {
        return this.mSource;
    }

    public int getSourceOffset() {
        return this.mSourceOffset;
    }

    public int getSourceLength() {
        return this.mSourceLength;
    }

    public ShaderKind getKind() {
        return this.mKind;
    }

    public CompileOptions getOptions() {
        return this.mOptions;
    }

    public BuiltinTypes getTypes() {
        return this.mTypes;
    }

    public SymbolTable getSymbolTable() {
        return this.mSymbolTable;
    }

    public ArrayList<TopLevelElement> getUniqueElements() {
        return this.mUniqueElements;
    }

    public ArrayList<TopLevelElement> getSharedElements() {
        return this.mSharedElements;
    }

    public List<Map.Entry<String, String>> getExtensions() {
        return this.mExtensions;
    }

    public SymbolUsage getUsage() {
        return this.mUsage;
    }

    @Override
    @Nonnull
    public Iterator<TopLevelElement> iterator() {
        return new ElementIterator();
    }

    @Override
    public boolean accept(@Nonnull TreeVisitor visitor) {
        for (TopLevelElement e : this) {
            if (!e.accept(visitor)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public String toString() {
        StringBuilder s = new StringBuilder();
        for (TopLevelElement e : this) {
            s.append(e.toString());
            s.append('\n');
        }
        return s.toString();
    }

    private class ElementIterator
    implements Iterator<TopLevelElement> {
        private Iterator<TopLevelElement> mCurrIter;
        private boolean mSharedEnded;

        private ElementIterator() {
            this.mCurrIter = TranslationUnit.this.mSharedElements.iterator();
            this.mSharedEnded = false;
        }

        @Override
        public boolean hasNext() {
            this.forward();
            return this.mCurrIter.hasNext();
        }

        @Override
        public TopLevelElement next() {
            this.forward();
            return this.mCurrIter.next();
        }

        private void forward() {
            while (!this.mCurrIter.hasNext() && !this.mSharedEnded) {
                this.mCurrIter = TranslationUnit.this.mUniqueElements.iterator();
                this.mSharedEnded = true;
            }
        }
    }
}

