/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.compiler;

import icyllis.arc3d.compiler.Context;
import icyllis.arc3d.compiler.tree.Type;

public final class Operator
extends Enum<Operator> {
    public static final /* enum */ Operator ADD = new Operator();
    public static final /* enum */ Operator SUB = new Operator();
    public static final /* enum */ Operator MUL = new Operator();
    public static final /* enum */ Operator DIV = new Operator();
    public static final /* enum */ Operator MOD = new Operator();
    public static final /* enum */ Operator SHL = new Operator();
    public static final /* enum */ Operator SHR = new Operator();
    public static final /* enum */ Operator LOGICAL_NOT = new Operator();
    public static final /* enum */ Operator LOGICAL_AND = new Operator();
    public static final /* enum */ Operator LOGICAL_OR = new Operator();
    public static final /* enum */ Operator LOGICAL_XOR = new Operator();
    public static final /* enum */ Operator BITWISE_NOT = new Operator();
    public static final /* enum */ Operator BITWISE_AND = new Operator();
    public static final /* enum */ Operator BITWISE_OR = new Operator();
    public static final /* enum */ Operator BITWISE_XOR = new Operator();
    public static final /* enum */ Operator ASSIGN = new Operator();
    public static final /* enum */ Operator EQ = new Operator();
    public static final /* enum */ Operator NE = new Operator();
    public static final /* enum */ Operator LT = new Operator();
    public static final /* enum */ Operator GT = new Operator();
    public static final /* enum */ Operator LE = new Operator();
    public static final /* enum */ Operator GE = new Operator();
    public static final /* enum */ Operator ADD_ASSIGN = new Operator();
    public static final /* enum */ Operator SUB_ASSIGN = new Operator();
    public static final /* enum */ Operator MUL_ASSIGN = new Operator();
    public static final /* enum */ Operator DIV_ASSIGN = new Operator();
    public static final /* enum */ Operator MOD_ASSIGN = new Operator();
    public static final /* enum */ Operator SHL_ASSIGN = new Operator();
    public static final /* enum */ Operator SHR_ASSIGN = new Operator();
    public static final /* enum */ Operator AND_ASSIGN = new Operator();
    public static final /* enum */ Operator OR_ASSIGN = new Operator();
    public static final /* enum */ Operator XOR_ASSIGN = new Operator();
    public static final /* enum */ Operator INC = new Operator();
    public static final /* enum */ Operator DEC = new Operator();
    public static final /* enum */ Operator COMMA = new Operator();
    public static final int PRECEDENCE_POSTFIX = 2;
    public static final int PRECEDENCE_PREFIX = 3;
    public static final int PRECEDENCE_MULTIPLICATIVE = 4;
    public static final int PRECEDENCE_ADDITIVE = 5;
    public static final int PRECEDENCE_SHIFT = 6;
    public static final int PRECEDENCE_RELATIONAL = 7;
    public static final int PRECEDENCE_EQUALITY = 8;
    public static final int PRECEDENCE_BITWISE_AND = 9;
    public static final int PRECEDENCE_BITWISE_XOR = 10;
    public static final int PRECEDENCE_BITWISE_OR = 11;
    public static final int PRECEDENCE_LOGICAL_AND = 12;
    public static final int PRECEDENCE_LOGICAL_XOR = 13;
    public static final int PRECEDENCE_LOGICAL_OR = 14;
    public static final int PRECEDENCE_CONDITIONAL = 15;
    public static final int PRECEDENCE_ASSIGNMENT = 16;
    public static final int PRECEDENCE_SEQUENCE = 17;
    public static final int PRECEDENCE_EXPRESSION = 17;
    public static final int PRECEDENCE_STATEMENT = 18;
    private static final /* synthetic */ Operator[] $VALUES;

    public static Operator[] values() {
        return (Operator[])$VALUES.clone();
    }

    public static Operator valueOf(String name) {
        return Enum.valueOf(Operator.class, name);
    }

    public int getBinaryPrecedence() {
        return switch (this) {
            case MUL, DIV, MOD -> 4;
            case ADD, SUB -> 5;
            case SHL, SHR -> 6;
            case LT, GT, LE, GE -> 7;
            case EQ, NE -> 8;
            case BITWISE_AND -> 9;
            case BITWISE_XOR -> 10;
            case BITWISE_OR -> 11;
            case LOGICAL_AND -> 12;
            case LOGICAL_XOR -> 13;
            case LOGICAL_OR -> 14;
            case ASSIGN, ADD_ASSIGN, SUB_ASSIGN, MUL_ASSIGN, DIV_ASSIGN, MOD_ASSIGN, SHL_ASSIGN, SHR_ASSIGN, AND_ASSIGN, OR_ASSIGN, XOR_ASSIGN -> 16;
            case COMMA -> 17;
            default -> throw new AssertionError((Object)this);
        };
    }

    public String getPrettyName() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case ADD -> " + ";
            case SUB -> " - ";
            case MUL -> " * ";
            case DIV -> " / ";
            case MOD -> " % ";
            case SHL -> " << ";
            case SHR -> " >> ";
            case LOGICAL_NOT -> "!";
            case LOGICAL_AND -> " && ";
            case LOGICAL_OR -> " || ";
            case LOGICAL_XOR -> " ^^ ";
            case BITWISE_NOT -> "~";
            case BITWISE_AND -> " & ";
            case BITWISE_OR -> " | ";
            case BITWISE_XOR -> " ^ ";
            case ASSIGN -> " = ";
            case EQ -> " == ";
            case NE -> " != ";
            case LT -> " < ";
            case GT -> " > ";
            case LE -> " <= ";
            case GE -> " >= ";
            case ADD_ASSIGN -> " += ";
            case SUB_ASSIGN -> " -= ";
            case MUL_ASSIGN -> " *= ";
            case DIV_ASSIGN -> " /= ";
            case MOD_ASSIGN -> " %= ";
            case SHL_ASSIGN -> " <<= ";
            case SHR_ASSIGN -> " >>= ";
            case AND_ASSIGN -> " &= ";
            case OR_ASSIGN -> " |= ";
            case XOR_ASSIGN -> " ^= ";
            case INC -> "++";
            case DEC -> "--";
            case COMMA -> ", ";
        };
    }

    public String toString() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case ADD -> "+";
            case SUB -> "-";
            case MUL -> "*";
            case DIV -> "/";
            case MOD -> "%";
            case SHL -> "<<";
            case SHR -> ">>";
            case LOGICAL_NOT -> "!";
            case LOGICAL_AND -> "&&";
            case LOGICAL_OR -> "||";
            case LOGICAL_XOR -> "^^";
            case BITWISE_NOT -> "~";
            case BITWISE_AND -> "&";
            case BITWISE_OR -> "|";
            case BITWISE_XOR -> "^";
            case ASSIGN -> "=";
            case EQ -> "==";
            case NE -> "!=";
            case LT -> "<";
            case GT -> ">";
            case LE -> "<=";
            case GE -> ">=";
            case ADD_ASSIGN -> "+=";
            case SUB_ASSIGN -> "-=";
            case MUL_ASSIGN -> "*=";
            case DIV_ASSIGN -> "/=";
            case MOD_ASSIGN -> "%=";
            case SHL_ASSIGN -> "<<=";
            case SHR_ASSIGN -> ">>=";
            case AND_ASSIGN -> "&=";
            case OR_ASSIGN -> "|=";
            case XOR_ASSIGN -> "^=";
            case INC -> "++";
            case DEC -> "--";
            case COMMA -> ",";
        };
    }

    public boolean isEquality() {
        return this == EQ || this == NE;
    }

    public boolean isRelational() {
        return switch (this) {
            case LT, GT, LE, GE -> true;
            default -> false;
        };
    }

    public boolean isAssignment() {
        return switch (this) {
            case ASSIGN, ADD_ASSIGN, SUB_ASSIGN, MUL_ASSIGN, DIV_ASSIGN, MOD_ASSIGN, SHL_ASSIGN, SHR_ASSIGN, AND_ASSIGN, OR_ASSIGN, XOR_ASSIGN -> true;
            default -> false;
        };
    }

    public Operator removeAssignment() {
        return switch (this) {
            case ADD_ASSIGN -> ADD;
            case SUB_ASSIGN -> SUB;
            case MUL_ASSIGN -> MUL;
            case DIV_ASSIGN -> DIV;
            case MOD_ASSIGN -> MOD;
            case SHL_ASSIGN -> SHL;
            case SHR_ASSIGN -> SHR;
            case AND_ASSIGN -> BITWISE_AND;
            case OR_ASSIGN -> BITWISE_OR;
            case XOR_ASSIGN -> BITWISE_XOR;
            default -> this;
        };
    }

    public boolean isOnlyValidForIntegers() {
        return switch (this) {
            case MOD, SHL, SHR, BITWISE_AND, BITWISE_XOR, BITWISE_OR, MOD_ASSIGN, SHL_ASSIGN, SHR_ASSIGN, AND_ASSIGN, OR_ASSIGN, XOR_ASSIGN, BITWISE_NOT -> true;
            default -> false;
        };
    }

    public boolean isValidForVectorOrMatrix() {
        return switch (this) {
            case MUL, DIV, MOD, ADD, SUB, SHL, SHR, BITWISE_AND, BITWISE_XOR, BITWISE_OR, ADD_ASSIGN, SUB_ASSIGN, MUL_ASSIGN, DIV_ASSIGN, MOD_ASSIGN, SHL_ASSIGN, SHR_ASSIGN, AND_ASSIGN, OR_ASSIGN, XOR_ASSIGN -> true;
            default -> false;
        };
    }

    private boolean isMatrixMultiply(Type left, Type right) {
        if (this != MUL && this != MUL_ASSIGN) {
            return false;
        }
        if (left.isMatrix()) {
            return right.isMatrix() || right.isVector();
        }
        return left.isVector() && right.isMatrix();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean determineBinaryType(Context context, Type left, Type right, Type[] out) {
        long leftToRightCost;
        boolean rightIsVectorOrMatrix;
        boolean leftIsVectorOrMatrix;
        assert (out.length >= 3);
        switch (this) {
            case ASSIGN: {
                if (left.isVoid()) {
                    return false;
                }
                out[0] = left;
                out[1] = left;
                out[2] = left;
                return right.canCoerceTo(left, false);
            }
            case EQ: 
            case NE: {
                long leftToRight;
                if (left.isVoid()) return false;
                if (left.isOpaque()) {
                    return false;
                }
                long rightToLeft = right.getCoercionCost(left);
                if (Type.CoercionCost.compare(rightToLeft, leftToRight = left.getCoercionCost(right)) < 0) {
                    if (!Type.CoercionCost.accept(rightToLeft, false)) return false;
                    out[0] = left;
                    out[1] = left;
                    out[2] = context.getTypes().mBool;
                    return true;
                }
                if (!Type.CoercionCost.accept(leftToRight, false)) return false;
                out[0] = right;
                out[1] = right;
                out[2] = context.getTypes().mBool;
                return true;
            }
            case LOGICAL_AND: 
            case LOGICAL_XOR: 
            case LOGICAL_OR: {
                out[0] = context.getTypes().mBool;
                out[1] = context.getTypes().mBool;
                out[2] = context.getTypes().mBool;
                if (!left.canCoerceTo(context.getTypes().mBool, false)) return false;
                if (!right.canCoerceTo(context.getTypes().mBool, false)) return false;
                return true;
            }
            case COMMA: {
                if (left.isOpaque()) return false;
                if (right.isOpaque()) {
                    return false;
                }
                out[0] = left;
                out[1] = right;
                out[2] = right;
                return true;
            }
        }
        Type leftComponentType = left.getComponentType();
        Type rightComponentType = right.getComponentType();
        if (leftComponentType.isBoolean()) return false;
        if (rightComponentType.isBoolean()) {
            return false;
        }
        boolean isAssignment = this.isAssignment();
        if (this.isMatrixMultiply(left, right)) {
            if (!this.determineBinaryType(context, leftComponentType, rightComponentType, out)) {
                return false;
            }
            int leftCols = left.getCols();
            int leftRows = left.getRows();
            int rightCols = right.getCols();
            int rightRows = right.getRows();
            out[0] = out[2].toCompound(context, leftCols, leftRows);
            out[1] = out[2].toCompound(context, rightCols, rightRows);
            if (left.isVector()) {
                int t = leftCols;
                leftCols = leftRows;
                leftRows = t;
                assert (leftRows == 1);
            }
            out[2] = leftRows > 1 ? out[2].toCompound(context, rightCols, leftRows) : out[2].toCompound(context, leftRows, rightCols);
            if (isAssignment) {
                if (out[2].getCols() != leftCols) return false;
                if (out[2].getRows() != leftRows) {
                    return false;
                }
            }
            if (rightRows != leftCols) return false;
            return true;
        }
        boolean bl = leftIsVectorOrMatrix = (left.isVector() || left.isMatrix()) && this.isValidForVectorOrMatrix();
        if (leftIsVectorOrMatrix && right.isScalar()) {
            if (!this.determineBinaryType(context, leftComponentType, right, out)) {
                return false;
            }
            out[0] = out[0].toCompound(context, left.getCols(), left.getRows());
            assert (!this.isRelational());
            out[2] = out[2].toCompound(context, left.getCols(), left.getRows());
            return true;
        }
        boolean bl2 = rightIsVectorOrMatrix = (right.isVector() || right.isMatrix()) && this.isValidForVectorOrMatrix();
        if (!isAssignment && rightIsVectorOrMatrix && left.isScalar()) {
            if (!this.determineBinaryType(context, left, rightComponentType, out)) {
                return false;
            }
            out[1] = out[1].toCompound(context, right.getCols(), right.getRows());
            assert (!this.isRelational());
            out[2] = out[2].toCompound(context, right.getCols(), right.getRows());
            return true;
        }
        long rightToLeftCost = right.getCoercionCost(left);
        long l = leftToRightCost = isAssignment ? Type.CoercionCost.saturate() : left.getCoercionCost(right);
        if (!left.isScalar() || !right.isScalar()) {
            if (!leftIsVectorOrMatrix) return false;
        }
        if (this.isOnlyValidForIntegers()) {
            if (!leftComponentType.isInteger()) return false;
            if (!rightComponentType.isInteger()) {
                return false;
            }
        }
        if (Type.CoercionCost.compare(rightToLeftCost, leftToRightCost) < 0) {
            if (!Type.CoercionCost.accept(rightToLeftCost, false)) return false;
            out[0] = left;
            out[1] = left;
            out[2] = left;
        } else {
            if (!Type.CoercionCost.accept(leftToRightCost, false)) return false;
            out[0] = right;
            out[1] = right;
            out[2] = right;
        }
        if (!this.isRelational()) return true;
        out[2] = context.getTypes().mBool;
        return true;
    }

    private static /* synthetic */ Operator[] $values() {
        return new Operator[]{ADD, SUB, MUL, DIV, MOD, SHL, SHR, LOGICAL_NOT, LOGICAL_AND, LOGICAL_OR, LOGICAL_XOR, BITWISE_NOT, BITWISE_AND, BITWISE_OR, BITWISE_XOR, ASSIGN, EQ, NE, LT, GT, LE, GE, ADD_ASSIGN, SUB_ASSIGN, MUL_ASSIGN, DIV_ASSIGN, MOD_ASSIGN, SHL_ASSIGN, SHR_ASSIGN, AND_ASSIGN, OR_ASSIGN, XOR_ASSIGN, INC, DEC, COMMA};
    }

    static {
        $VALUES = Operator.$values();
    }
}

