/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import net.minecraft.class_3545;

public class GradientUtil {
    private GradientUtil() {
    }

    public static int argbToAbgr(int argb) {
        int r = argb >> 16 & 0xFF;
        int b = argb & 0xFF;
        return argb & 0xFF00FF00 | b << 16 | r;
    }

    public static int argbToRgba(int argb) {
        return argb << 8 | argb >>> 24;
    }

    public static float[] getRGB(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color >> 0 & 0xFF) / 255.0f;
        return new float[]{r, g, b};
    }

    public static int multiplyBlendRGBA(int c1, int c2) {
        int a1 = c1 & 0xFF;
        int r1 = (c1 & 0xFF000000) >> 24;
        int g1 = (c1 & 0xFF0000) >> 16;
        int b1 = (c1 & 0xFF00) >> 8;
        int a2 = c2 & 0xFF;
        int r2 = (c2 & 0xFF000000) >> 24;
        int g2 = (c2 & 0xFF0000) >> 16;
        int b2 = (c2 & 0xFF00) >> 8;
        int a = a1 * a2 / 255;
        int r = r1 * r2 / 255;
        int g = g1 * g2 / 255;
        int b = b1 * b2 / 255;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int blend(int c1, int c2, float ratio) {
        if (ratio > 1.0f) {
            ratio = 1.0f;
        } else if (ratio < 0.0f) {
            ratio = 0.0f;
        }
        float iRatio = 1.0f - ratio;
        int a1 = c1 >> 24 & 0xFF;
        int r1 = (c1 & 0xFF0000) >> 16;
        int g1 = (c1 & 0xFF00) >> 8;
        int b1 = c1 & 0xFF;
        int a2 = c2 >> 24 & 0xFF;
        int r2 = (c2 & 0xFF0000) >> 16;
        int g2 = (c2 & 0xFF00) >> 8;
        int b2 = c2 & 0xFF;
        int a = (int)((float)a1 * iRatio + (float)a2 * ratio);
        int r = (int)((float)r1 * iRatio + (float)r2 * ratio);
        int g = (int)((float)g1 * iRatio + (float)g2 * ratio);
        int b = (int)((float)b1 * iRatio + (float)b2 * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static class_3545<float[], float[]> getGradient(int rgb, int luminanceDifference) {
        float[] hsl = GradientUtil.RGBtoHSL(rgb);
        float[] upshade = new float[3];
        float[] downshade = new float[3];
        System.arraycopy(hsl, 0, upshade, 0, 3);
        System.arraycopy(hsl, 0, downshade, 0, 3);
        upshade[2] = upshade[2] + (float)luminanceDifference;
        if (upshade[2] > 100.0f) {
            upshade[2] = 100.0f;
        }
        downshade[2] = downshade[2] - (float)luminanceDifference;
        if (downshade[2] < 0.0f) {
            downshade[2] = 0.0f;
        }
        float[] upshadeRgb = GradientUtil.toRGB(upshade);
        float[] downshadeRgb = GradientUtil.toRGB(downshade);
        return new class_3545((Object)downshadeRgb, (Object)upshadeRgb);
    }

    public static float[] RGBtoHSL(int rgbColor) {
        float r = (float)(rgbColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgbColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgbColor >> 0 & 0xFF) / 255.0f;
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        float h = 0.0f;
        if (max == min) {
            h = 0.0f;
        } else if (max == r) {
            h = (60.0f * (g - b) / (max - min) + 360.0f) % 360.0f;
        } else if (max == g) {
            h = 60.0f * (b - r) / (max - min) + 120.0f;
        } else if (max == b) {
            h = 60.0f * (r - g) / (max - min) + 240.0f;
        }
        float l = (max + min) / 2.0f;
        float s = max == min ? 0.0f : (l <= 0.5f ? (max - min) / (max + min) : (max - min) / (2.0f - max - min));
        return new float[]{h, s * 100.0f, l * 100.0f};
    }

    public static float[] toRGB(float[] hsv) {
        return GradientUtil.toRGB(hsv[0], hsv[1], hsv[2]);
    }

    public static float[] toRGB(float h, float s, float l) {
        h %= 360.0f;
        float q = (l /= 100.0f) < 0.5f ? l * (1.0f + s) : l + (s /= 100.0f) - s * l;
        float p = 2.0f * l - q;
        float r = Math.max(0.0f, GradientUtil.hueToRGB(p, q, (h /= 360.0f) + 0.33333334f));
        float g = Math.max(0.0f, GradientUtil.hueToRGB(p, q, h));
        float b = Math.max(0.0f, GradientUtil.hueToRGB(p, q, h - 0.33333334f));
        r = Math.min(r, 1.0f);
        g = Math.min(g, 1.0f);
        b = Math.min(b, 1.0f);
        return new float[]{r, g, b};
    }

    private static float hueToRGB(float p, float q, float h) {
        if (h < 0.0f) {
            h += 1.0f;
        }
        if (h > 1.0f) {
            h -= 1.0f;
        }
        if (6.0f * h < 1.0f) {
            return p + (q - p) * 6.0f * h;
        }
        if (2.0f * h < 1.0f) {
            return q;
        }
        if (3.0f * h < 2.0f) {
            return p + (q - p) * 6.0f * (0.6666667f - h);
        }
        return p;
    }
}

