/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.helpers;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;

public record MaterialStackWrapper(Supplier<Material> material, long amount) {
    private static final Map<String, MaterialStackWrapper> PARSE_CACHE = new WeakHashMap<String, MaterialStackWrapper>();

    public static MaterialStackWrapper fromString(CharSequence str) {
        String trimmed;
        String copy = trimmed = str.toString().trim();
        MaterialStackWrapper cached = PARSE_CACHE.get(trimmed);
        if (cached != null) {
            return cached.isEmpty() ? null : cached.copy();
        }
        int count = 1;
        int spaceIndex = copy.indexOf(32);
        if (spaceIndex >= 2 && copy.indexOf(120) == spaceIndex - 1) {
            count = Integer.parseInt(copy.substring(0, spaceIndex - 1));
            copy = copy.substring(spaceIndex + 1);
        }
        String copyFinal = copy;
        cached = new MaterialStackWrapper(() -> GTMaterials.get(copyFinal), count);
        PARSE_CACHE.put(trimmed, cached);
        return cached.copy();
    }

    public MaterialStackWrapper copy() {
        return new MaterialStackWrapper(this.material, this.amount);
    }

    public boolean isEmpty() {
        return this.material == null || this.amount < 1L;
    }

    public MaterialStack toMatStack() {
        return new MaterialStack(this.material.get(), this.amount);
    }
}

