/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.builders.machine;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.SimpleTieredMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.integration.kjs.builders.machine.KineticMachineBuilder;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_6328;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

@class_6328
@ParametersAreNonnullByDefault
public class MachineFunctionPresets {
    public static Integer[] mapTierArray(Object[] tiers) {
        return (Integer[])Arrays.stream(tiers).flatMap(object -> object.getClass().isArray() ? (((Class)object.getClass().componentType()).isPrimitive() ? Arrays.stream((int[])object).boxed() : Arrays.stream((Object[])object)) : Stream.of(object)).filter(Number.class::isInstance).map(Number.class::cast).map(Number::intValue).toArray(Integer[]::new);
    }

    public static Object[] copyArgs(Object[] original, int offset) {
        Object[] copy = new Object[original.length - offset];
        System.arraycopy(original, offset, copy, 0, original.length - offset);
        return copy;
    }

    public static <D extends MachineDefinition, B extends MachineBuilder<D>> MachineBuilder<D> builder(String name, B[] builders, Class<B> builderClass, Function<class_2960, D> definitionFactory, BiFunction<class_4970.class_2251, D, IMachineBlock> blockFactory, TriFunction<class_2591<?>, class_2338, class_2680, IMachineBlockEntity> blockEntityFactory) {
        return new MachineBuilder<D>(GTRegistries.REGISTRATE, name, definitionFactory, holder -> null, blockFactory, MetaMachineItem::new, (TriFunction)blockEntityFactory, (MachineBuilder[])builders, builderClass){
            final /* synthetic */ MachineBuilder[] val$builders;
            final /* synthetic */ Class val$builderClass;
            {
                this.val$builders = machineBuilderArray;
                this.val$builderClass = clazz;
                super(registrate, name, definitionFactory, metaMachine, blockFactory, itemFactory, blockEntityFactory);
            }

            @Override
            public MachineBuilder<D> renderer(@Nullable Supplier<IRenderer> renderer) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.renderer(renderer);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> shape(class_265 shape) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.shape(shape);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> rotationState(RotationState rotationState) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.rotationState(rotationState);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> hasTESR(boolean hasTESR) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.hasTESR(hasTESR);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> blockProp(NonNullUnaryOperator<class_4970.class_2251> blockProp) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.blockProp(blockProp);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> itemProp(NonNullUnaryOperator<class_1792.class_1793> itemProp) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.itemProp(itemProp);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> blockBuilder(Consumer<BlockBuilder<? extends class_2248, ?>> blockBuilder) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.blockBuilder(blockBuilder);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> itemBuilder(Consumer<ItemBuilder<? extends MetaMachineItem, ?>> itemBuilder) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.itemBuilder(itemBuilder);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> onBlockEntityRegister(NonNullConsumer<class_2591<class_2586>> onBlockEntityRegister) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.onBlockEntityRegister(onBlockEntityRegister);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> recipeType(GTRecipeType type) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.recipeType(type);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> recipeTypes(GTRecipeType ... recipeTypes) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.recipeTypes(recipeTypes);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> tier(int tier) {
                return this;
            }

            @Override
            public MachineBuilder<D> recipeOutputLimits(Object2IntMap<RecipeCapability<?>> map) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.recipeOutputLimits(map);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> addOutputLimit(RecipeCapability<?> capability, int limit) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.addOutputLimit(capability, limit);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> paintingColor(int paintingColor) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.paintingColor(paintingColor);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> itemColor(BiFunction<class_1799, Integer, Integer> itemColor) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.itemColor(itemColor);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> abilities(PartAbility ... abilities) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.abilities(abilities);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> tooltips(class_2561 ... tooltips) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.tooltips(tooltips);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> tooltipBuilder(BiConsumer<class_1799, List<class_2561>> tooltipBuilder) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.tooltipBuilder(tooltipBuilder);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> recipeModifier(BiFunction<MetaMachine, GTRecipe, GTRecipe> recipeModifier) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.recipeModifier(recipeModifier);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> alwaysTryModifyRecipe(boolean alwaysTryModifyRecipe) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.alwaysTryModifyRecipe(alwaysTryModifyRecipe);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> appearance(Supplier<class_2680> appearance) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.appearance(appearance);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> editableUI(@Nullable EditableMachineUI editableUI) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.editableUI(editableUI);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> langValue(String langValue) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.langValue(langValue);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> modelRenderer(Supplier<class_2960> model) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.modelRenderer(model);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> defaultModelRenderer() {
                return this.modelRenderer(() -> new class_2960(this.registrate.getModid(), "block/" + this.name));
            }

            @Override
            public MachineBuilder<D> overlayTieredHullRenderer(String name) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.overlayTieredHullRenderer(name);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> overlaySteamHullRenderer(String name) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.overlaySteamHullRenderer(name);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> workableTieredHullRenderer(class_2960 workableModel) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.workableTieredHullRenderer(workableModel);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> workableSteamHullRenderer(boolean isHighPressure, class_2960 workableModel) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.workableSteamHullRenderer(isHighPressure, workableModel);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> workableCasingRenderer(class_2960 baseCasing, class_2960 workableModel) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.workableCasingRenderer(baseCasing, workableModel);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> workableCasingRenderer(class_2960 baseCasing, class_2960 workableModel, boolean tint) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.workableCasingRenderer(baseCasing, workableModel, tint);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> sidedWorkableCasingRenderer(String basePath, class_2960 overlayModel, boolean tint) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    builder.sidedWorkableCasingRenderer(basePath, overlayModel, tint);
                }
                return this;
            }

            public MachineBuilder<D> tier(int tier, BuilderConsumer<D> consumer) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null || builder.tier() != tier) continue;
                    consumer.accept(builder);
                }
                return this;
            }

            public MachineBuilder<D> allTiers(TieredBuilderConsumer<D> consumer) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    consumer.accept(builder.tier(), builder);
                }
                return this;
            }

            @Override
            public MachineBuilder<D> recipeModifier(BiFunction<MetaMachine, GTRecipe, GTRecipe> recipeModifier, boolean alwaysTryModifyRecipe) {
                this.recipeModifier(recipeModifier);
                this.alwaysTryModifyRecipe(alwaysTryModifyRecipe);
                return this;
            }

            public MachineBuilder<D> tankScalingFunction(Function<Object, Double> tankScalingFunction) {
                try {
                    Method method = this.val$builderClass.getDeclaredMethod("tankScalingFunction", Function.class);
                    for (MachineBuilder builder : this.val$builders) {
                        if (builder == null) continue;
                        method.invoke((Object)builder, tankScalingFunction);
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
                return this;
            }

            @Nullable
            public Function<Integer, Long> getTankScalingFunction(B builder) {
                try {
                    Field field = this.val$builderClass.getField("tankScalingFunction");
                    return (Function)field.get(builder);
                }
                catch (IllegalAccessException | NoSuchFieldException exception) {
                    return null;
                }
            }

            public MachineBuilder<D> workableTooltip(GTRecipeType recipeType) {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    int tier = builder.tier();
                    Function<Integer, Long> tankScalingFunction = this.getTankScalingFunction(builder);
                    builder.tooltips(GTMachines.workableTiered(tier, GTValues.V[tier], GTValues.V[tier] * 64L, recipeType, tankScalingFunction != null ? tankScalingFunction.apply(tier) : (Long)GTMachines.defaultTankSizeFunction.apply((Object)tier), true));
                }
                return this;
            }

            public MachineBuilder<D> recipeType(GTRecipeType recipeType, boolean applyWorkableTooltip) {
                this.recipeType(recipeType);
                if (applyWorkableTooltip) {
                    this.workableTooltip(recipeType);
                }
                return this;
            }

            public MachineBuilder<D> recipeType(GTRecipeType recipeType, boolean applyWorkableTooltip, boolean applyDefaultGUIFunction) {
                this.recipeType(recipeType);
                if (applyWorkableTooltip) {
                    this.workableTooltip(recipeType);
                }
                if (applyDefaultGUIFunction) {
                    this.editableUI(SimpleTieredMachine.EDITABLE_UI_CREATOR.apply(this.id, recipeType));
                }
                return this;
            }

            public MachineBuilder<D> isSource(boolean isSource) {
                if (KineticMachineBuilder.class.isAssignableFrom(this.val$builderClass)) {
                    for (MachineBuilder builder : this.val$builders) {
                        if (builder == null) continue;
                        ((KineticMachineBuilder)builder).isSource(isSource);
                    }
                }
                return this;
            }

            @Override
            public D register() {
                for (MachineBuilder builder : this.val$builders) {
                    if (builder == null) continue;
                    this.value = builder.register();
                }
                return (MachineDefinition)this.value;
            }
        };
    }

    @FunctionalInterface
    public static interface TieredBuilderConsumer<D extends MachineDefinition> {
        public void accept(int var1, MachineBuilder<D> var2);
    }

    @FunctionalInterface
    public static interface BuilderConsumer<D extends MachineDefinition>
    extends Consumer<MachineBuilder<D>> {
        @Override
        public void accept(MachineBuilder<D> var1);
    }
}

