/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.builders.machine;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.multiblock.TieredWorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.MultiblockShapeInfo;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.api.registry.registrate.MultiblockMachineBuilder;
import com.gregtechceu.gtceu.common.machine.multiblock.primitive.PrimitiveFancyUIWorkableMachine;
import com.gregtechceu.gtceu.integration.kjs.builders.machine.MachineFunctionPresets;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import net.minecraft.class_6328;
import org.apache.commons.lang3.function.TriFunction;

@class_6328
@ParametersAreNonnullByDefault
public class CustomMultiblockBuilder
extends MultiblockMachineBuilder {
    protected CustomMultiblockBuilder(String name, Function<IMachineBlockEntity, ? extends MultiblockControllerMachine> metaMachine) {
        super(GTRegistries.REGISTRATE, name, metaMachine, MetaMachineBlock::new, MetaMachineItem::new, MetaMachineBlockEntity::createBlockEntity);
    }

    public static CustomMultiblockBuilder[] tieredMultis(String name, BiFunction<IMachineBlockEntity, Integer, MultiblockControllerMachine> factory, Integer ... tiers) {
        CustomMultiblockBuilder[] builders = new CustomMultiblockBuilder[GTValues.TIER_COUNT];
        Integer[] integerArray = tiers;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            CustomMultiblockBuilder builder;
            int tier = integerArray[i];
            builders[tier] = builder = new CustomMultiblockBuilder(GTValues.VN[tier].toLowerCase(Locale.ROOT) + "_" + name, holder -> (MultiblockControllerMachine)factory.apply((IMachineBlockEntity)holder, tier)).tier(tier);
        }
        return builders;
    }

    @Override
    public CustomMultiblockBuilder tier(int tier) {
        return (CustomMultiblockBuilder)super.tier(tier);
    }

    public static MachineBuilder<MultiblockMachineDefinition> createMultiblock(String name, Object ... args) {
        CustomMultiblockBuilder[] builders;
        int start;
        for (start = 0; !(start >= args.length || args[start] instanceof Number && args[start] instanceof Number[] && args[start] instanceof int[]); ++start) {
        }
        Object[] tierObjects = MachineFunctionPresets.copyArgs(args, start);
        Integer[] tiers = MachineFunctionPresets.mapTierArray(tierObjects);
        if (tiers.length > 0) {
            Object object;
            if (args.length > 0 && (object = args[0]) instanceof BiFunction) {
                BiFunction machineFunction = (BiFunction)object;
                builders = CustomMultiblockBuilder.tieredMultis(name, machineFunction, tiers);
            } else {
                builders = CustomMultiblockBuilder.tieredMultis(name, (x$0, x$1) -> new TieredWorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, (int)x$1, new Object[0]), tiers);
            }
        } else {
            Object object;
            if (args.length > 0 && (object = args[0]) instanceof Function) {
                Function machineFunction = (Function)object;
                return new CustomMultiblockBuilder(name, machineFunction);
            }
            return new CustomMultiblockBuilder(name, x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0]));
        }
        return CustomMultiblockBuilder.tieredBuilder(name, builders);
    }

    public static MachineBuilder<MultiblockMachineDefinition> createPrimitiveMultiblock(String name, Object ... args) {
        return new CustomMultiblockBuilder(name, holder -> new PrimitiveFancyUIWorkableMachine((IMachineBlockEntity)holder, args));
    }

    public static CustomMultiblockBuilder tieredBuilder(String name, final CustomMultiblockBuilder[] builders) {
        return new CustomMultiblockBuilder(name, holder -> null){

            @Override
            public MultiblockMachineBuilder pattern(Function<MultiblockMachineDefinition, BlockPattern> pattern) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.pattern(pattern);
                }
                return this;
            }

            @Override
            public MultiblockMachineBuilder partSorter(Comparator<IMultiPart> partSorter) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.partSorter(partSorter);
                }
                return this;
            }

            @Override
            public MultiblockMachineBuilder partAppearance(TriFunction<IMultiController, IMultiPart, class_2350, class_2680> partAppearance) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.partAppearance(partAppearance);
                }
                return this;
            }

            @Override
            public MultiblockMachineBuilder additionalDisplay(BiConsumer<IMultiController, List<class_2561>> additionalDisplay) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.additionalDisplay(additionalDisplay);
                }
                return this;
            }

            @Override
            public MultiblockMachineBuilder shapeInfo(Function<MultiblockMachineDefinition, MultiblockShapeInfo> shape) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.shapeInfo(shape);
                }
                return this;
            }

            @Override
            public MultiblockMachineBuilder shapeInfos(Function<MultiblockMachineDefinition, List<MultiblockShapeInfo>> shapes) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.shapeInfos(shapes);
                }
                return this;
            }

            @Override
            public MultiblockMachineBuilder recoveryItems(Supplier<class_1935[]> items) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.recoveryItems(items);
                }
                return this;
            }

            @Override
            public MultiblockMachineBuilder recoveryStacks(Supplier<class_1799[]> stacks) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.recoveryStacks(stacks);
                }
                return this;
            }

            @Override
            public CustomMultiblockBuilder renderer(@Nullable Supplier<IRenderer> renderer) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.renderer((Supplier)renderer);
                }
                return this;
            }

            @Override
            public CustomMultiblockBuilder shape(class_265 shape) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.shape(shape);
                }
                return this;
            }

            @Override
            public CustomMultiblockBuilder rotationState(RotationState rotationState) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.rotationState(rotationState);
                }
                return this;
            }

            @Override
            public CustomMultiblockBuilder hasTESR(boolean hasTESR) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.hasTESR(hasTESR);
                }
                return this;
            }

            @Override
            public CustomMultiblockBuilder blockProp(NonNullUnaryOperator<class_4970.class_2251> blockProp) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.blockProp((NonNullUnaryOperator)blockProp);
                }
                return this;
            }

            @Override
            public CustomMultiblockBuilder itemProp(NonNullUnaryOperator<class_1792.class_1793> itemProp) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.itemProp((NonNullUnaryOperator)itemProp);
                }
                return this;
            }

            @Override
            public CustomMultiblockBuilder blockBuilder(Consumer<BlockBuilder<? extends class_2248, ?>> blockBuilder) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.blockBuilder((Consumer)blockBuilder);
                }
                return this;
            }

            @Override
            public CustomMultiblockBuilder itemBuilder(Consumer<ItemBuilder<? extends MetaMachineItem, ?>> itemBuilder) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.itemBuilder((Consumer)itemBuilder);
                }
                return this;
            }

            @Override
            public CustomMultiblockBuilder onBlockEntityRegister(NonNullConsumer<class_2591<class_2586>> onBlockEntityRegister) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.onBlockEntityRegister((NonNullConsumer)onBlockEntityRegister);
                }
                return this;
            }

            @Override
            public CustomMultiblockBuilder recipeTypes(GTRecipeType ... recipeTypes) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.recipeTypes(recipeTypes);
                }
                return this;
            }

            @Override
            public CustomMultiblockBuilder recipeType(GTRecipeType recipeType) {
                return this.recipeTypes(recipeType);
            }

            @Override
            public CustomMultiblockBuilder tier(int tier) {
                return this;
            }

            @Override
            public CustomMultiblockBuilder recipeOutputLimits(Object2IntMap<RecipeCapability<?>> map) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.recipeOutputLimits((Object2IntMap)map);
                }
                return this;
            }

            @Override
            public CustomMultiblockBuilder addOutputLimit(RecipeCapability<?> capability, int limit) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.addOutputLimit((RecipeCapability)capability, limit);
                }
                return this;
            }

            @Override
            public CustomMultiblockBuilder paintingColor(int paintingColor) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.paintingColor(paintingColor);
                }
                return this;
            }

            @Override
            public CustomMultiblockBuilder itemColor(BiFunction<class_1799, Integer, Integer> itemColor) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.itemColor((BiFunction)itemColor);
                }
                return this;
            }

            @Override
            public CustomMultiblockBuilder abilities(PartAbility ... abilities) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.abilities(abilities);
                }
                return this;
            }

            @Override
            public CustomMultiblockBuilder tooltips(class_2561 ... tooltips) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.tooltips(tooltips);
                }
                return this;
            }

            @Override
            public CustomMultiblockBuilder tooltipBuilder(BiConsumer<class_1799, List<class_2561>> tooltipBuilder) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.tooltipBuilder((BiConsumer)tooltipBuilder);
                }
                return this;
            }

            @Override
            public CustomMultiblockBuilder recipeModifier(BiFunction<MetaMachine, GTRecipe, GTRecipe> recipeModifier) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.recipeModifier((BiFunction)recipeModifier);
                }
                return this;
            }

            @Override
            public CustomMultiblockBuilder alwaysTryModifyRecipe(boolean alwaysTryModifyRecipe) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.alwaysTryModifyRecipe(alwaysTryModifyRecipe);
                }
                return this;
            }

            @Override
            public CustomMultiblockBuilder appearance(Supplier<class_2680> appearance) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.appearance((Supplier)appearance);
                }
                return this;
            }

            @Override
            public CustomMultiblockBuilder editableUI(@Nullable EditableMachineUI editableUI) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.editableUI(editableUI);
                }
                return this;
            }

            @Override
            public CustomMultiblockBuilder langValue(String langValue) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    builder.langValue(langValue);
                }
                return this;
            }

            @Override
            public CustomMultiblockBuilder recipeModifier(BiFunction<MetaMachine, GTRecipe, GTRecipe> recipeModifier, boolean alwaysTryModifyRecipe) {
                this.recipeModifier((BiFunction)recipeModifier);
                this.alwaysTryModifyRecipe(alwaysTryModifyRecipe);
                return this;
            }

            public CustomMultiblockBuilder tier(int tier, BuilderConsumer consumer) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null || builder.tier() != tier) continue;
                    consumer.accept(builder);
                }
                return this;
            }

            public CustomMultiblockBuilder allTiers(TieredBuilderConsumer consumer) {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    consumer.accept(builder.tier(), builder);
                }
                return this;
            }

            @Override
            public MultiblockMachineDefinition register() {
                for (CustomMultiblockBuilder builder : builders) {
                    if (builder == null) continue;
                    this.value = builder.register();
                }
                return (MultiblockMachineDefinition)this.value;
            }
        };
    }

    @FunctionalInterface
    public static interface TieredBuilderConsumer {
        public void accept(int var1, CustomMultiblockBuilder var2);
    }

    @FunctionalInterface
    public static interface BuilderConsumer
    extends Consumer<CustomMultiblockBuilder> {
        @Override
        public void accept(CustomMultiblockBuilder var1);
    }
}

