/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.util;

import appeng.api.stacks.GenericStack;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.AEConfigWidget;
import com.gregtechceu.gtceu.integration.ae2.util.IConfigurableSlot;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.Position;
import net.minecraft.class_2540;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class AmountSetSlot
extends Widget {
    private int index = -1;
    private final TextFieldWidget amountText;
    private final AEConfigWidget parentWidget;

    public AmountSetSlot(int x, int y, AEConfigWidget widget) {
        super(x, y, 80, 30);
        this.parentWidget = widget;
        this.amountText = new TextFieldWidget(x + 3, y + 14, 60, 15, this::getAmountStr, this::setNewAmount).setNumbersOnly(0, Integer.MAX_VALUE).setMaxStringLength(10);
    }

    public void setSlotIndex(int slotIndex) {
        this.index = slotIndex;
        this.writeClientAction(0, buf -> buf.method_10804(this.index));
    }

    public String getAmountStr() {
        if (this.index < 0) {
            return "0";
        }
        IConfigurableSlot slot = this.parentWidget.getConfig(this.index);
        if (slot.getConfig() != null) {
            return String.valueOf(slot.getConfig().amount());
        }
        return "0";
    }

    public void setNewAmount(String amount) {
        try {
            long newAmount = Long.parseLong(amount);
            this.writeClientAction(1, buf -> buf.method_10791(newAmount));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void handleClientAction(int id, class_2540 buffer) {
        super.handleClientAction(id, buffer);
        if (id == 0) {
            this.index = buffer.method_10816();
        } else if (id == 1) {
            if (this.index < 0) {
                return;
            }
            IConfigurableSlot slot = this.parentWidget.getConfig(this.index);
            long newAmt = buffer.method_10792();
            if (newAmt > 0L && slot.getConfig() != null) {
                slot.setConfig(new GenericStack(slot.getConfig().what(), newAmt));
            }
        }
    }

    public void drawInBackground(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        Position position = this.getPosition();
        GuiTextures.BACKGROUND.draw(graphics, mouseX, mouseY, (float)position.x, (float)position.y, 80, 30);
        DrawerHelper.drawStringSized((class_332)graphics, (String)"Amount", (float)(position.x + 3), (float)(position.y + 3), (int)0x404040, (boolean)false, (float)1.0f, (boolean)false);
        GuiTextures.DISPLAY.draw(graphics, mouseX, mouseY, (float)(position.x + 3), (float)(position.y + 11), 65, 14);
    }

    public TextFieldWidget getAmountText() {
        return this.amountText;
    }
}

