/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.machine;

import appeng.api.behaviors.GenericInternalInventory;
import appeng.api.config.Actionable;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.me.helpers.IGridConnectedBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.AEFluidGridWidget;
import com.gregtechceu.gtceu.integration.ae2.machine.MEBusPartMachine;
import com.gregtechceu.gtceu.integration.ae2.machine.MEHatchPartMachine;
import com.gregtechceu.gtceu.integration.ae2.util.SerializableGenericStackInv;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.Position;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MEOutputHatchPartMachine
extends MEHatchPartMachine
implements IInWorldGridNodeHost,
IGridConnectedBlockEntity {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MEOutputHatchPartMachine.class, MEHatchPartMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    private SerializableGenericStackInv internalBuffer;

    public MEOutputHatchPartMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, IO.IN, args);
    }

    @Override
    @NotNull
    protected NotifiableFluidTank createTank(long initialCapacity, int slots, Object ... args) {
        this.internalBuffer = new SerializableGenericStackInv(this::onChanged, slots);
        return new InaccessibleInfiniteSlot(this, this.internalBuffer);
    }

    @Override
    @NotNull
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(new Position(0, 0));
        group.addWidget((Widget)new LabelWidget(10, 15, () -> this.isOnline ? "gtceu.gui.me_network.online" : "gtceu.gui.me_network.offline"));
        group.addWidget((Widget)new AEFluidGridWidget(16, 25, 3, (GenericInternalInventory)this.internalBuffer));
        return group;
    }

    @Override
    protected void autoIO() {
        if (this.getLevel().field_9236) {
            return;
        }
        if (!this.isWorkingEnabled()) {
            return;
        }
        if (!this.shouldSyncME()) {
            return;
        }
        if (this.updateMEStatus()) {
            if (!this.internalBuffer.isEmpty()) {
                MEStorage aeNetwork = this.getMainNode().getGrid().getStorageService().getInventory();
                for (int slot = 0; slot < this.internalBuffer.size(); ++slot) {
                    GenericStack item = this.internalBuffer.getStack(slot);
                    if (item == null) continue;
                    long inserted = aeNetwork.insert(item.what(), item.amount(), Actionable.MODULATE, this.actionSource);
                    if (inserted > 0L) {
                        item = new GenericStack(item.what(), item.amount() - inserted);
                    }
                    this.internalBuffer.setStack(slot, item);
                }
            }
            this.updateTankSubscription();
        }
    }

    @Override
    protected void updateTankSubscription() {
        if (this.isWorkingEnabled() && !this.internalBuffer.isEmpty() && this.getLevel() != null && GridHelper.getNodeHost((class_1937)this.getLevel(), (class_2338)this.getPos().method_10093(this.getFrontFacing())) != null) {
            this.autoIOSubs = this.subscribeServerTick(this.autoIOSubs, this::autoIO);
        } else if (this.autoIOSubs != null) {
            this.autoIOSubs.unsubscribe();
            this.autoIOSubs = null;
        }
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    private static class InaccessibleInfiniteSlot
    extends NotifiableFluidTank
    implements IItemTransfer {
        protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(InaccessibleInfiniteSlot.class, NotifiableFluidTank.MANAGED_FIELD_HOLDER);
        private final GenericStackInv internalBuffer;

        public InaccessibleInfiniteSlot(MetaMachine holder, GenericStackInv internalBuffer) {
            super(holder, internalBuffer.size(), 0L, IO.OUT);
            this.internalBuffer = internalBuffer;
        }

        public void setStackInSlot(int slot, @Nonnull class_1799 stack) {
            GenericStack stack1 = GenericStack.fromItemStack((class_1799)stack);
            this.internalBuffer.insert(slot, stack1.what(), stack1.amount(), Actionable.MODULATE);
            this.machine.onChanged();
        }

        @Override
        public List<FluidIngredient> handleRecipeInner(IO io, GTRecipe recipe, List<FluidIngredient> left, @Nullable String slotName, boolean simulate) {
            return InaccessibleInfiniteSlot.handleIngredient(io, left, simulate, this.handlerIO, (FluidStorage[])Stream.generate(() -> new FluidStorage(0L){

                public long fill(FluidStack resource, boolean simulate, boolean notifyChanges) {
                    return this.fill(resource, simulate, notifyChanges);
                }
            }).limit(this.internalBuffer.size()).toArray(FluidStorage[]::new));
        }

        @NotNull
        public class_1799 insertItem(int slot, @NotNull class_1799 stack, boolean simulate, boolean notifyChanges) {
            if (stack.method_7960()) {
                return class_1799.field_8037;
            }
            if (!simulate) {
                IActionSource iActionSource;
                GenericStack stack1 = GenericStack.fromItemStack((class_1799)stack);
                AEKey aEKey = stack1.what();
                long l = stack1.amount();
                MetaMachine metaMachine = this.machine;
                if (metaMachine instanceof MEBusPartMachine) {
                    MEBusPartMachine host = (MEBusPartMachine)metaMachine;
                    iActionSource = host.actionSource;
                } else {
                    iActionSource = IActionSource.empty();
                }
                this.internalBuffer.insert(aEKey, l, Actionable.MODULATE, iActionSource);
                this.machine.onChanged();
            }
            return class_1799.field_8037;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public class_1799 getStackInSlot(int slot) {
            return class_1799.field_8037;
        }

        @NotNull
        public class_1799 extractItem(int slot, int amount, boolean simulate, boolean notifyChanges) {
            return class_1799.field_8037;
        }

        public int getSlotLimit(int slot) {
            return 0x7FFFFFFE;
        }

        public boolean isItemValid(int slot, @NotNull class_1799 stack) {
            return false;
        }

        @Override
        @NotNull
        public Object createSnapshot() {
            GenericStack[] stacks = new GenericStack[this.internalBuffer.size()];
            for (int i = 0; i < this.internalBuffer.size(); ++i) {
                stacks[i] = this.internalBuffer.getStack(i);
            }
            return stacks;
        }

        @Override
        public void restoreFromSnapshot(Object snapshot) {
            if (snapshot instanceof GenericStack[]) {
                GenericStack[] stacks = (GenericStack[])snapshot;
                this.internalBuffer.beginBatch();
                for (int i = 0; i < stacks.length; ++i) {
                    GenericStack stack = stacks[i];
                    if (stack == null) continue;
                    this.internalBuffer.insert(i, stack.what(), stack.amount(), Actionable.MODULATE);
                }
                this.internalBuffer.endBatch();
            }
        }

        @Override
        public ManagedFieldHolder getFieldHolder() {
            return MANAGED_FIELD_HOLDER;
        }
    }
}

