/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.machine;

import appeng.api.config.Actionable;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.me.helpers.IGridConnectedBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.AEFluidConfigWidget;
import com.gregtechceu.gtceu.integration.ae2.machine.MEHatchPartMachine;
import com.gregtechceu.gtceu.integration.ae2.util.ExportOnlyAESlot;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.Position;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.class_2487;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MEInputHatchPartMachine
extends MEHatchPartMachine
implements IInWorldGridNodeHost,
IGridConnectedBlockEntity {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MEInputHatchPartMachine.class, MEHatchPartMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    private ExportOnlyAEFluidList aeFluidTanks;

    public MEInputHatchPartMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, IO.IN, args);
    }

    @Override
    @NotNull
    protected NotifiableFluidTank createTank(long initialCapacity, int slots, Object ... args) {
        this.aeFluidTanks = new ExportOnlyAEFluidList((MetaMachine)this, slots, 0L, IO.IN);
        return this.aeFluidTanks;
    }

    @Override
    @NotNull
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(new Position(0, 0));
        group.addWidget((Widget)new LabelWidget(3, 0, () -> this.isOnline ? "gtceu.gui.me_network.online" : "gtceu.gui.me_network.offline"));
        group.addWidget((Widget)new AEFluidConfigWidget(3, 10, this.aeFluidTanks.tanks));
        return group;
    }

    @Override
    protected void autoIO() {
        if (this.getLevel().field_9236) {
            return;
        }
        if (!this.isWorkingEnabled()) {
            return;
        }
        if (!this.shouldSyncME()) {
            return;
        }
        if (this.updateMEStatus()) {
            MEStorage aeNetwork = this.getMainNode().getGrid().getStorageService().getInventory();
            for (ExportOnlyAEFluid aeTank : this.aeFluidTanks.tanks) {
                long extracted;
                GenericStack reqFluid;
                GenericStack exceedFluid = aeTank.exceedStack();
                if (exceedFluid != null) {
                    long total = exceedFluid.amount();
                    long inserted = aeNetwork.insert(exceedFluid.what(), exceedFluid.amount(), Actionable.MODULATE, this.actionSource);
                    if (inserted > 0L) {
                        aeTank.drain(inserted, false);
                        continue;
                    }
                    aeTank.drain(total, false);
                }
                if ((reqFluid = aeTank.requestStack()) == null || (extracted = aeNetwork.extract(reqFluid.what(), reqFluid.amount(), Actionable.MODULATE, this.actionSource)) <= 0L) continue;
                aeTank.addStack(new GenericStack(reqFluid.what(), extracted));
            }
            this.updateTankSubscription();
        }
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public static class ExportOnlyAEFluidList
    extends NotifiableFluidTank {
        public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ExportOnlyAEFluidList.class, NotifiableFluidTank.MANAGED_FIELD_HOLDER);
        @Persisted
        private final ExportOnlyAEFluid[] tanks;

        public ExportOnlyAEFluidList(MetaMachine machine, int slots, long capacity, IO io) {
            super(machine, slots, capacity, io);
            this.tanks = new ExportOnlyAEFluid[slots];
            for (int i = 0; i < slots; ++i) {
                this.tanks[i] = new ExportOnlyAEFluid(null, null);
                this.tanks[i].setOnContentsChanged(this::onContentsChanged);
            }
        }

        @Override
        public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
            return 0L;
        }

        @Override
        public List<FluidIngredient> handleRecipeInner(IO io, GTRecipe recipe, List<FluidIngredient> left, @Nullable String slotName, boolean simulate) {
            return ExportOnlyAEFluidList.handleIngredient(io, left, simulate, this.handlerIO, (FluidStorage[])Arrays.stream(this.tanks).map(tank -> new WrappingFluidStorage(tank.getCapacity(), (ExportOnlyAEFluid)tank)).toArray(FluidStorage[]::new));
        }

        @Override
        public FluidStack drainInternal(long maxDrain, boolean simulate) {
            if (maxDrain == 0L) {
                return FluidStack.empty();
            }
            FluidStack totalDrained = null;
            for (ExportOnlyAEFluid tank : this.tanks) {
                if (totalDrained == null || totalDrained.isEmpty()) {
                    totalDrained = tank.drain(maxDrain, simulate);
                    if (totalDrained.isEmpty()) {
                        totalDrained = null;
                    } else {
                        maxDrain -= totalDrained.getAmount();
                    }
                } else {
                    FluidStack copy = totalDrained.copy();
                    copy.setAmount(maxDrain);
                    FluidStack drain = tank.drain(copy, simulate);
                    totalDrained.grow(drain.getAmount());
                    maxDrain -= drain.getAmount();
                }
                if (maxDrain <= 0L) break;
            }
            return totalDrained == null ? FluidStack.empty() : totalDrained;
        }

        @Override
        @NotNull
        public Object createSnapshot() {
            return Arrays.stream(this.tanks).map(IFluidTransfer::createSnapshot).toArray(Object[]::new);
        }

        @Override
        public void restoreFromSnapshot(Object snapshot) {
            Object[] array;
            if (snapshot instanceof Object[] && (array = (Object[])snapshot).length == this.tanks.length) {
                for (int i = 0; i < array.length; ++i) {
                    this.tanks[i].restoreFromSnapshot(array[i]);
                }
            }
        }

        @Override
        public ManagedFieldHolder getFieldHolder() {
            return MANAGED_FIELD_HOLDER;
        }

        private static class WrappingFluidStorage
        extends FluidStorage {
            private final ExportOnlyAEFluid fluid;

            public WrappingFluidStorage(long capacity, ExportOnlyAEFluid fluid) {
                super(capacity);
                this.fluid = fluid;
            }

            public WrappingFluidStorage(long capacity, Predicate<FluidStack> validator, ExportOnlyAEFluid fluid) {
                super(capacity, validator);
                this.fluid = fluid;
            }

            @Nonnull
            public FluidStack getFluid() {
                return this.fluid.getFluid();
            }

            @NotNull
            public FluidStack drain(FluidStack maxDrain, boolean simulate, boolean notifyChanges) {
                return this.fluid.drain(maxDrain, simulate, notifyChanges);
            }

            public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChange) {
                return this.fluid.fill(tank, resource, simulate, notifyChange);
            }

            public FluidStorage copy() {
                WrappingFluidStorage storage = new WrappingFluidStorage(this.capacity, this.validator, this.fluid);
                storage.setFluid(((FluidStorage)this).fluid.copy());
                return storage;
            }
        }
    }

    public static class ExportOnlyAEFluid
    extends ExportOnlyAESlot
    implements IFluidStorage,
    IFluidTransfer {
        public ExportOnlyAEFluid(GenericStack config, GenericStack stock) {
            super(config, stock);
        }

        public ExportOnlyAEFluid() {
        }

        @Override
        public void addStack(GenericStack stack) {
            this.stock = this.stock == null ? stack : GenericStack.sum((GenericStack)this.stock, (GenericStack)stack);
            this.trigger();
        }

        @NotNull
        public FluidStack getFluid() {
            AEKey aEKey;
            if (this.stock != null && (aEKey = this.stock.what()) instanceof AEFluidKey) {
                AEFluidKey fluidKey = (AEFluidKey)aEKey;
                return FluidStack.create((class_3611)fluidKey.getFluid(), (long)(this.stock == null ? 0L : this.stock.amount()), (class_2487)fluidKey.getTag());
            }
            return FluidStack.empty();
        }

        public void setFluid(FluidStack fluid) {
        }

        public long getFluidAmount() {
            return this.stock != null ? this.stock.amount() : 0L;
        }

        public long getCapacity() {
            return 0L;
        }

        public boolean isFluidValid(FluidStack stack) {
            return false;
        }

        public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
            return 0L;
        }

        public boolean supportsFill(int tank) {
            return false;
        }

        @NotNull
        public FluidStack drain(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
            return this.drain(resource, simulate, notifyChanges);
        }

        public boolean supportsDrain(int tank) {
            return tank == 0;
        }

        public long fill(FluidStack resource, boolean doFill) {
            return 0L;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, boolean doDrain, boolean notifyChanges) {
            if (this.getFluid().isFluidEqual(resource)) {
                return this.drain(resource.getAmount(), doDrain, notifyChanges);
            }
            return FluidStack.empty();
        }

        @NotNull
        public FluidStack drain(long maxDrain, boolean simulate, boolean notifyChanges) {
            AEKey aEKey;
            if (this.stock == null || !((aEKey = this.stock.what()) instanceof AEFluidKey)) {
                return FluidStack.empty();
            }
            AEFluidKey fluidKey = (AEFluidKey)aEKey;
            int drained = (int)Math.min(this.stock.amount(), maxDrain);
            FluidStack result = FluidStack.create((class_3611)fluidKey.getFluid(), (long)drained, (class_2487)fluidKey.getTag());
            if (!simulate) {
                this.stock = new GenericStack(this.stock.what(), this.stock.amount() - (long)drained);
                if (this.stock.amount() == 0L) {
                    this.stock = null;
                }
                if (notifyChanges) {
                    this.trigger();
                }
            }
            return result;
        }

        @NotNull
        public Object createSnapshot() {
            return Pair.of((Object)this.config, (Object)this.stock);
        }

        public void restoreFromSnapshot(Object snapshot) {
            if (snapshot instanceof Pair) {
                Pair pair = (Pair)snapshot;
                this.config = (GenericStack)pair.getFirst();
                this.stock = (GenericStack)pair.getSecond();
            }
        }

        private void trigger() {
            if (this.onContentsChanged != null) {
                this.onContentsChanged.run();
            }
        }

        @Override
        public ExportOnlyAEFluid copy() {
            return new ExportOnlyAEFluid(this.config == null ? null : ExportOnlyAESlot.copy(this.config), this.stock == null ? null : ExportOnlyAESlot.copy(this.stock));
        }
    }
}

