/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.machine;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.me.helpers.BlockEntityNodeListener;
import appeng.me.helpers.IGridConnectedBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.common.machine.multiblock.part.ItemBusPartMachine;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.ae2.util.SerializableManagedGridNode;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.ReadOnlyManaged;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.EnumSet;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3738;

public abstract class MEBusPartMachine
extends ItemBusPartMachine
implements IInWorldGridNodeHost,
IGridConnectedBlockEntity {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MEBusPartMachine.class, ItemBusPartMachine.MANAGED_FIELD_HOLDER);
    public static final int ME_UPDATE_INTERVAL = ConfigHolder.INSTANCE.compat.ae2.updateIntervals;
    @Persisted
    @ReadOnlyManaged(onDirtyMethod="onGridNodeDirty", serializeMethod="serializeGridNode", deserializeMethod="deserializeGridNode")
    private final SerializableManagedGridNode mainNode;
    protected final IActionSource actionSource;
    @DescSynced
    protected boolean isOnline;
    private IGrid aeProxy;

    public MEBusPartMachine(IMachineBlockEntity holder, IO io, Object ... args) {
        super(holder, 9, io, args);
        this.mainNode = (SerializableManagedGridNode)this.createMainNode().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL}).setVisualRepresentation((class_1935)this.getDefinition().getItem()).setIdlePowerUsage(ConfigHolder.INSTANCE.compat.ae2.meHatchEnergyUsage).setInWorldNode(true).setExposedOnSides(this.hasFrontFacing() ? EnumSet.of(this.getFrontFacing()) : EnumSet.allOf(class_2350.class)).setTagName("proxy");
        this.actionSource = IActionSource.ofMachine(() -> ((SerializableManagedGridNode)this.mainNode).getNode());
    }

    protected boolean shouldSyncME() {
        return this.getOffsetTimer() % (long)ME_UPDATE_INTERVAL == 0L;
    }

    @Override
    public void setFrontFacing(class_2350 facing) {
        super.setFrontFacing(facing);
        if (this.isFacingValid(facing)) {
            this.mainNode.setExposedOnSides(this.hasFrontFacing() ? EnumSet.of(facing) : EnumSet.allOf(class_2350.class));
        }
    }

    @Override
    protected void updateInventorySubscription() {
        if (this.isWorkingEnabled() && (this.io == IO.OUT && !this.getInventory().isEmpty() || this.io == IO.IN) && this.getLevel() != null && GridHelper.getNodeHost((class_1937)this.getLevel(), (class_2338)this.getPos().method_10093(this.getFrontFacing())) != null) {
            this.autoIOSubs = this.subscribeServerTick(this.autoIOSubs, () -> this.autoIO());
        } else if (this.autoIOSubs != null) {
            this.autoIOSubs.unsubscribe();
            this.autoIOSubs = null;
        }
    }

    public boolean updateMEStatus() {
        if (this.aeProxy == null) {
            this.aeProxy = this.mainNode.getGrid();
        }
        this.isOnline = this.aeProxy != null ? this.mainNode.isOnline() && this.mainNode.isPowered() : false;
        return this.isOnline;
    }

    protected IManagedGridNode createMainNode() {
        return new SerializableManagedGridNode(this, BlockEntityNodeListener.INSTANCE);
    }

    public void saveChanges() {
        this.onChanged();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        class_1937 class_19372 = this.getLevel();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_8503().method_18858((Runnable)new class_3738(0, this::createManagedNode));
            this.inventorySubs = this.getInventory().addChangedListener(this::updateInventorySubscription);
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        this.mainNode.destroy();
    }

    @Override
    public void onChanged() {
        super.onChanged();
        this.updateInventorySubscription();
    }

    protected void createManagedNode() {
        this.mainNode.create(this.getLevel(), this.getPos());
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public boolean onGridNodeDirty(SerializableManagedGridNode node) {
        return node != null && node.isActive() && node.isOnline();
    }

    public class_2487 serializeGridNode(SerializableManagedGridNode node) {
        return node.serializeNBT();
    }

    public SerializableManagedGridNode deserializeGridNode(class_2487 tag) {
        this.mainNode.deserializeNBT(tag);
        return this.mainNode;
    }

    public SerializableManagedGridNode getMainNode() {
        return this.mainNode;
    }
}

