/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.gui.widget;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.client.TooltipsHandler;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.AEListGridWidget;
import com.gregtechceu.gtceu.integration.ae2.util.AEConfigSlot;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;

public class AEFluidDisplayWidget
extends Widget {
    private final AEListGridWidget gridWidget;
    private final int index;

    public AEFluidDisplayWidget(int x, int y, AEListGridWidget gridWidget, int index) {
        super(new Position(x, y), new Size(18, 18));
        this.gridWidget = gridWidget;
        this.index = index;
    }

    public void drawInBackground(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        Position position = this.getPosition();
        GenericStack fluid = this.gridWidget.getAt(this.index);
        GuiTextures.FLUID_SLOT.draw(graphics, mouseX, mouseY, (float)position.x, (float)position.y, 18, 18);
        GuiTextures.NUMBER_BACKGROUND.draw(graphics, mouseX, mouseY, (float)(position.x + 18), (float)position.y, 140, 18);
        int stackX = position.x + 1;
        int stackY = position.y + 1;
        if (fluid != null) {
            FluidStack fluidStack;
            AEKey aEKey = fluid.what();
            if (aEKey instanceof AEFluidKey) {
                AEFluidKey key = (AEFluidKey)aEKey;
                fluidStack = FluidStack.create((class_3611)key.getFluid(), (long)fluid.amount(), (class_2487)key.getTag());
            } else {
                fluidStack = FluidStack.empty();
            }
            FluidStack fluidStack2 = fluidStack;
            DrawerHelper.drawFluidForGui((class_332)graphics, (FluidStack)fluidStack2, (long)fluid.amount(), (int)stackX, (int)stackY, (int)17, (int)17);
            String amountStr = String.format("x%,d", fluid.amount());
            DrawerHelper.drawText((class_332)graphics, (String)amountStr, (float)(stackX + 20), (float)(stackY + 5), (float)1.0f, (int)-1);
        }
        if (this.isMouseOverElement(mouseX, mouseY)) {
            AEConfigSlot.drawSelectionOverlay(graphics, stackX, stackY, 16, 16);
        }
    }

    public void drawInForeground(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        GenericStack fluid;
        if (this.isMouseOverElement(mouseX, mouseY) && (fluid = this.gridWidget.getAt(this.index)) != null) {
            FluidStack fluidStack;
            AEKey aEKey = fluid.what();
            if (aEKey instanceof AEFluidKey) {
                AEFluidKey key = (AEFluidKey)aEKey;
                fluidStack = FluidStack.create((class_3611)key.getFluid(), (long)fluid.amount(), (class_2487)key.getTag());
            } else {
                fluidStack = FluidStack.empty();
            }
            FluidStack fluidStack2 = fluidStack;
            ArrayList<class_2561> tooltips = new ArrayList<class_2561>();
            tooltips.add(fluidStack2.getDisplayName());
            tooltips.add((class_2561)class_2561.method_43470((String)String.format("%,d ", fluid.amount())).method_27693(FluidHelper.getUnit()));
            if (!Platform.isForge()) {
                tooltips.add((class_2561)class_2561.method_43470((String)"\u00a76mB:\u00a7r %d mB".formatted(fluidStack2.getAmount() * 1000L / FluidHelper.getBucket())));
            }
            TooltipsHandler.appendFluidTooltips(fluidStack2.getFluid(), tooltips, (class_1836)class_1836.field_41070);
            graphics.method_51437(class_310.method_1551().field_1772, tooltips, Optional.empty(), mouseX, mouseY);
        }
    }
}

