/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.misc;

import com.google.common.collect.ImmutableList;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.BlastProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.ItemMaterialInfo;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class RecyclingRecipes {
    private static final List<TagPrefix> DUST_ORDER = ImmutableList.of((Object)TagPrefix.dust, (Object)TagPrefix.dustSmall, (Object)TagPrefix.dustTiny);
    private static final List<TagPrefix> INGOT_ORDER = ImmutableList.of((Object)TagPrefix.block, (Object)TagPrefix.ingot, (Object)TagPrefix.nugget);

    public static void init(Consumer<class_2444> provider) {
        for (Map.Entry<class_1799, ItemMaterialInfo> entry : ChemicalHelper.getAllItemInfos()) {
            class_1799 itemStack = entry.getKey();
            ItemMaterialInfo materialInfo = entry.getValue();
            ArrayList<MaterialStack> materialStacks = new ArrayList<MaterialStack>((Collection<MaterialStack>)materialInfo.getMaterials());
            RecyclingRecipes.registerRecyclingRecipes(provider, itemStack, materialStacks, false, null);
        }
    }

    public static void registerRecyclingRecipes(Consumer<class_2444> provider, class_1799 input, List<MaterialStack> components, boolean ignoreArcSmelting, @Nullable TagPrefix prefix) {
        List<MaterialStack> materials = components.stream().filter(stack -> stack.material().hasProperty(PropertyKey.DUST)).filter(stack -> stack.amount() >= 403200L).sorted(Comparator.comparingLong(ms -> -ms.amount())).toList();
        if (materials.isEmpty()) {
            return;
        }
        int voltageMultiplier = RecyclingRecipes.calculateVoltageMultiplier(components);
        if (prefix != TagPrefix.dust) {
            RecyclingRecipes.registerMaceratorRecycling(provider, input, components, voltageMultiplier);
        }
        if (prefix != null) {
            RecyclingRecipes.registerExtractorRecycling(provider, input, components, voltageMultiplier, prefix);
        }
        if (ignoreArcSmelting) {
            return;
        }
        if (components.size() == 1) {
            Material m = components.get(0).material();
            if (!m.hasProperty(PropertyKey.INGOT)) {
                return;
            }
            if (ChemicalHelper.getPrefix((class_1935)input.method_7909()) == TagPrefix.ingot && m.getProperty(PropertyKey.INGOT).getArcSmeltingInto() == m) {
                return;
            }
            if (prefix == TagPrefix.dust && m.hasFlag(MaterialFlags.IS_MAGNETIC)) {
                return;
            }
        }
        RecyclingRecipes.registerArcRecycling(provider, input, components, prefix);
    }

    private static void registerMaceratorRecycling(Consumer<class_2444> provider, class_1799 input, List<MaterialStack> materials, int multiplier) {
        List<class_1799> outputs = RecyclingRecipes.finalizeOutputs(materials, GTRecipeTypes.MACERATOR_RECIPES.getMaxOutputs(ItemRecipeCapability.CAP), ChemicalHelper::getDust);
        UnificationEntry entry = ChemicalHelper.getUnificationEntry((class_1935)input.method_7909());
        class_6862<class_1792> inputTag = null;
        if (entry != null) {
            inputTag = ChemicalHelper.getTag(entry.tagPrefix, entry.material);
        }
        if (outputs.size() == 0) {
            return;
        }
        class_2960 itemPath = class_7923.field_41178.method_10221((Object)input.method_7909());
        GTRecipeBuilder builder = GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_" + itemPath.method_12832(), new Object[0]).outputItems((class_1799[])outputs.toArray(class_1799[]::new)).duration(RecyclingRecipes.calculateDuration(outputs)).EUt(2L * (long)multiplier);
        if (inputTag == null) {
            builder.inputItems(input.method_7972());
        } else {
            builder.inputItems(inputTag);
        }
        builder.save(provider);
    }

    private static void registerExtractorRecycling(Consumer<class_2444> provider, class_1799 input, List<MaterialStack> materials, int multiplier, @Nullable TagPrefix prefix) {
        class_1799 outputStack;
        UnificationEntry entry = ChemicalHelper.getUnificationEntry((class_1935)input.method_7909());
        class_6862<class_1792> inputTag = null;
        if (entry != null) {
            inputTag = ChemicalHelper.getTag(entry.tagPrefix, entry.material);
        }
        if (prefix != null && prefix.secondaryMaterials().isEmpty()) {
            MaterialStack ms2 = ChemicalHelper.getMaterial(input);
            if (ms2 == null || ms2.material() == null) {
                return;
            }
            Material m = ms2.material();
            if (m.hasProperty(PropertyKey.INGOT) && m.getProperty(PropertyKey.INGOT).getMacerateInto() != m) {
                m = m.getProperty(PropertyKey.INGOT).getMacerateInto();
            }
            if (!m.hasProperty(PropertyKey.FLUID) || prefix == TagPrefix.dust && m.hasProperty(PropertyKey.BLAST)) {
                return;
            }
            class_2960 itemPath = class_7923.field_41178.method_10221((Object)input.method_7909());
            GTRecipeBuilder builder = GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("extract_" + itemPath.method_12832(), new Object[0]).outputFluids(m.getFluid((int)(ms2.amount() * 144L / 3628800L))).duration((int)Math.max(1L, ms2.amount() * ms2.material().getMass() / 3628800L)).EUt((long)GTValues.VA[1] * (long)multiplier);
            if (inputTag == null) {
                builder.inputItems(input.method_7972());
            } else {
                builder.inputItems(inputTag);
            }
            builder.save(provider);
            return;
        }
        MaterialStack fluidMs = materials.stream().filter(ms -> ms.material().hasProperty(PropertyKey.FLUID)).findFirst().orElse(null);
        if (fluidMs == null) {
            return;
        }
        MaterialStack itemMs = materials.stream().filter(ms -> !ms.material().equals(fluidMs.material())).findFirst().orElse(null);
        long duration = fluidMs.amount() * fluidMs.material().getMass();
        if (itemMs != null) {
            duration += itemMs.amount() * itemMs.material().getMass();
        }
        duration = Math.max(1L, duration / 3628800L);
        class_2960 itemPath = class_7923.field_41178.method_10221((Object)input.method_7909());
        GTRecipeBuilder extractorBuilder = GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("extract_" + itemPath.method_12832(), new Object[0]).outputFluids(fluidMs.material().getFluid((int)(fluidMs.amount() * 144L / 3628800L))).duration((int)duration).EUt((long)GTValues.VA[1] * (long)multiplier);
        if (inputTag == null) {
            extractorBuilder.inputItems(input.method_7972());
        } else {
            extractorBuilder.inputItems(inputTag);
        }
        if (itemMs != null && !(outputStack = ChemicalHelper.getIngotOrDust(itemMs)).method_7960()) {
            extractorBuilder.outputItems(outputStack);
        }
        extractorBuilder.save(provider);
    }

    private static void registerArcRecycling(Consumer<class_2444> provider, class_1799 input, List<MaterialStack> materials, @Nullable TagPrefix prefix) {
        UnificationEntry entry = ChemicalHelper.getUnificationEntry((class_1935)input.method_7909());
        class_6862<class_1792> inputTag = null;
        if (entry != null) {
            inputTag = ChemicalHelper.getTag(entry.tagPrefix, entry.material);
        }
        MaterialStack ms = ChemicalHelper.getMaterial(input);
        if (prefix == TagPrefix.dust && ms != null && ms.material().hasProperty(PropertyKey.BLAST)) {
            return;
        }
        if (prefix == TagPrefix.block) {
            if (ms != null && !ms.material().hasProperty(PropertyKey.GEM)) {
                class_1799 output = ChemicalHelper.get(TagPrefix.ingot, ms.material().getProperty(PropertyKey.INGOT).getArcSmeltingInto(), 9);
                class_2960 itemPath = class_7923.field_41178.method_10221((Object)input.method_7909());
                GTRecipeBuilder builder = GTRecipeTypes.ARC_FURNACE_RECIPES.recipeBuilder("arc_" + itemPath.method_12832(), new Object[0]).outputItems(output).duration(RecyclingRecipes.calculateDuration(Collections.singletonList(output))).EUt(GTValues.VA[1]);
                if (inputTag == null) {
                    builder.inputItems(input.method_7972());
                } else {
                    builder.inputItems(inputTag);
                }
                builder.save(provider);
            }
            return;
        }
        List<class_1799> outputs = RecyclingRecipes.finalizeOutputs(materials = RecyclingRecipes.combineStacks(materials.stream().map(RecyclingRecipes::getArcSmeltingResult).filter(Objects::nonNull).collect(Collectors.toList())), GTRecipeTypes.ARC_FURNACE_RECIPES.getMaxOutputs(ItemRecipeCapability.CAP), RecyclingRecipes::getArcIngotOrDust);
        if (outputs.size() == 0) {
            return;
        }
        class_2960 itemPath = class_7923.field_41178.method_10221((Object)input.method_7909());
        GTRecipeBuilder builder = GTRecipeTypes.ARC_FURNACE_RECIPES.recipeBuilder("arc_" + itemPath.method_12832(), new Object[0]).outputItems((class_1799[])outputs.toArray(class_1799[]::new)).duration(RecyclingRecipes.calculateDuration(outputs)).EUt(GTValues.VA[1]);
        if (inputTag == null) {
            builder.inputItems(input.method_7972());
        } else {
            builder.inputItems(inputTag);
        }
        builder.save(provider);
    }

    private static MaterialStack getArcSmeltingResult(MaterialStack materialStack) {
        Material arcSmelt;
        Material material = materialStack.material();
        long amount = materialStack.amount();
        if (material.hasFlag(MaterialFlags.EXPLOSIVE)) {
            return new MaterialStack(GTMaterials.Ash, amount / 16L);
        }
        if (material.hasFlag(MaterialFlags.FLAMMABLE)) {
            return new MaterialStack(GTMaterials.Ash, amount / 8L);
        }
        if (material.hasProperty(PropertyKey.GEM)) {
            return RecyclingRecipes.getGemArcSmeltResult(materialStack);
        }
        if (material.hasFlag(MaterialFlags.NO_SMELTING)) {
            return null;
        }
        if (material.hasProperty(PropertyKey.INGOT) && (arcSmelt = material.getProperty(PropertyKey.INGOT).getArcSmeltingInto()) != null) {
            return new MaterialStack(arcSmelt, amount);
        }
        return materialStack;
    }

    private static class_1799 getArcIngotOrDust(@Nonnull MaterialStack stack) {
        if (stack.material() == GTMaterials.Carbon) {
            return ChemicalHelper.getDust(stack);
        }
        return ChemicalHelper.getIngotOrDust(stack);
    }

    private static MaterialStack getGemArcSmeltResult(MaterialStack materialStack) {
        Material material = materialStack.material();
        long amount = materialStack.amount();
        if (material.getMaterialComponents().stream().anyMatch(stack -> stack.material() == GTMaterials.Oxygen)) {
            return new MaterialStack(GTMaterials.Ash, amount / 8L);
        }
        if (material.getMaterialComponents().stream().anyMatch(stack -> stack.material() == GTMaterials.Carbon)) {
            return new MaterialStack(GTMaterials.Carbon, amount / 8L);
        }
        return new MaterialStack(GTMaterials.DarkAsh, amount / 8L);
    }

    private static int calculateVoltageMultiplier(List<MaterialStack> materials) {
        int highestTemp = 0;
        for (MaterialStack ms : materials) {
            BlastProperty prop;
            Material m = ms.material();
            if (m.hasProperty(PropertyKey.BLAST)) {
                prop = m.getProperty(PropertyKey.BLAST);
                if (prop.getBlastTemperature() <= highestTemp) continue;
                highestTemp = prop.getBlastTemperature();
                continue;
            }
            if (!m.hasFlag(MaterialFlags.IS_MAGNETIC) || !m.hasProperty(PropertyKey.INGOT) || !m.getProperty(PropertyKey.INGOT).getSmeltingInto().hasProperty(PropertyKey.BLAST) || (prop = m.getProperty(PropertyKey.INGOT).getSmeltingInto().getProperty(PropertyKey.BLAST)).getBlastTemperature() <= highestTemp) continue;
            highestTemp = prop.getBlastTemperature();
        }
        if (highestTemp == 0) {
            return 1;
        }
        if (highestTemp < 2000) {
            return 4;
        }
        return 16;
    }

    private static int calculateDuration(List<class_1799> materials) {
        long duration = 0L;
        for (class_1799 is : materials) {
            MaterialStack ms = ChemicalHelper.getMaterial(is);
            if (ms == null) continue;
            duration += ms.amount() * ms.material().getMass() * (long)is.method_7947();
        }
        return (int)Math.max(1L, duration / 3628800L);
    }

    private static List<MaterialStack> combineStacks(List<MaterialStack> rawList) {
        HashMap<Material, Long> materialStacksExploded = new HashMap<Material, Long>();
        for (MaterialStack ms : rawList) {
            long amount = materialStacksExploded.getOrDefault(ms.material(), 0L);
            materialStacksExploded.put(ms.material(), ms.amount() + amount);
        }
        return materialStacksExploded.entrySet().stream().map(e -> new MaterialStack((Material)e.getKey(), (Long)e.getValue())).collect(Collectors.toList());
    }

    private static List<class_1799> finalizeOutputs(List<MaterialStack> materials, int maxOutputs, Function<MaterialStack, class_1799> toItemStackMapper) {
        ArrayList<class_3545<class_1799, MaterialStack>> outputs = new ArrayList<class_3545<class_1799, MaterialStack>>();
        for (MaterialStack materialStack : materials) {
            class_1799 class_17992 = toItemStackMapper.apply(materialStack);
            if (class_17992 == class_1799.field_8037) continue;
            if (class_17992.method_7947() > 64) {
                UnificationEntry entry = ChemicalHelper.getUnificationEntry((class_1935)class_17992.method_7909());
                if (entry == null) continue;
                TagPrefix prefix = entry.tagPrefix;
                if (prefix == TagPrefix.block || prefix == TagPrefix.dust) {
                    RecyclingRecipes.splitStacks(outputs, class_17992, entry);
                    continue;
                }
                ArrayList<class_3545<class_1799, MaterialStack>> split = new ArrayList<class_3545<class_1799, MaterialStack>>();
                ArrayList<class_3545<class_1799, MaterialStack>> shrink = new ArrayList<class_3545<class_1799, MaterialStack>>();
                RecyclingRecipes.splitStacks(split, class_17992, entry);
                RecyclingRecipes.shrinkStacks(shrink, class_17992, entry);
                if (((MaterialStack)((class_3545)split.get(0)).method_15441()).amount() > ((MaterialStack)((class_3545)shrink.get(0)).method_15441()).amount()) {
                    outputs.addAll(split);
                    continue;
                }
                outputs.addAll(shrink);
                continue;
            }
            outputs.add(new class_3545((Object)class_17992, (Object)materialStack));
        }
        outputs.sort(Comparator.comparingLong(e -> -((MaterialStack)e.method_15441()).amount()));
        HashMap<MaterialStack, class_1799> temp = new HashMap<MaterialStack, class_1799>();
        for (class_3545 class_35452 : outputs) {
            boolean isInMap = false;
            for (MaterialStack ms : temp.keySet()) {
                if (ms.material() != ((MaterialStack)class_35452.method_15441()).material()) continue;
                isInMap = true;
                break;
            }
            if (isInMap) continue;
            temp.put((MaterialStack)class_35452.method_15441(), (class_1799)class_35452.method_15442());
        }
        temp.putAll(outputs.stream().filter(t -> !temp.containsKey(t.method_15441())).collect(Collectors.toMap(class_3545::method_15441, class_3545::method_15442)));
        List list = temp.entrySet().stream().filter(e -> RecyclingRecipes.isAshMaterial((MaterialStack)e.getKey())).sorted(Comparator.comparingLong(e -> -((MaterialStack)e.getKey()).amount())).map(Map.Entry::getValue).collect(Collectors.toList());
        List<class_1799> list2 = temp.entrySet().stream().sorted(Comparator.comparingLong(e -> -((MaterialStack)e.getKey()).amount())).filter(e -> !RecyclingRecipes.isAshMaterial((MaterialStack)e.getKey())).limit(maxOutputs).map(Map.Entry::getValue).collect(Collectors.toList());
        for (int i = 0; i < list.size() && list2.size() < maxOutputs; ++i) {
            list2.add((class_1799)list.get(i));
        }
        return list2;
    }

    private static void splitStacks(List<class_3545<class_1799, MaterialStack>> list, class_1799 originalStack, UnificationEntry entry) {
        int amount;
        for (amount = originalStack.method_7947(); amount > 64; amount -= 64) {
            list.add((class_3545<class_1799, MaterialStack>)new class_3545((Object)GTUtil.copyAmount(64, originalStack), (Object)new MaterialStack(entry.material, entry.tagPrefix.getMaterialAmount(entry.material) * 64L)));
        }
        list.add((class_3545<class_1799, MaterialStack>)new class_3545((Object)GTUtil.copyAmount(amount, originalStack), (Object)new MaterialStack(entry.material, entry.tagPrefix.getMaterialAmount(entry.material) * (long)amount)));
    }

    private static void shrinkStacks(List<class_3545<class_1799, MaterialStack>> list, class_1799 originalStack, UnificationEntry entry) {
        long singleStackAmount;
        Material material = entry.material;
        long materialAmount = (long)originalStack.method_7947() * entry.tagPrefix.getMaterialAmount(material);
        List<TagPrefix> chosenList = material.hasProperty(PropertyKey.INGOT) ? INGOT_ORDER : DUST_ORDER;
        HashMap<TagPrefix, MaterialStack> tempList = new HashMap<TagPrefix, MaterialStack>();
        for (TagPrefix prefix : chosenList) {
            if (materialAmount / prefix.getMaterialAmount(material) == 0L) continue;
            long newAmount = materialAmount / prefix.getMaterialAmount(material);
            tempList.put(prefix, new MaterialStack(material, newAmount * prefix.getMaterialAmount(material)));
            materialAmount %= prefix.getMaterialAmount(material);
        }
        if (tempList.containsKey(chosenList.get(0))) {
            TagPrefix prefix = chosenList.get(0);
            MaterialStack ms = (MaterialStack)tempList.get(prefix);
            RecyclingRecipes.splitStacks(list, ChemicalHelper.get(chosenList.get(0), ms.material(), (int)(ms.amount() / prefix.getMaterialAmount(material))), new UnificationEntry(prefix, material));
        }
        TagPrefix mediumPrefix = chosenList.get(1);
        TagPrefix smallestPrefix = chosenList.get(2);
        MaterialStack mediumMS = (MaterialStack)tempList.get(mediumPrefix);
        MaterialStack smallestMS = (MaterialStack)tempList.get(smallestPrefix);
        if (mediumMS != null && smallestMS != null && (singleStackAmount = mediumMS.amount() + smallestMS.amount()) / smallestPrefix.getMaterialAmount(material) <= 64L) {
            list.add((class_3545<class_1799, MaterialStack>)new class_3545((Object)ChemicalHelper.get(smallestPrefix, material, (int)(singleStackAmount / smallestPrefix.getMaterialAmount(material))), (Object)new MaterialStack(material, singleStackAmount)));
            return;
        }
        if (mediumMS != null) {
            list.add((class_3545<class_1799, MaterialStack>)new class_3545((Object)ChemicalHelper.get(mediumPrefix, material, (int)(mediumMS.amount() / mediumPrefix.getMaterialAmount(material))), (Object)new MaterialStack(material, mediumMS.amount())));
        }
        if (smallestMS != null) {
            list.add((class_3545<class_1799, MaterialStack>)new class_3545((Object)ChemicalHelper.get(smallestPrefix, material, (int)(smallestMS.amount() / smallestPrefix.getMaterialAmount(material))), (Object)new MaterialStack(material, smallestMS.amount())));
        }
    }

    private static boolean isAshMaterial(MaterialStack ms) {
        return ms.material() == GTMaterials.Ash || ms.material() == GTMaterials.DarkAsh || ms.material() == GTMaterials.Carbon;
    }
}

