/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.recipe.ingredient.NBTIngredient;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.utils.NBTToJsonConverter;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2444;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class SmeltingRecipeBuilder {
    private class_1856 input;
    protected String group;
    private class_1799 output = class_1799.field_8037;
    private float experience;
    private int cookingTime;
    protected class_2960 id;

    public SmeltingRecipeBuilder(@Nullable class_2960 id) {
        this.id = id;
    }

    public SmeltingRecipeBuilder input(class_6862<class_1792> itemStack) {
        return this.input(class_1856.method_8106(itemStack));
    }

    public SmeltingRecipeBuilder input(class_1799 itemStack) {
        this.input = itemStack.method_7985() || itemStack.method_7919() > 0 ? NBTIngredient.createNBTIngredient(itemStack) : class_1856.method_8101((class_1799[])new class_1799[]{itemStack});
        return this;
    }

    public SmeltingRecipeBuilder input(class_1935 itemLike) {
        return this.input(class_1856.method_8091((class_1935[])new class_1935[]{itemLike}));
    }

    public SmeltingRecipeBuilder input(class_1856 ingredient) {
        this.input = ingredient;
        return this;
    }

    public SmeltingRecipeBuilder output(class_1799 itemStack) {
        this.output = itemStack.method_7972();
        return this;
    }

    public SmeltingRecipeBuilder output(class_1799 itemStack, int count) {
        this.output = itemStack.method_7972();
        this.output.method_7939(count);
        return this;
    }

    public SmeltingRecipeBuilder output(class_1799 itemStack, int count, class_2487 nbt) {
        this.output = itemStack.method_7972();
        this.output.method_7939(count);
        this.output.method_7980(nbt);
        return this;
    }

    protected class_2960 defaultId() {
        return class_7923.field_41178.method_10221((Object)this.output.method_7909());
    }

    public void toJson(JsonObject json) {
        if (this.group != null) {
            json.addProperty("group", this.group);
        }
        if (!this.input.method_8103()) {
            json.add("ingredient", this.input.method_8089());
        }
        if (this.output.method_7960()) {
            LDLib.LOGGER.error("shapeless recipe {} output is empty", (Object)this.id);
            throw new IllegalArgumentException(this.id + ": output items is empty");
        }
        JsonObject result = new JsonObject();
        result.addProperty("item", class_7923.field_41178.method_10221((Object)this.output.method_7909()).toString());
        if (this.output.method_7947() > 1) {
            result.addProperty("count", (Number)this.output.method_7947());
        }
        if (this.output.method_7985() && this.output.method_7969() != null) {
            result.add("nbt", NBTToJsonConverter.getObject((class_2520)this.output.method_7969()));
        }
        json.add("result", (JsonElement)result);
        json.addProperty("experience", (Number)Float.valueOf(this.experience));
        json.addProperty("cookingtime", (Number)this.cookingTime);
    }

    public void save(Consumer<class_2444> consumer) {
        consumer.accept(new class_2444(){

            public void method_10416(JsonObject pJson) {
                SmeltingRecipeBuilder.this.toJson(pJson);
            }

            public class_2960 method_10417() {
                class_2960 ID = SmeltingRecipeBuilder.this.id == null ? SmeltingRecipeBuilder.this.defaultId() : SmeltingRecipeBuilder.this.id;
                return new class_2960(ID.method_12836(), "smelting/" + ID.method_12832());
            }

            public class_1865<?> method_17800() {
                return class_1865.field_9042;
            }

            @Nullable
            public JsonObject method_10415() {
                return null;
            }

            @Nullable
            public class_2960 method_10418() {
                return null;
            }
        });
    }

    public SmeltingRecipeBuilder group(String group) {
        this.group = group;
        return this;
    }

    public SmeltingRecipeBuilder experience(float experience) {
        this.experience = experience;
        return this;
    }

    public SmeltingRecipeBuilder cookingTime(int cookingTime) {
        this.cookingTime = cookingTime;
        return this;
    }

    public SmeltingRecipeBuilder id(class_2960 id) {
        this.id = id;
        return this;
    }
}

