/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.pack;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.pack.GTDynamicDataPack;
import com.lowdragmc.lowdraglib.Platform;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_6328;
import net.minecraft.class_7367;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@class_6328
@ParametersAreNonnullByDefault
public class GTDynamicResourcePack
implements class_3262 {
    protected static final ObjectSet<String> CLIENT_DOMAINS = new ObjectOpenHashSet();
    @ApiStatus.Internal
    public static final ConcurrentMap<class_2960, byte[]> DATA = new ConcurrentHashMap<class_2960, byte[]>();
    private final String name;

    public GTDynamicResourcePack(String name, Collection<String> domains) {
        this.name = name;
        CLIENT_DOMAINS.addAll(domains);
    }

    public static void clearClient() {
        DATA.clear();
    }

    public static void addBlockModel(class_2960 loc, JsonElement obj) {
        class_2960 l = GTDynamicResourcePack.getModelLocation(loc);
        if (ConfigHolder.INSTANCE.dev.dumpAssets) {
            Path parent = Platform.getGamePath().resolve("gtceu/dumped/assets");
            GTDynamicDataPack.writeJson(l, null, parent, obj);
        }
        DATA.put(l, obj.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static void addBlockModel(class_2960 loc, Supplier<JsonElement> obj) {
        GTDynamicResourcePack.addBlockModel(loc, obj.get());
    }

    public static void addItemModel(class_2960 loc, JsonElement obj) {
        class_2960 l = GTDynamicResourcePack.getItemModelLocation(loc);
        if (ConfigHolder.INSTANCE.dev.dumpAssets) {
            Path parent = Platform.getGamePath().resolve("gtceu/dumped/assets");
            GTDynamicDataPack.writeJson(l, null, parent, obj);
        }
        DATA.put(l, obj.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static void addItemModel(class_2960 loc, Supplier<JsonElement> obj) {
        GTDynamicResourcePack.addItemModel(loc, obj.get());
    }

    public static void addBlockState(class_2960 loc, JsonElement stateJson) {
        class_2960 l = GTDynamicResourcePack.getBlockStateLocation(loc);
        if (ConfigHolder.INSTANCE.dev.dumpAssets) {
            Path parent = Platform.getGamePath().resolve("gtceu/dumped/assets");
            GTDynamicDataPack.writeJson(l, null, parent, stateJson);
        }
        DATA.put(l, stateJson.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static void addBlockState(class_2960 loc, Supplier<JsonElement> generator) {
        GTDynamicResourcePack.addBlockState(loc, generator.get());
    }

    public static void addBlockTexture(class_2960 loc, byte[] data) {
        class_2960 l = GTDynamicResourcePack.getTextureLocation("block", loc);
        if (ConfigHolder.INSTANCE.dev.dumpAssets) {
            Path parent = Platform.getGamePath().resolve("gtceu/dumped/assets");
            GTDynamicResourcePack.writeByteArray(l, null, parent, data);
        }
        DATA.put(l, data);
    }

    public static void addItemTexture(class_2960 loc, byte[] data) {
        class_2960 l = GTDynamicResourcePack.getTextureLocation("item", loc);
        if (ConfigHolder.INSTANCE.dev.dumpAssets) {
            Path parent = Platform.getGamePath().resolve("gtceu/dumped/assets");
            GTDynamicResourcePack.writeByteArray(l, null, parent, data);
        }
        DATA.put(l, data);
    }

    @ApiStatus.Internal
    public static void writeByteArray(class_2960 id, @Nullable String subdir, Path parent, byte[] data) {
        try {
            Path file = subdir != null ? parent.resolve(id.method_12836()).resolve(subdir).resolve(id.method_12832() + ".png") : parent.resolve(id.method_12836()).resolve(id.method_12832());
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            try (OutputStream output = Files.newOutputStream(file, new OpenOption[0]);){
                output.write(data);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... elements) {
        return null;
    }

    public class_7367<InputStream> method_14405(class_3264 type, class_2960 location) {
        if (type == class_3264.field_14188 && DATA.containsKey(location)) {
            return () -> new ByteArrayInputStream((byte[])DATA.get(location));
        }
        return null;
    }

    public void method_14408(class_3264 packType, String namespace, String path, class_3262.class_7664 resourceOutput) {
        if (packType == class_3264.field_14188) {
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            String finalPath = path;
            DATA.keySet().stream().filter(Objects::nonNull).filter(loc -> loc.method_12832().startsWith(finalPath)).forEach(id -> {
                class_7367<InputStream> resource = this.method_14405(packType, (class_2960)id);
                if (resource != null) {
                    resourceOutput.accept(id, resource);
                }
            });
        }
    }

    public Set<String> method_14406(class_3264 type) {
        return type == class_3264.field_14188 ? CLIENT_DOMAINS : Set.of();
    }

    @Nullable
    public <T> T method_14407(class_3270<T> metaReader) {
        if (metaReader == class_3272.field_14202) {
            return (T)new class_3272((class_2561)class_2561.method_43470((String)"GTCEu dynamic assets"), class_155.method_16673().method_48017(class_3264.field_14188));
        }
        return null;
    }

    public String method_14409() {
        return this.name;
    }

    public void close() {
    }

    public static class_2960 getBlockStateLocation(class_2960 blockId) {
        return new class_2960(blockId.method_12836(), String.join((CharSequence)"", "blockstates/", blockId.method_12832(), ".json"));
    }

    public static class_2960 getModelLocation(class_2960 blockId) {
        return new class_2960(blockId.method_12836(), String.join((CharSequence)"", "models/", blockId.method_12832(), ".json"));
    }

    public static class_2960 getItemModelLocation(class_2960 itemId) {
        return new class_2960(itemId.method_12836(), String.join((CharSequence)"", "models/item/", itemId.method_12832(), ".json"));
    }

    public static class_2960 getTextureLocation(@Nullable String path, class_2960 tagId) {
        if (path == null) {
            return new class_2960(tagId.method_12836(), String.join((CharSequence)"", "textures/", tagId.method_12832(), ".png"));
        }
        return new class_2960(tagId.method_12836(), String.join((CharSequence)"", "textures/", path, "/", tagId.method_12832(), ".png"));
    }

    static {
        CLIENT_DOMAINS.addAll((Collection)Sets.newHashSet((Object[])new String[]{"gtceu", "minecraft", "forge", "c"}));
    }
}

