/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.loader;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.addon.AddonFinder;
import com.gregtechceu.gtceu.api.addon.IGTAddon;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.NoopVeinGenerator;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTOres;
import com.gregtechceu.gtceu.integration.kjs.GTCEuServerEvents;
import com.gregtechceu.gtceu.integration.kjs.events.GTOreVeinEventJS;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5270;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OreDataLoader
extends class_4309 {
    public static OreDataLoader INSTANCE;
    public static final Gson GSON_INSTANCE;
    private static final String FOLDER = "gtceu/ore_veins";
    protected static final Logger LOGGER;

    public OreDataLoader() {
        super(GSON_INSTANCE, FOLDER);
    }

    protected void apply(Map<class_2960, JsonElement> resourceList, class_3300 resourceManager, class_3695 profiler) {
        GTRegistries.ORE_VEINS.registry().clear();
        GTOres.init();
        AddonFinder.getAddons().forEach(IGTAddon::registerOreVeins);
        if (GTCEu.isKubeJSLoaded()) {
            RunKJSEventInSeparateClassBecauseForgeIsDumb.fireKJSEvent();
        }
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)GTRegistries.builtinRegistry());
        for (Map.Entry<class_2960, JsonElement> entry : resourceList.entrySet()) {
            class_2960 location = entry.getKey();
            try {
                GTOreDefinition ore = OreDataLoader.fromJson(location, class_3518.method_15295((JsonElement)entry.getValue(), (String)"top element"), (class_6903<JsonElement>)ops);
                if (ore == null) {
                    LOGGER.info("Skipping loading ore vein {} as it's serializer returned null", (Object)location);
                    continue;
                }
                if (ore.veinGenerator() instanceof NoopVeinGenerator) {
                    LOGGER.info("Removing ore vein {} as it's generator was marked as no-operation", (Object)location);
                    GTRegistries.ORE_VEINS.remove(location);
                    continue;
                }
                if (GTRegistries.ORE_VEINS.containKey(location)) {
                    GTRegistries.ORE_VEINS.replace(location, ore);
                    continue;
                }
                GTRegistries.ORE_VEINS.register(location, ore);
            }
            catch (JsonParseException | IllegalArgumentException jsonParseException) {
                LOGGER.error("Parsing error loading ore vein {}", (Object)location, (Object)jsonParseException);
            }
        }
        Iterator iterator = GTRegistries.ORE_VEINS.entries().iterator();
        while (iterator.hasNext()) {
            GTOreDefinition gTOreDefinition = (GTOreDefinition)iterator.next().getValue();
            if (gTOreDefinition.veinGenerator() != null) {
                gTOreDefinition.veinGenerator().build();
                continue;
            }
            iterator.remove();
        }
        GTOres.updateLargestVeinSize();
    }

    public static GTOreDefinition fromJson(class_2960 id, JsonObject json, class_6903<JsonElement> ops) {
        return (GTOreDefinition)GTOreDefinition.FULL_CODEC.decode(ops, (Object)json).map(Pair::getFirst).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
    }

    static {
        GSON_INSTANCE = class_5270.method_27861().create();
        LOGGER = LogManager.getLogger();
    }

    public static final class RunKJSEventInSeparateClassBecauseForgeIsDumb {
        public static void fireKJSEvent() {
            GTCEuServerEvents.ORE_VEIN_MODIFICATION.post((ScriptTypeHolder)ScriptType.SERVER, (EventJS)new GTOreVeinEventJS());
        }
    }
}

