/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.fabric;

import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.registry.registrate.CompassNode;
import com.gregtechceu.gtceu.api.registry.registrate.CompassSection;
import com.gregtechceu.gtceu.api.registry.registrate.SoundEntryBuilder;
import com.gregtechceu.gtceu.common.data.GTConfiguredFeatures;
import com.gregtechceu.gtceu.common.data.GTDamageTypes;
import com.gregtechceu.gtceu.common.data.GTPlacements;
import com.gregtechceu.gtceu.common.data.GTWorldgen;
import com.gregtechceu.gtceu.data.fabric.BiomeTagsProviderImpl;
import com.gregtechceu.gtceu.data.fabric.GTRegistriesDatapackGenerator;
import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_2378;
import net.minecraft.class_3264;
import net.minecraft.class_5455;
import net.minecraft.class_5504;
import net.minecraft.class_6736;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import net.minecraft.class_7877;
import net.minecraft.class_7887;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class GregTechDatagen
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator generator) {
        Path rootPath = FabricLoader.getInstance().getGameDir().normalize().getParent().getParent();
        ExistingFileHelper helper = ExistingFileHelper.withResources((Path[])new Path[]{rootPath.resolve("common").resolve("src").resolve("main").resolve("resources"), rootPath.resolve("fabric").resolve("src").resolve("main").resolve("resources")});
        FabricDataGenerator.Pack pack = generator.createPack();
        GTRegistries.REGISTRATE.setupDatagen(pack, helper);
        pack.addProvider(output -> new SoundEntryBuilder.SoundEntryProvider((class_7784)output, "gtceu"));
        pack.addProvider(packOutput -> new CompassSection.CompassSectionProvider((class_7784)packOutput, rl -> helper.exists(rl, class_3264.field_14188)));
        pack.addProvider(packOutput -> new CompassNode.CompassNodeProvider((class_7784)packOutput, rl -> helper.exists(rl, class_3264.field_14188)));
        Set<String> set = Set.of("gtceu");
        class_5455.class_6890 registryAccess = class_5455.method_40302((class_2378)class_7923.field_41167);
        CompletableFuture<class_7225.class_7874> registries = GregTechDatagen.createProvider((class_5455)registryAccess);
        pack.addProvider(output -> new BiomeTagsProviderImpl(output, registries));
        pack.addProvider(output -> new GTRegistriesDatapackGenerator((class_7784)output, registries, new class_7877().method_46777(class_7924.field_42534, GTDamageTypes::bootstrap), set, "DamageType Data"));
        pack.addProvider(output -> new GTRegistriesDatapackGenerator((class_7784)output, registries, new class_7877().method_46777(class_7924.field_41239, GTConfiguredFeatures::bootstrap).method_46777(class_7924.field_41245, GTPlacements::bootstrap).method_46777(class_7924.field_41240, GTWorldgen::bootstrapDensityFunctions), set, "Worldgen Data"));
    }

    private static CompletableFuture<class_7225.class_7874> createProvider(class_5455 registryAccess) {
        CompletableFuture<class_7225.class_7874> vanillaLookup = CompletableFuture.supplyAsync(class_7887::method_46817, class_156.method_18349());
        return vanillaLookup.thenApply(provider -> {
            class_7877 builder = new class_7877().method_46777(class_7924.field_41244, class_6736::method_39216).method_46777(class_7924.field_41236, class_5504::method_40363);
            return builder.method_46781(registryAccess, provider);
        });
    }
}

