/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.fabric;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5475;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7655;
import net.minecraft.class_7784;
import net.minecraft.class_7877;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class GTRegistriesDatapackGenerator
extends class_5475 {
    private final String name;
    private final class_7784 output;
    private final CompletableFuture<class_7225.class_7874> registries;
    private final Predicate<String> namespacePredicate;

    private GTRegistriesDatapackGenerator(String name, class_7784 output, CompletableFuture<class_7225.class_7874> registries, Set<String> modIds) {
        super(output, registries);
        this.name = name;
        this.namespacePredicate = modIds::contains;
        this.registries = registries;
        this.output = output;
    }

    public GTRegistriesDatapackGenerator(class_7784 output, CompletableFuture<class_7225.class_7874> registries, class_7877 builder, Set<String> modIds, String name) {
        this(name, output, (CompletableFuture<class_7225.class_7874>)registries.thenApply(r -> GTRegistriesDatapackGenerator.constructRegistries(r, builder)), modIds);
    }

    private static class_7225.class_7874 constructRegistries(class_7225.class_7874 original, class_7877 datapackEntriesBuilder) {
        HashSet<class_5321> builderKeys = new HashSet<class_5321>(datapackEntriesBuilder.field_40941.stream().map(class_7877.class_7884::comp_1144).toList());
        GTRegistriesDatapackGenerator.getDataPackRegistriesWithDimensions().filter(data -> !builderKeys.contains(data.comp_985())).forEach(data -> datapackEntriesBuilder.method_46777(data.comp_985(), context -> {}));
        return datapackEntriesBuilder.method_46781((class_5455)class_5455.method_40302((class_2378)class_7923.field_41167), original);
    }

    public CompletableFuture<?> method_10319(class_7403 output) {
        return this.registries.thenCompose(provider -> {
            class_6903 dynamicops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)provider);
            return CompletableFuture.allOf((CompletableFuture[])GTRegistriesDatapackGenerator.getDataPackRegistriesWithDimensions().flatMap(arg_0 -> this.lambda$run$4(output, provider, (DynamicOps)dynamicops, arg_0)).toArray(CompletableFuture[]::new));
        });
    }

    private <T> Optional<CompletableFuture<?>> dumpRegistryCap(class_7403 p_256502_, class_7225.class_7874 p_256492_, DynamicOps<JsonElement> p_256000_, class_7655.class_7657<T> p_256449_) {
        class_5321 resourcekey = p_256449_.comp_985();
        return p_256492_.method_46759(resourcekey).map(registryLookup -> {
            class_7784.class_7489 packoutput$pathprovider = this.output.method_45973(class_7784.class_7490.field_39367, GTRegistriesDatapackGenerator.prefixNamespace(resourcekey.method_29177()));
            return CompletableFuture.allOf((CompletableFuture[])registryLookup.method_42017().filter(holder -> this.namespacePredicate.test(holder.method_40237().method_29177().method_12836())).map(p_256105_ -> GTRegistriesDatapackGenerator.method_39680((Path)packoutput$pathprovider.method_44107(p_256105_.method_40237().method_29177()), (class_7403)p_256502_, (DynamicOps)p_256000_, (Encoder)p_256449_.comp_986(), (Object)p_256105_.comp_349())).toArray(CompletableFuture[]::new));
        });
    }

    public static Stream<class_7655.class_7657<?>> getDataPackRegistriesWithDimensions() {
        return Stream.concat(class_7655.field_39968.stream(), class_7655.field_39969.stream());
    }

    public static String prefixNamespace(class_2960 registryKey) {
        return registryKey.method_12836().equals("minecraft") ? registryKey.method_12832() : registryKey.method_12836() + "/" + registryKey.method_12832();
    }

    @NotNull
    public String method_10321() {
        return this.name;
    }

    private /* synthetic */ Stream lambda$run$4(class_7403 output, class_7225.class_7874 provider, DynamicOps dynamicops, class_7655.class_7657 registryData) {
        return this.dumpRegistryCap(output, provider, (DynamicOps<JsonElement>)dynamicops, registryData).stream();
    }
}

