/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.core.fabric;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;

public class RecipeHelpers {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static class_1792 getItem(String itemName, boolean disallowsAirInRecipe) {
        class_1792 item = RecipeHelpers.tryGetItem(itemName, disallowsAirInRecipe);
        if (item == null) {
            if (!class_7923.field_41178.method_10250(new class_2960(itemName))) {
                throw new JsonSyntaxException("Unknown item '" + itemName + "'");
            }
            if (disallowsAirInRecipe && (item == class_1802.field_8162 || item == null)) {
                throw new JsonSyntaxException("Invalid item: " + itemName);
            }
        }
        return Objects.requireNonNull(item);
    }

    @Nullable
    public static class_1792 tryGetItem(String itemName, boolean disallowsAirInRecipe) {
        class_2960 itemKey = new class_2960(itemName);
        if (!class_7923.field_41178.method_10250(itemKey)) {
            return null;
        }
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemKey);
        if (disallowsAirInRecipe && item == class_1802.field_8162) {
            return null;
        }
        return item;
    }

    public static class_2487 getNBT(JsonElement element) {
        try {
            if (element.isJsonObject()) {
                return class_2522.method_10718((String)GSON.toJson(element));
            }
            return class_2522.method_10718((String)class_3518.method_15287((JsonElement)element, (String)"nbt"));
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException("Invalid NBT Entry: " + e);
        }
    }

    public static class_1799 getItemStack(JsonObject json, boolean readNBT, boolean disallowsAirInRecipe) {
        String itemName = class_3518.method_15265((JsonObject)json, (String)"item");
        class_1792 item = RecipeHelpers.getItem(itemName, disallowsAirInRecipe);
        if (readNBT && json.has("nbt")) {
            class_2487 nbt = RecipeHelpers.getNBT(json.get("nbt"));
            class_2487 tmp = new class_2487();
            tmp.method_10566("tag", (class_2520)nbt);
            tmp.method_10582("id", itemName);
            tmp.method_10569("Count", class_3518.method_15282((JsonObject)json, (String)"count", (int)1));
            return class_1799.method_7915((class_2487)tmp);
        }
        return new class_1799((class_1935)item, class_3518.method_15282((JsonObject)json, (String)"count", (int)1));
    }
}

