/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.item;

import com.gregtechceu.gtceu.api.data.chemical.material.properties.ItemPipeProperties;
import com.gregtechceu.gtceu.common.pipelike.item.ItemNetWalker;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeData;
import com.gregtechceu.gtceu.utils.FacingPos;
import com.lowdragmc.lowdraglib.pipelike.LevelPipeNet;
import com.lowdragmc.lowdraglib.pipelike.Node;
import com.lowdragmc.lowdraglib.pipelike.PipeNet;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;

public class ItemPipeNet
extends PipeNet<ItemPipeData> {
    private final Map<class_2338, List<Inventory>> NET_DATA = new HashMap<class_2338, List<Inventory>>();

    public ItemPipeNet(LevelPipeNet<ItemPipeData, ? extends PipeNet<ItemPipeData>> world) {
        super(world);
    }

    public List<Inventory> getNetData(class_2338 pipePos) {
        List<Inventory> data = this.NET_DATA.get(pipePos);
        if (data == null) {
            data = ItemNetWalker.createNetData(this, pipePos);
            if (data == null) {
                return Collections.emptyList();
            }
            data.sort(Comparator.comparingInt(inv -> inv.properties.getPriority()));
            this.NET_DATA.put(pipePos, data);
        }
        return data;
    }

    public void onNeighbourUpdate(class_2338 fromPos) {
        this.NET_DATA.clear();
    }

    public void onPipeConnectionsUpdate() {
        this.NET_DATA.clear();
    }

    protected void transferNodeData(Map<class_2338, Node<ItemPipeData>> transferredNodes, PipeNet<ItemPipeData> parentNet) {
        super.transferNodeData(transferredNodes, parentNet);
        this.NET_DATA.clear();
        ((ItemPipeNet)parentNet).NET_DATA.clear();
    }

    protected void writeNodeData(ItemPipeData nodeData, class_2487 tagCompound) {
        tagCompound.method_10569("Resistance", nodeData.properties.getPriority());
        tagCompound.method_10548("Rate", nodeData.properties.getTransferRate());
        tagCompound.method_10567("Connections", nodeData.connections);
    }

    protected ItemPipeData readNodeData(class_2487 tagCompound) {
        return new ItemPipeData(new ItemPipeProperties(tagCompound.method_10550("Range"), tagCompound.method_10583("Rate")), tagCompound.method_10571("Connections"));
    }

    public static class Inventory {
        private final class_2338 pipePos;
        private final class_2350 faceToHandler;
        private final int distance;
        private final ItemPipeProperties properties;
        private final List<Predicate<class_1799>> filters;

        public Inventory(class_2338 pipePos, class_2350 facing, int distance, ItemPipeProperties properties, List<Predicate<class_1799>> filters) {
            this.pipePos = pipePos;
            this.faceToHandler = facing;
            this.distance = distance;
            this.properties = properties;
            this.filters = filters;
        }

        public boolean matchesFilters(class_1799 stack) {
            for (Predicate<class_1799> filter : this.filters) {
                if (filter.test(stack)) continue;
                return false;
            }
            return true;
        }

        public class_2338 getHandlerPos() {
            return this.pipePos.method_10093(this.faceToHandler);
        }

        public IItemTransfer getHandler(class_1937 world) {
            class_2586 tile = world.method_8321(this.getHandlerPos());
            if (tile != null) {
                return ItemTransferHelper.getItemTransfer((class_1937)world, (class_2338)this.getHandlerPos(), (class_2350)this.faceToHandler.method_10153());
            }
            return null;
        }

        public FacingPos toFacingPos() {
            return new FacingPos(this.getPipePos(), this.faceToHandler);
        }

        public class_2338 getPipePos() {
            return this.pipePos;
        }

        public class_2350 getFaceToHandler() {
            return this.faceToHandler;
        }

        public int getDistance() {
            return this.distance;
        }

        public ItemPipeProperties getProperties() {
            return this.properties;
        }

        public List<Predicate<class_1799>> getFilters() {
            return this.filters;
        }
    }
}

