/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.item;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ItemPipeProperties;
import com.gregtechceu.gtceu.common.blockentity.ItemPipeBlockEntity;
import com.gregtechceu.gtceu.common.cover.ItemFilterCover;
import com.gregtechceu.gtceu.common.cover.data.ItemFilterMode;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeData;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeNet;
import com.lowdragmc.lowdraglib.pipelike.Node;
import com.lowdragmc.lowdraglib.pipelike.PipeNet;
import com.lowdragmc.lowdraglib.pipelike.PipeNetWalker;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;

public class ItemNetWalker
extends PipeNetWalker<ItemPipeData, ItemPipeNet> {
    private ItemPipeProperties minProperties;
    private final List<ItemPipeNet.Inventory> inventories;
    private final List<Predicate<class_1799>> filters = new ArrayList<Predicate<class_1799>>();
    private final List<Predicate<class_1799>> nextFilters = new ArrayList<Predicate<class_1799>>();
    private class_2338 sourcePipe;
    private class_2350 facingToHandler;

    public static List<ItemPipeNet.Inventory> createNetData(ItemPipeNet pipeNet, class_2338 sourcePipe) {
        try {
            ItemNetWalker walker = new ItemNetWalker(pipeNet, sourcePipe, 1, new ArrayList<ItemPipeNet.Inventory>(), null);
            walker.traversePipeNet();
            return walker.inventories;
        }
        catch (Exception e) {
            GTCEu.LOGGER.error("error while create net data for ItemPipeNet", (Throwable)e);
            return null;
        }
    }

    protected ItemNetWalker(ItemPipeNet world, class_2338 sourcePipe, int distance, List<ItemPipeNet.Inventory> inventories, ItemPipeProperties properties) {
        super((PipeNet)world, sourcePipe, distance);
        this.inventories = inventories;
        this.minProperties = properties;
    }

    protected PipeNetWalker<ItemPipeData, ItemPipeNet> createSubWalker(ItemPipeNet world, class_2338 nextPos, int walkedBlocks) {
        ItemNetWalker walker = new ItemNetWalker(world, nextPos, walkedBlocks, this.inventories, this.minProperties);
        walker.facingToHandler = this.facingToHandler;
        walker.sourcePipe = this.sourcePipe;
        walker.filters.addAll(this.filters);
        List<Predicate<class_1799>> moreFilters = this.nextFilters;
        if (moreFilters != null && !moreFilters.isEmpty()) {
            walker.filters.addAll(moreFilters);
        }
        return walker;
    }

    protected boolean checkPipe(Node<ItemPipeData> pipeNode, class_2338 pos) {
        if (!this.nextFilters.isEmpty()) {
            this.filters.addAll(this.nextFilters);
        }
        this.nextFilters.clear();
        ItemPipeProperties pipeProperties = ((ItemPipeData)pipeNode.data).properties;
        this.minProperties = this.minProperties == null ? pipeProperties : new ItemPipeProperties(this.minProperties.getPriority() + pipeProperties.getPriority(), Math.min(this.minProperties.getTransferRate(), pipeProperties.getTransferRate()));
        return true;
    }

    protected void checkNeighbour(Node<ItemPipeData> pipeNode, class_2338 pipePos, class_2350 faceToNeighbour) {
        if (pipeNode == null || pipePos.equals((Object)this.sourcePipe) && faceToNeighbour == this.facingToHandler) {
            return;
        }
        if (this.getLevel().method_8321(pipePos.method_10093(faceToNeighbour)) instanceof ItemPipeBlockEntity && !this.isValidPipe(pipePos, faceToNeighbour)) {
            return;
        }
        IItemTransfer handler = ItemTransferHelper.getItemTransfer((class_1937)this.getLevel(), (class_2338)pipePos, (class_2350)faceToNeighbour.method_10153());
        if (handler != null) {
            ArrayList<Predicate<class_1799>> filters = new ArrayList<Predicate<class_1799>>(this.filters);
            List<Predicate<class_1799>> moreFilters = this.nextFilters;
            if (moreFilters != null && !moreFilters.isEmpty()) {
                filters.addAll(moreFilters);
            }
            this.inventories.add(new ItemPipeNet.Inventory(new class_2338((class_2382)pipePos), faceToNeighbour, this.getWalkedBlocks(), this.minProperties, filters));
        }
    }

    protected boolean isValidPipe(class_2338 pipePos, class_2350 faceToNeighbour) {
        ItemFilterCover filterCover;
        ItemPipeBlockEntity neighbourPipeBE;
        class_2586 currentPipe;
        block7: {
            block6: {
                currentPipe = this.getLevel().method_8321(pipePos);
                class_2586 class_25862 = this.getLevel().method_8321(pipePos.method_10093(faceToNeighbour));
                if (!(class_25862 instanceof ItemPipeBlockEntity)) break block6;
                neighbourPipeBE = (ItemPipeBlockEntity)class_25862;
                if (currentPipe instanceof ItemPipeBlockEntity) break block7;
            }
            return false;
        }
        ItemPipeBlockEntity currentPipeBE = (ItemPipeBlockEntity)currentPipe;
        CoverBehavior thisCover = currentPipeBE.getCoverContainer().getCoverAtSide(faceToNeighbour);
        CoverBehavior neighbourCover = neighbourPipeBE.getCoverContainer().getCoverAtSide(faceToNeighbour.method_10153());
        ArrayList<Predicate<class_1799>> filters = new ArrayList<Predicate<class_1799>>();
        if (thisCover instanceof ItemFilterCover && (filterCover = (ItemFilterCover)thisCover).getFilterMode() != ItemFilterMode.FILTER_INSERT) {
            filters.add(filterCover.getItemFilter()::test);
        }
        if (neighbourCover instanceof ItemFilterCover && (filterCover = (ItemFilterCover)neighbourCover).getFilterMode() != ItemFilterMode.FILTER_EXTRACT) {
            filters.add(filterCover.getItemFilter()::test);
        }
        if (!filters.isEmpty()) {
            this.nextFilters.addAll(filters);
        }
        return true;
    }
}

