/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.item;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.misc.RateCounter;
import com.gregtechceu.gtceu.api.pipenet.PipeCoverContainer;
import com.gregtechceu.gtceu.common.blockentity.ItemPipeBlockEntity;
import com.gregtechceu.gtceu.common.cover.ConveyorCover;
import com.gregtechceu.gtceu.common.cover.ItemFilterCover;
import com.gregtechceu.gtceu.common.cover.RobotArmCover;
import com.gregtechceu.gtceu.common.cover.data.DistributionMode;
import com.gregtechceu.gtceu.common.cover.data.ItemFilterMode;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeNet;
import com.gregtechceu.gtceu.utils.FacingPos;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.gregtechceu.gtceu.utils.ItemStackHashStrategy;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;

public class ItemNetHandler
implements IItemTransfer {
    private ItemPipeNet net;
    private ItemPipeBlockEntity pipe;
    private final class_1937 world;
    private final class_2350 facing;
    private final Map<FacingPos, Integer> simulatedTransfersGlobalRoundRobin = new HashMap<FacingPos, Integer>();
    private final RateCounter simulatedCounter = new RateCounter(this::getLevelTime, 20);
    private final RateCounter transferredCounter = new RateCounter(this::getLevelTime, 20);
    private final ItemStackTransfer testHandler = new ItemStackTransfer(1);

    public ItemNetHandler(ItemPipeNet net, ItemPipeBlockEntity pipe, class_2350 facing) {
        this.net = net;
        this.pipe = pipe;
        this.facing = facing;
        this.world = pipe.getPipeLevel();
    }

    private long getLevelTime() {
        return this.net.getLevel().method_8510();
    }

    public void updateNetwork(ItemPipeNet net) {
        this.net = net;
    }

    private void copyTransferred() {
        this.simulatedCounter.clear();
        this.simulatedCounter.addUsed(this.transferredCounter.getUsedSum());
        this.simulatedTransfersGlobalRoundRobin.clear();
        this.simulatedTransfersGlobalRoundRobin.putAll(this.pipe.getTransferred());
    }

    @Nonnull
    public class_1799 insertItem(int slot, @Nonnull class_1799 stack, boolean simulate, boolean notifyChanges) {
        if (stack.method_7960()) {
            return stack;
        }
        if (this.net == null || this.pipe == null || this.pipe.isInValid() || this.pipe.isBlocked(this.facing)) {
            return stack;
        }
        this.copyTransferred();
        CoverBehavior pipeCover = this.getCoverOnPipe(this.pipe.getPipePos(), this.facing);
        CoverBehavior tileCover = this.getCoverOnNeighbour(this.pipe.getPipePos(), this.facing);
        boolean pipeConveyor = pipeCover instanceof ConveyorCover;
        boolean tileConveyor = tileCover instanceof ConveyorCover;
        if (pipeConveyor && tileConveyor) {
            return stack;
        }
        if (tileCover != null && !ItemNetHandler.checkImportCover(tileCover, false, stack)) {
            return stack;
        }
        if (!pipeConveyor && !tileConveyor) {
            return this.insertFirst(stack, simulate);
        }
        ConveyorCover conveyor = (ConveyorCover)(pipeConveyor ? pipeCover : tileCover);
        if (conveyor.getIo() == (pipeConveyor ? IO.IN : IO.OUT)) {
            boolean roundRobinGlobal;
            boolean bl = roundRobinGlobal = conveyor.getDistributionMode() == DistributionMode.ROUND_ROBIN_GLOBAL;
            if (roundRobinGlobal || conveyor.getDistributionMode() == DistributionMode.ROUND_ROBIN_PRIO) {
                return this.insertRoundRobin(stack, simulate, roundRobinGlobal);
            }
        }
        return this.insertFirst(stack, simulate);
    }

    public static boolean checkImportCover(CoverBehavior cover, boolean onPipe, class_1799 stack) {
        if (cover == null) {
            return true;
        }
        if (cover instanceof ItemFilterCover) {
            ItemFilterCover filter = (ItemFilterCover)cover;
            return filter.getFilterMode() != ItemFilterMode.FILTER_BOTH && (filter.getFilterMode() != ItemFilterMode.FILTER_INSERT || !onPipe) && (filter.getFilterMode() != ItemFilterMode.FILTER_EXTRACT || onPipe) || filter.getItemFilter().test(stack);
        }
        return true;
    }

    public class_1799 insertFirst(class_1799 stack, boolean simulate) {
        for (ItemPipeNet.Inventory inv : this.net.getNetData(this.pipe.getPipePos())) {
            stack = this.insert(inv, stack, simulate);
            if (!stack.method_7960()) continue;
            return class_1799.field_8037;
        }
        return stack;
    }

    public class_1799 insertRoundRobin(class_1799 stack, boolean simulate, boolean global) {
        List<ItemPipeNet.Inventory> handlers = this.net.getNetData(this.pipe.getPipePos());
        if (handlers.size() == 0) {
            return stack;
        }
        if (handlers.size() == 1) {
            return this.insert(handlers.get(0), stack, simulate);
        }
        ArrayList<ItemPipeNet.Inventory> handlersCopy = new ArrayList<ItemPipeNet.Inventory>(handlers);
        int original = stack.method_7947();
        if (global) {
            stack = this.insertToHandlersEnhanced(handlersCopy, stack, handlers.size(), simulate);
        } else if (!(stack = this.insertToHandlers(handlersCopy, stack, simulate)).method_7960() && handlersCopy.size() > 0) {
            stack = this.insertToHandlers(handlersCopy, stack, simulate);
        }
        return stack;
    }

    private class_1799 insertToHandlers(List<ItemPipeNet.Inventory> copy, class_1799 stack, boolean simulate) {
        int m;
        ListIterator<ItemPipeNet.Inventory> handlerIterator = copy.listIterator();
        int inserted = 0;
        int count = stack.method_7947();
        int c = count / copy.size();
        int n = m = c == 0 ? count % copy.size() : 0;
        while (handlerIterator.hasNext()) {
            ItemPipeNet.Inventory handler = (ItemPipeNet.Inventory)handlerIterator.next();
            int amount = c;
            if (m > 0) {
                ++amount;
                --m;
            }
            if ((amount = Math.min(amount, stack.method_7947() - inserted)) == 0) break;
            class_1799 toInsert = stack.method_7972();
            toInsert.method_7939(amount);
            int r = this.insert(handler, toInsert, simulate).method_7947();
            if (r < amount) {
                inserted += amount - r;
            }
            if (r == 1 && c == 0 && amount == 1) {
                ++m;
            }
            if (r <= 0) continue;
            handlerIterator.remove();
        }
        class_1799 remainder = stack.method_7972();
        remainder.method_7939(count - inserted);
        return remainder;
    }

    private class_1799 insertToHandlersEnhanced(List<ItemPipeNet.Inventory> copy, class_1799 stack, int dest, boolean simulate) {
        int nextStep;
        LinkedList<EnhancedRoundRobinData> transferred = new LinkedList<EnhancedRoundRobinData>();
        LinkedList<Integer> steps = new LinkedList<Integer>();
        int min = Integer.MAX_VALUE;
        for (ItemPipeNet.Inventory inv : copy) {
            class_1799 simStack = stack.method_7972();
            int ins = stack.method_7947() - this.insert(inv, simStack, true, true).method_7947();
            if (ins <= 0) continue;
            int didTransfer = this.didTransferTo(inv, simulate);
            EnhancedRoundRobinData data2 = new EnhancedRoundRobinData(inv, ins, didTransfer);
            transferred.addLast(data2);
            min = Math.min(min, didTransfer);
            if (steps.contains(didTransfer)) continue;
            steps.add(didTransfer);
        }
        if (transferred.isEmpty() || steps.isEmpty()) {
            return stack;
        }
        if (!simulate && min < Integer.MAX_VALUE) {
            this.decrementBy(min);
        }
        transferred.sort(Comparator.comparingInt(data -> data.transferred));
        steps.sort(Integer::compare);
        if (((EnhancedRoundRobinData)transferred.get((int)0)).transferred != (Integer)steps.get(0)) {
            return stack;
        }
        int amount = stack.method_7947();
        int c = amount / transferred.size();
        int m = amount % transferred.size();
        ArrayList transferredCopy = new ArrayList(transferred);
        int n = nextStep = steps.isEmpty() ? -1 : (Integer)steps.pollFirst();
        block1: while (amount > 0 && !transferredCopy.isEmpty()) {
            Iterator iterator = transferredCopy.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                EnhancedRoundRobinData enhancedRoundRobinData = (EnhancedRoundRobinData)iterator.next();
                if (nextStep >= 0 && enhancedRoundRobinData.transferred >= nextStep) break;
                int toInsert = nextStep <= 0 ? (amount <= m ? 1 : Math.min(c, amount)) : Math.min(amount, nextStep - enhancedRoundRobinData.transferred);
                if (enhancedRoundRobinData.toTransfer + toInsert >= enhancedRoundRobinData.maxInsertable) {
                    enhancedRoundRobinData.toTransfer = enhancedRoundRobinData.maxInsertable;
                    iterator.remove();
                } else {
                    enhancedRoundRobinData.toTransfer += toInsert;
                }
                enhancedRoundRobinData.transferred += toInsert;
                if ((amount -= toInsert) == 0) break block1;
                ++i;
            }
            for (EnhancedRoundRobinData data4 : transferredCopy) {
                if (data4.transferred >= nextStep) continue;
                continue block1;
            }
            if (steps.isEmpty()) {
                if (nextStep < 0) continue;
                c = amount / transferredCopy.size();
                m = amount % transferredCopy.size();
                nextStep = -1;
                continue;
            }
            nextStep = (Integer)steps.pollFirst();
        }
        int inserted = 0;
        for (EnhancedRoundRobinData enhancedRoundRobinData : transferred) {
            class_1799 toInsert = stack.method_7972();
            toInsert.method_7939(enhancedRoundRobinData.toTransfer);
            int ins = enhancedRoundRobinData.toTransfer - this.insert(enhancedRoundRobinData.inventory, toInsert, simulate).method_7947();
            inserted += ins;
            this.transferTo(enhancedRoundRobinData.inventory, simulate, ins);
        }
        class_1799 remainder = stack.method_7972();
        remainder.method_7934(inserted);
        return remainder;
    }

    public class_1799 insert(ItemPipeNet.Inventory handler, class_1799 stack, boolean simulate) {
        return this.insert(handler, stack, simulate, false);
    }

    public class_1799 insert(ItemPipeNet.Inventory handler, class_1799 stack, boolean simulate, boolean ignoreLimit) {
        int allowed;
        int n = allowed = ignoreLimit ? stack.method_7947() : this.checkTransferable(handler.getProperties().getTransferRate(), stack.method_7947(), simulate);
        if (allowed == 0 || !handler.matchesFilters(stack)) {
            return stack;
        }
        CoverBehavior pipeCover = this.getCoverOnPipe(handler.getPipePos(), handler.getFaceToHandler());
        CoverBehavior tileCover = this.getCoverOnNeighbour(handler.getPipePos(), handler.getFaceToHandler());
        if (pipeCover != null) {
            this.testHandler.setStackInSlot(0, stack.method_7972());
            this.testHandler.setStackInSlot(0, class_1799.field_8037);
            return stack;
        }
        IItemTransfer neighbourHandler = handler.getHandler(this.world);
        if (pipeCover instanceof RobotArmCover && ((RobotArmCover)pipeCover).getIo() == IO.OUT) {
            return this.insertOverRobotArm(neighbourHandler, (RobotArmCover)pipeCover, stack, simulate, allowed, ignoreLimit);
        }
        if (tileCover instanceof RobotArmCover && ((RobotArmCover)tileCover).getIo() == IO.IN) {
            return this.insertOverRobotArm(neighbourHandler, (RobotArmCover)tileCover, stack, simulate, allowed, ignoreLimit);
        }
        return this.insert(neighbourHandler, stack, simulate, allowed, ignoreLimit);
    }

    private class_1799 insert(IItemTransfer handler, class_1799 stack, boolean simulate, int allowed, boolean ignoreLimit) {
        if (stack.method_7947() == allowed) {
            class_1799 re = GTTransferUtils.insertItem(handler, stack, simulate);
            if (!ignoreLimit) {
                this.transfer(simulate, stack.method_7947() - re.method_7947());
            }
            return re;
        }
        class_1799 toInsert = stack.method_7972();
        toInsert.method_7939(Math.min(allowed, stack.method_7947()));
        int r = GTTransferUtils.insertItem(handler, toInsert, simulate).method_7947();
        if (!ignoreLimit) {
            this.transfer(simulate, toInsert.method_7947() - r);
        }
        class_1799 remainder = stack.method_7972();
        remainder.method_7939(r + (stack.method_7947() - toInsert.method_7947()));
        return remainder;
    }

    public CoverBehavior getCoverOnPipe(class_2338 pos, class_2350 handlerFacing) {
        class_2586 tile = this.pipe.method_10997().method_8321(pos);
        if (tile instanceof ItemPipeBlockEntity) {
            ItemPipeBlockEntity blockEntity = (ItemPipeBlockEntity)tile;
            PipeCoverContainer coverable = blockEntity.getCoverContainer();
            return coverable.getCoverAtSide(handlerFacing);
        }
        return null;
    }

    public CoverBehavior getCoverOnNeighbour(class_2338 pos, class_2350 handlerFacing) {
        class_2586 tile = this.pipe.method_10997().method_8321(pos.method_10093(handlerFacing));
        if (tile != null) {
            ICoverable coverable = GTCapabilityHelper.getCoverable(this.pipe.method_10997(), pos.method_10093(handlerFacing), handlerFacing.method_10153());
            if (coverable == null) {
                return null;
            }
            return coverable.getCoverAtSide(handlerFacing.method_10153());
        }
        return null;
    }

    public class_1799 insertOverRobotArm(IItemTransfer handler, RobotArmCover arm, class_1799 stack, boolean simulate, int allowed, boolean ignoreLimit) {
        boolean isStackSpecific = false;
        int rate = arm.getFilterHandler().getFilter().testItemCount(stack);
        switch (arm.getTransferMode()) {
            case TRANSFER_ANY: {
                return this.insert(handler, stack, simulate, allowed, ignoreLimit);
            }
            case KEEP_EXACT: {
                int count = rate - ItemNetHandler.countStack(handler, stack, arm, isStackSpecific);
                if (count <= 0) {
                    return stack;
                }
                count = Math.min(allowed, Math.min(stack.method_7947(), count));
                return this.insert(handler, stack, simulate, count, ignoreLimit);
            }
            case TRANSFER_EXACT: {
                int count = Math.min(allowed, Math.min(rate, stack.method_7947()));
                if (this.insert(handler, stack, true, count, ignoreLimit).method_7947() != stack.method_7947() - count) {
                    return stack;
                }
                return this.insert(handler, stack, simulate, count, ignoreLimit);
            }
        }
        return stack;
    }

    public static int countStack(IItemTransfer handler, class_1799 stack, RobotArmCover arm, boolean isStackSpecific) {
        if (arm == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            class_1799 slot = handler.getStackInSlot(i);
            if (slot.method_7960() || !(isStackSpecific ? ItemStackHashStrategy.comparingAllButCount().equals(stack, slot) : arm.getFilterHandler().getFilter().test(slot))) continue;
            count += slot.method_7947();
        }
        return count;
    }

    private int checkTransferable(float rate, int amount, boolean simulate) {
        int max = (int)((double)(rate * 64.0f) + 0.5);
        RateCounter rateCounter = simulate ? this.simulatedCounter : this.transferredCounter;
        return Math.max(0, Math.min(max - (int)rateCounter.getUsedSum(), amount));
    }

    private void transfer(boolean simulate, int amount) {
        RateCounter rateCounter = simulate ? this.simulatedCounter : this.transferredCounter;
        rateCounter.addUsed(amount);
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public class_1799 getStackInSlot(int i) {
        return class_1799.field_8037;
    }

    @Nonnull
    public class_1799 extractItem(int slot, int amount, boolean simulate, boolean notifyChanges) {
        return class_1799.field_8037;
    }

    public int getSlotLimit(int i) {
        return 64;
    }

    public boolean isItemValid(int slot, @NotNull class_1799 stack) {
        return true;
    }

    @NotNull
    public Object createSnapshot() {
        return new Object();
    }

    public void restoreFromSnapshot(Object snapshot) {
    }

    private void transferTo(ItemPipeNet.Inventory handler, boolean simulate, int amount) {
        if (simulate) {
            this.simulatedTransfersGlobalRoundRobin.merge(handler.toFacingPos(), amount, Integer::sum);
        } else {
            this.pipe.getTransferred().merge(handler.toFacingPos(), amount, Integer::sum);
        }
    }

    private boolean contains(ItemPipeNet.Inventory handler, boolean simulate) {
        return simulate ? this.simulatedTransfersGlobalRoundRobin.containsKey(handler.toFacingPos()) : this.pipe.getTransferred().containsKey(handler.toFacingPos());
    }

    private int didTransferTo(ItemPipeNet.Inventory handler, boolean simulate) {
        if (simulate) {
            return this.simulatedTransfersGlobalRoundRobin.getOrDefault(handler.toFacingPos(), 0);
        }
        return this.pipe.getTransferred().getOrDefault(handler.toFacingPos(), 0);
    }

    private void resetTransferred(boolean simulated) {
        if (simulated) {
            this.simulatedTransfersGlobalRoundRobin.clear();
        } else {
            this.pipe.resetTransferred();
        }
    }

    private void decrementBy(int amount) {
        for (Map.Entry<FacingPos, Integer> entry : this.pipe.getTransferred().entrySet()) {
            entry.setValue(entry.getValue() - amount);
        }
    }

    public ItemPipeNet getNet() {
        return this.net;
    }

    private static class EnhancedRoundRobinData {
        private final ItemPipeNet.Inventory inventory;
        private final int maxInsertable;
        private int transferred;
        private int toTransfer = 0;

        private EnhancedRoundRobinData(ItemPipeNet.Inventory inventory, int maxInsertable, int transferred) {
            this.maxInsertable = maxInsertable;
            this.transferred = transferred;
            this.inventory = inventory;
        }
    }
}

