/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.trait.miner;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.common.machine.trait.miner.MinerLogic;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_47;
import net.minecraft.class_8567;
import net.minecraft.class_94;

public class LargeMinerLogic
extends MinerLogic {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(LargeMinerLogic.class, MinerLogic.MANAGED_FIELD_HOLDER);
    private static final int CHUNK_LENGTH = 16;
    private int voltageTier;
    private int overclockAmount = 0;
    @Persisted
    private boolean isChunkMode;
    @Persisted
    private boolean isSilkTouchMode;

    public LargeMinerLogic(IRecipeLogicMachine machine, int fortune, int speed, int maximumRadius) {
        super(machine, fortune, speed, maximumRadius);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void initPos(@Nonnull class_2338 pos, int currentRadius) {
        if (!this.isChunkMode) {
            super.initPos(pos, currentRadius);
        } else {
            class_3218 world = (class_3218)this.getMachine().getLevel();
            class_2791 origin = world.method_22350(pos);
            class_1923 startPos = world.method_8497(origin.method_12004().field_9181 - currentRadius / 16, origin.method_12004().field_9180 - currentRadius / 16).method_12004();
            this.x = startPos.method_8326();
            this.y = pos.method_10264() - 1;
            this.z = startPos.method_8328();
            this.startX = startPos.method_8326();
            this.startY = pos.method_10264();
            this.startZ = startPos.method_8328();
            this.mineX = startPos.method_8326();
            this.mineY = pos.method_10264() - 1;
            this.mineZ = startPos.method_8328();
            this.pipeY = pos.method_10264() - 1;
        }
    }

    private int getDropCountMultiplier() {
        return 3;
    }

    public void setChunkMode(boolean isChunkMode) {
        if (!this.isWorking()) {
            this.isChunkMode = isChunkMode;
            if (!this.getMachine().isRemote()) {
                this.resetArea();
            }
        }
    }

    public void setSilkTouchMode(boolean isSilkTouchMode) {
        if (!this.isWorking()) {
            this.isSilkTouchMode = isSilkTouchMode;
        }
    }

    @Override
    public class_2338 getMiningPos() {
        return this.getMachine().getPos().method_10093(this.getMachine().getFrontFacing().method_10153());
    }

    @Override
    protected boolean hasPostProcessing() {
        return !this.isSilkTouchMode;
    }

    @Override
    protected void dropPostProcessing(class_2371<class_1799> blockDrops, List<class_1799> outputs, class_2680 blockState, class_8567.class_8568 builder) {
        for (class_1799 outputStack : outputs) {
            if (ChemicalHelper.getPrefix((class_1935)outputStack.method_7909()) == TagPrefix.crushed && this.getDropCountMultiplier() > 0) {
                class_1799 fortunePick = this.pickaxeTool.method_7972();
                fortunePick.method_7978(class_1893.field_9130, this.getDropCountMultiplier());
                outputStack = (class_1799)class_94.method_456((class_1887)class_1893.field_9130).method_515().apply((Object)outputStack, (Object)new class_47.class_48(builder.method_51874(class_181.field_1229, (Object)fortunePick).method_51875(class_173.field_1172)).method_309(null));
            }
            blockDrops.add((Object)outputStack);
        }
    }

    @Override
    protected boolean doPostProcessing(class_2371<class_1799> blockDrops, class_2680 blockState, class_8567.class_8568 builder) {
        if (!super.doPostProcessing(blockDrops, blockState, builder) && this.getDropCountMultiplier() > 0) {
            for (class_1799 drop : blockDrops) {
                drop.method_7939(drop.method_7947() * this.getDropCountMultiplier());
            }
        }
        return true;
    }

    public void setVoltageTier(int voltageTier) {
        this.voltageTier = voltageTier;
    }

    @Override
    public int getVoltageTier() {
        return this.voltageTier;
    }

    public int getOverclockAmount() {
        return this.overclockAmount;
    }

    public void setOverclockAmount(int overclockAmount) {
        this.overclockAmount = overclockAmount;
    }

    public boolean isChunkMode() {
        return this.isChunkMode;
    }

    @Override
    public boolean isSilkTouchMode() {
        return this.isSilkTouchMode;
    }
}

