/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.trait;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IPlatformEnergyStorage;
import com.gregtechceu.gtceu.api.capability.PlatformEnergyCompat;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.api.syncdata.RequireRerender;
import com.gregtechceu.gtceu.common.machine.electric.ConverterMachine;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import net.minecraft.class_2350;

public class ConverterTrait
extends NotifiableEnergyContainer
implements IPlatformEnergyStorage {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ConverterTrait.class, NotifiableEnergyContainer.MANAGED_FIELD_HOLDER);
    @Persisted
    @DescSynced
    @RequireRerender
    private boolean feToEu;
    private final int amps;
    private final long voltage;

    public ConverterTrait(ConverterMachine machine, int amps) {
        super(machine, GTValues.V[machine.getTier()] * 16L * (long)amps, GTValues.V[machine.getTier()], amps, GTValues.V[machine.getTier()], amps);
        this.amps = amps;
        this.voltage = GTValues.V[machine.getTier()];
        this.setSideInputCondition(side -> !this.feToEu && side != this.getMachine().getFrontFacing());
        this.setSideOutputCondition(side -> this.feToEu && side == this.getMachine().getFrontFacing());
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void setFeToEu(boolean feToEu) {
        this.feToEu = feToEu;
        this.machine.notifyBlockUpdate();
    }

    @Override
    public void checkOutputSubscription() {
        this.outputSubs = this.getMachine().subscribeServerTick(this.outputSubs, this::serverTick);
    }

    @Override
    public void serverTick() {
        if (this.feToEu) {
            super.serverTick();
        } else {
            long energyUsed;
            class_2350 fontFacing = this.machine.getFrontFacing();
            IPlatformEnergyStorage energyContainer = GTCapabilityHelper.getPlatformEnergy(this.machine.getLevel(), this.machine.getPos().method_10093(fontFacing), fontFacing.method_10153());
            if (energyContainer != null && energyContainer.supportsInsertion() && (energyUsed = PlatformEnergyCompat.insertEu(energyContainer, Math.min(this.getEnergyStored(), this.voltage * (long)this.amps))) > 0L) {
                this.setEnergyStored(this.getEnergyStored() - energyUsed);
            }
        }
    }

    @Override
    public boolean supportsInsertion() {
        return this.feToEu;
    }

    @Override
    public boolean supportsExtraction() {
        return false;
    }

    @Override
    public long insert(long maxReceive, boolean simulate) {
        if (!this.feToEu || maxReceive <= 0L) {
            return 0L;
        }
        long received = Math.min(this.getCapacity() - this.getAmount(), maxReceive);
        received -= received % (long)PlatformEnergyCompat.ratio(true);
        if (!simulate) {
            this.addEnergy(PlatformEnergyCompat.toEu(received, PlatformEnergyCompat.ratio(true)));
        }
        return received;
    }

    @Override
    public long extract(long maxExtract, boolean simulate) {
        return 0L;
    }

    @Override
    public long getAmount() {
        return PlatformEnergyCompat.toNativeLong(this.getEnergyStored(), PlatformEnergyCompat.ratio(this.feToEu));
    }

    @Override
    public long getCapacity() {
        return PlatformEnergyCompat.toNativeLong(this.getEnergyCapacity(), PlatformEnergyCompat.ratio(this.feToEu));
    }

    public boolean isFeToEu() {
        return this.feToEu;
    }

    public int getAmps() {
        return this.amps;
    }

    public long getVoltage() {
        return this.voltage;
    }
}

