/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.storage;

import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.TieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IDropSaveMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.syncdata.RequireRerender;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.PhantomFluidWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.FluidActionResult;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.DropSaved;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3738;
import net.minecraft.class_3965;
import net.minecraft.class_6179;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6179
public class QuantumTankMachine
extends TieredMachine
implements IAutoOutputFluid,
IInteractedMachine,
IControllable,
IDropSaveMachine,
IFancyUIMachine {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(QuantumTankMachine.class, MetaMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DescSynced
    @RequireRerender
    protected class_2350 outputFacingFluids;
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean autoOutputFluids;
    @Persisted
    protected boolean allowInputFromOutputSideFluids;
    private final long maxStoredFluids;
    @Persisted
    @DropSaved
    protected final NotifiableFluidTank cache;
    @Nullable
    protected TickableSubscription autoOutputSubs;
    @Nullable
    protected ISubscription exportFluidSubs;
    @Persisted
    @DescSynced
    @DropSaved
    protected FluidStack stored = FluidStack.empty();
    @Persisted
    private boolean isVoiding;
    @Persisted
    @DescSynced
    private final FluidStorage lockedFluid;

    public QuantumTankMachine(IMachineBlockEntity holder, int tier, long maxStoredFluids, Object ... args) {
        super(holder, tier);
        this.outputFacingFluids = this.getFrontFacing().method_10153();
        this.maxStoredFluids = maxStoredFluids;
        this.cache = this.createCacheFluidHandler(args);
        this.lockedFluid = new FluidStorage(FluidHelper.getBucket());
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableFluidTank createCacheFluidHandler(Object ... args) {
        return new NotifiableFluidTank(this, 1, this.maxStoredFluids, IO.BOTH){

            @Override
            public long fill(FluidStack resource, boolean simulate, boolean notifyChanges) {
                return this.handleVoiding(super.fill(resource, simulate, notifyChanges), resource);
            }

            @Override
            public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
                return this.handleVoiding(super.fill(tank, resource, simulate, notifyChanges), resource);
            }

            @Override
            public long fill(FluidStack resource, boolean simulate) {
                return this.handleVoiding(super.fill(resource, simulate), resource);
            }

            private long handleVoiding(long filled, FluidStack resource) {
                if (filled < resource.getAmount() && QuantumTankMachine.this.isVoiding && this.isFluidValid(0, resource)) {
                    return resource.getAmount();
                }
                return filled;
            }
        }.setFilter(fluidStack -> !this.isLocked() || this.lockedFluid.getFluid().isFluidEqual(fluidStack));
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.stored = this.cache.getFluidInTank(0);
        class_1937 class_19372 = this.getLevel();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_8503().method_18858((Runnable)new class_3738(0, this::updateAutoOutputSubscription));
        }
        this.exportFluidSubs = this.cache.addChangedListener(this::onFluidChanged);
    }

    private void onFluidChanged() {
        if (!this.isRemote()) {
            this.stored = this.cache.getFluidInTank(0);
            this.updateAutoOutputSubscription();
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.exportFluidSubs != null) {
            this.exportFluidSubs.unsubscribe();
            this.exportFluidSubs = null;
        }
    }

    @Override
    public boolean savePickClone() {
        return false;
    }

    @Override
    public void setAutoOutputFluids(boolean allow) {
        this.autoOutputFluids = allow;
        this.updateAutoOutputSubscription();
    }

    @Override
    public void setOutputFacingFluids(@Nullable class_2350 outputFacing) {
        this.outputFacingFluids = outputFacing;
        this.updateAutoOutputSubscription();
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isAutoOutputFluids();
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        this.setAutoOutputFluids(isWorkingAllowed);
    }

    @Override
    public void onNeighborChanged(class_2248 block, class_2338 fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoOutputSubscription();
    }

    protected void updateAutoOutputSubscription() {
        class_2350 outputFacing = this.getOutputFacingFluids();
        if (this.isAutoOutputFluids() && !this.cache.isEmpty() && outputFacing != null && FluidTransferHelper.getFluidTransfer((class_1937)this.getLevel(), (class_2338)this.getPos().method_10093(outputFacing), (class_2350)outputFacing.method_10153()) != null) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::checkAutoOutput);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    protected void checkAutoOutput() {
        if (this.getOffsetTimer() % 5L == 0L) {
            if (this.isAutoOutputFluids() && this.getOutputFacingFluids() != null) {
                this.cache.exportToNearby(this.getOutputFacingFluids());
            }
            this.updateAutoOutputSubscription();
        }
    }

    @Override
    public boolean isFacingValid(class_2350 facing) {
        if (facing == this.outputFacingFluids) {
            return false;
        }
        return super.isFacingValid(facing);
    }

    @Override
    public class_1269 onUse(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 currentStack = player.method_6047();
        if (hit.method_17780() == this.getFrontFacing() && !currentStack.method_7960()) {
            IFluidTransfer handler = FluidTransferHelper.getFluidTransfer((class_1657)player, (class_1268)class_1268.field_5808);
            FluidStorage fluidTank = this.cache.storages[0];
            if (handler != null && !this.isRemote()) {
                FluidActionResult result;
                if (this.cache.storages[0].getFluidAmount() > 0L) {
                    FluidStack initialFluid = fluidTank.getFluid();
                    FluidActionResult result2 = FluidTransferHelper.tryFillContainer((class_1799)currentStack, (IFluidTransfer)fluidTank, (int)Integer.MAX_VALUE, null, (boolean)false);
                    if (result2.isSuccess()) {
                        class_1799 remainingStack = FluidTransferHelper.tryFillContainer((class_1799)currentStack, (IFluidTransfer)fluidTank, (int)Integer.MAX_VALUE, null, (boolean)true).getResult();
                        currentStack.method_7934(1);
                        class_3414 soundevent = FluidHelper.getFillSound((FluidStack)initialFluid);
                        if (soundevent != null) {
                            player.method_37908().method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, soundevent, class_3419.field_15245, 1.0f, 1.0f);
                        }
                        if (!remainingStack.method_7960() && !player.method_7270(remainingStack)) {
                            class_2248.method_9577((class_1937)player.method_37908(), (class_2338)player.method_23312(), (class_1799)remainingStack);
                        }
                        return class_1269.field_5812;
                    }
                }
                if ((result = FluidTransferHelper.tryEmptyContainer((class_1799)currentStack, (IFluidTransfer)fluidTank, (int)Integer.MAX_VALUE, null, (boolean)false)).isSuccess()) {
                    class_1799 remainingStack = FluidTransferHelper.tryEmptyContainer((class_1799)currentStack, (IFluidTransfer)fluidTank, (int)Integer.MAX_VALUE, null, (boolean)true).getResult();
                    currentStack.method_7934(1);
                    class_3414 soundevent = FluidHelper.getEmptySound((FluidStack)fluidTank.getFluid());
                    if (soundevent != null) {
                        player.method_37908().method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, soundevent, class_3419.field_15245, 1.0f, 1.0f);
                    }
                    if (!remainingStack.method_7960() && !player.method_31548().method_7394(remainingStack)) {
                        class_2248.method_9577((class_1937)player.method_37908(), (class_2338)player.method_23312(), (class_1799)remainingStack);
                    }
                }
                return class_1269.field_5812;
            }
        }
        return IInteractedMachine.super.onUse(state, world, pos, player, hand, hit);
    }

    @Override
    protected class_1269 onWrenchClick(class_1657 playerIn, class_1268 hand, class_2350 gridSide, class_3965 hitResult) {
        if (!playerIn.method_18276() && !this.isRemote()) {
            class_1799 tool = playerIn.method_5998(hand);
            if (tool.method_7919() >= tool.method_7936()) {
                return class_1269.field_5811;
            }
            if (this.hasFrontFacing() && gridSide == this.getFrontFacing()) {
                return class_1269.field_5811;
            }
            if (gridSide != this.getOutputFacingFluids()) {
                this.setOutputFacingFluids(gridSide);
            } else {
                this.setOutputFacingFluids(null);
            }
            return class_1269.field_21466;
        }
        return super.onWrenchClick(playerIn, hand, gridSide, hitResult);
    }

    @Override
    protected class_1269 onScrewdriverClick(class_1657 playerIn, class_1268 hand, class_2350 gridSide, class_3965 hitResult) {
        if (!this.isRemote()) {
            if (gridSide == this.getOutputFacingFluids()) {
                if (this.isAllowInputFromOutputSideFluids()) {
                    this.setAllowInputFromOutputSideFluids(false);
                    playerIn.method_43496((class_2561)class_2561.method_43471((String)"gtceu.machine.basic.input_from_output_side.disallow").method_10852((class_2561)class_2561.method_43471((String)"gtceu.creative.chest.fluid")));
                } else {
                    this.setAllowInputFromOutputSideFluids(true);
                    playerIn.method_43496((class_2561)class_2561.method_43471((String)"gtceu.machine.basic.input_from_output_side.allow").method_10852((class_2561)class_2561.method_43471((String)"gtceu.creative.chest.fluid")));
                }
            }
            return class_1269.field_5812;
        }
        return super.onScrewdriverClick(playerIn, hand, gridSide, hitResult);
    }

    public boolean isLocked() {
        return !this.lockedFluid.getFluid().isEmpty();
    }

    protected void setLocked(boolean locked) {
        if (!this.stored.isEmpty() && locked) {
            FluidStack copied = this.stored.copy();
            copied.setAmount(this.lockedFluid.getCapacity());
            this.lockedFluid.setFluid(copied);
        } else if (!locked) {
            this.lockedFluid.setFluid(FluidStack.empty());
        }
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 90, 63);
        group.addWidget((Widget)new ImageWidget(4, 4, 82, 55, (IGuiTexture)GuiTextures.DISPLAY)).addWidget((Widget)new LabelWidget(8, 8, "gtceu.gui.fluid_amount")).addWidget((Widget)new LabelWidget(8, 18, () -> String.valueOf(this.cache.getFluidInTank(0).getAmount() / (FluidHelper.getBucket() / 1000L))).setTextColor(-1).setDropShadow(true)).addWidget((Widget)new TankWidget((IFluidStorage)this.cache.storages[0], 68, 23, true, true).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT)).addWidget((Widget)new PhantomFluidWidget((IFluidStorage)this.lockedFluid, 68, 41, 18, 18).setShowAmount(false).setBackground((IGuiTexture)ColorPattern.T_GRAY.rectTexture())).addWidget((Widget)new ToggleButtonWidget(4, 41, 18, 18, (IGuiTexture)GuiTextures.BUTTON_FLUID_OUTPUT, this::isAutoOutputFluids, this::setAutoOutputFluids).setShouldUseBaseBackground().setTooltipText("gtceu.gui.fluid_auto_output.tooltip")).addWidget((Widget)new ToggleButtonWidget(22, 41, 18, 18, (IGuiTexture)GuiTextures.BUTTON_LOCK, this::isLocked, this::setLocked).setShouldUseBaseBackground().setTooltipText("gtceu.gui.fluid_lock.tooltip")).addWidget((Widget)new ToggleButtonWidget(40, 41, 18, 18, (IGuiTexture)GuiTextures.BUTTON_VOID, this::isVoiding, this::setVoiding).setShouldUseBaseBackground().setTooltipText("gtceu.gui.fluid_voiding_partial.tooltip"));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    @Override
    public ResourceTexture sideTips(class_1657 player, Set<GTToolType> toolTypes, class_2350 side) {
        if (toolTypes.contains(GTToolType.WRENCH)) {
            if (!(player.method_18276() || this.hasFrontFacing() && side == this.getFrontFacing())) {
                return GuiTextures.TOOL_IO_FACING_ROTATION;
            }
        } else if (toolTypes.contains(GTToolType.SCREWDRIVER) && side == this.getOutputFacingFluids()) {
            return GuiTextures.TOOL_ALLOW_INPUT;
        }
        return super.sideTips(player, toolTypes, side);
    }

    @Override
    public class_2350 getOutputFacingFluids() {
        return this.outputFacingFluids;
    }

    @Override
    public boolean isAutoOutputFluids() {
        return this.autoOutputFluids;
    }

    @Override
    public boolean isAllowInputFromOutputSideFluids() {
        return this.allowInputFromOutputSideFluids;
    }

    @Override
    public void setAllowInputFromOutputSideFluids(boolean allowInputFromOutputSideFluids) {
        this.allowInputFromOutputSideFluids = allowInputFromOutputSideFluids;
    }

    public long getMaxStoredFluids() {
        return this.maxStoredFluids;
    }

    public FluidStack getStored() {
        return this.stored;
    }

    public boolean isVoiding() {
        return this.isVoiding;
    }

    public void setVoiding(boolean isVoiding) {
        this.isVoiding = isVoiding;
    }

    public FluidStorage getLockedFluid() {
        return this.lockedFluid;
    }
}

