/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.storage;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineModifyDrops;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class CrateMachine
extends MetaMachine
implements IUIMachine,
IMachineModifyDrops {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(CrateMachine.class, MetaMachine.MANAGED_FIELD_HOLDER);
    private final Material material;
    private final int inventorySize;
    @Persisted
    public final NotifiableItemStackHandler inventory;

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public CrateMachine(IMachineBlockEntity holder, Material material, int inventorySize) {
        super(holder);
        this.material = material;
        this.inventorySize = inventorySize;
        this.inventory = new NotifiableItemStackHandler(this, inventorySize, IO.BOTH);
    }

    public ModularUI createUI(class_1657 entityPlayer) {
        int xOffset = this.inventorySize >= 90 ? 162 : 0;
        int yOverflow = xOffset > 0 ? 18 : 9;
        int yOffset = this.inventorySize > 3 * yOverflow ? (this.inventorySize - 3 * yOverflow - (this.inventorySize - 3 * yOverflow) % yOverflow) / yOverflow * 18 : 0;
        ModularUI modularUI = new ModularUI(176 + xOffset, 166 + yOffset, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND}).widget((Widget)new LabelWidget(5, 5, this.getBlockState().method_26204().method_9539())).widget((Widget)UITemplate.bindPlayerInventory(entityPlayer.method_31548(), (IGuiTexture)GuiTextures.SLOT, 7 + xOffset / 2, 82 + yOffset, true));
        int x = 0;
        int y = 0;
        for (int slot = 0; slot < this.inventorySize; ++slot) {
            modularUI.widget((Widget)new SlotWidget((IItemTransfer)this.inventory, slot, x * 18 + 7, y * 18 + 17).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT));
            if (++x != yOverflow) continue;
            x = 0;
            ++y;
        }
        return modularUI;
    }

    @Override
    public void onDrops(List<class_1799> drops, class_1657 entity) {
        MetaMachine.clearInventory(drops, (IItemTransfer)this.inventory.storage);
    }

    public Material getMaterial() {
        return this.material;
    }

    public int getInventorySize() {
        return this.inventorySize;
    }
}

