/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.steam;

import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.IMiner;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.gui.widget.PredicatedImageWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IExhaustVentMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineModifyDrops;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamWorkableMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.common.machine.trait.miner.SteamMinerLogic;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3738;
import net.minecraft.class_6328;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6328
public class SteamMinerMachine
extends SteamWorkableMachine
implements IMiner,
IControllable,
IExhaustVentMachine,
IUIMachine,
IMachineModifyDrops {
    @Persisted
    @DescSynced
    private boolean needsVenting;
    @Persisted
    public final NotifiableItemStackHandler importItems;
    @Persisted
    public final NotifiableItemStackHandler exportItems;
    private final int inventorySize;
    private final int energyPerTick = (int)(16L * FluidHelper.getBucket() / 1000L);
    @Nullable
    protected TickableSubscription autoOutputSubs;
    @Nullable
    protected ISubscription exportItemSubs;

    public SteamMinerMachine(IMachineBlockEntity holder, int speed, int maximumRadius, int fortune) {
        super(holder, false, fortune, speed, maximumRadius);
        this.inventorySize = 4;
        this.importItems = this.createImportItemHandler(new Object[0]);
        this.exportItems = this.createExportItemHandler(new Object[0]);
    }

    @Override
    @NotNull
    protected RecipeLogic createRecipeLogic(Object ... args) {
        Object object;
        if (args.length > 2 && (object = args[args.length - 3]) instanceof Integer) {
            Integer fortune = (Integer)object;
            object = args[args.length - 2];
            if (object instanceof Integer) {
                Integer speed = (Integer)object;
                object = args[args.length - 1];
                if (object instanceof Integer) {
                    Integer maxRadius = (Integer)object;
                    return new SteamMinerLogic(this, fortune, speed, maxRadius);
                }
            }
        }
        throw new IllegalArgumentException("MinerMachine need args [inventorySize, fortune, speed, maximumRadius] for initialization");
    }

    @Override
    public SteamMinerLogic getRecipeLogic() {
        return (SteamMinerLogic)super.getRecipeLogic();
    }

    @Override
    protected NotifiableFluidTank createSteamTank(Object ... args) {
        return new NotifiableFluidTank((MetaMachine)this, 1, 16L * FluidHelper.getBucket(), IO.IN);
    }

    protected NotifiableItemStackHandler createImportItemHandler(Object ... args) {
        return new NotifiableItemStackHandler(this, 0, IO.IN);
    }

    protected NotifiableItemStackHandler createExportItemHandler(Object ... args) {
        return new NotifiableItemStackHandler(this, this.inventorySize, IO.OUT);
    }

    @Override
    public void onDrops(List<class_1799> drops, class_1657 entity) {
        SteamMinerMachine.clearInventory(drops, (IItemTransfer)this.exportItems.storage);
    }

    @Override
    public void onNeighborChanged(class_2248 block, class_2338 fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoOutputSubscription();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            class_1937 class_19372 = this.getLevel();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                serverLevel.method_8503().method_18858((Runnable)new class_3738(0, this::updateAutoOutputSubscription));
            }
            this.exportItemSubs = this.exportItems.addChangedListener(this::updateAutoOutputSubscription);
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.exportItemSubs != null) {
            this.exportItemSubs.unsubscribe();
            this.exportItemSubs = null;
        }
    }

    protected void updateAutoOutputSubscription() {
        class_2350 outputFacingItems = this.getFrontFacing();
        if (!this.exportItems.isEmpty() && ItemTransferHelper.getItemTransfer((class_1937)this.getLevel(), (class_2338)this.getPos().method_10093(outputFacingItems), (class_2350)outputFacingItems.method_10153()) != null) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::autoOutput);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    protected void autoOutput() {
        if (this.getOffsetTimer() % 5L == 0L) {
            this.exportItems.exportToNearby(this.getFrontFacing());
        }
        this.updateAutoOutputSubscription();
    }

    public ModularUI createUI(class_1657 entityPlayer) {
        int rowSize = (int)Math.sqrt(this.inventorySize);
        ModularUI builder = new ModularUI(175, 176, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND_STEAM.get(false)});
        builder.widget((Widget)UITemplate.bindPlayerInventory(entityPlayer.method_31548(), (IGuiTexture)GuiTextures.SLOT_STEAM.get(false), 7, 94, true));
        for (int y = 0; y < rowSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                int index = y * rowSize + x;
                builder.widget((Widget)new SlotWidget((IItemTransfer)this.exportItems, index, 142 - rowSize * 9 + x * 18, 18 + y * 18, true, false).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT_STEAM.get(false)));
            }
        }
        builder.widget((Widget)new LabelWidget(5, 5, this.getBlockState().method_26204().method_9539()));
        builder.widget((Widget)new PredicatedImageWidget(79, 42, 18, 18, (IGuiTexture)GuiTextures.INDICATOR_NO_STEAM.get(this.isHighPressure)).setPredicate(this.recipeLogic::isWaiting));
        builder.widget((Widget)new ImageWidget(7, 16, 105, 75, (IGuiTexture)GuiTextures.DISPLAY_STEAM.get(false)));
        builder.widget((Widget)new ComponentPanelWidget(10, 19, this::addDisplayText).setMaxWidthLimit(84));
        builder.widget((Widget)new ComponentPanelWidget(70, 19, this::addDisplayText2).setMaxWidthLimit(84));
        return builder;
    }

    void addDisplayText(List<class_2561> textList) {
        int workingArea = IMiner.getWorkingArea(this.getRecipeLogic().getCurrentRadius());
        textList.add((class_2561)class_2561.method_43469((String)"gtceu.machine.miner.startx", (Object[])new Object[]{this.getRecipeLogic().getX()}));
        textList.add((class_2561)class_2561.method_43469((String)"gtceu.machine.miner.starty", (Object[])new Object[]{this.getRecipeLogic().getY()}));
        textList.add((class_2561)class_2561.method_43469((String)"gtceu.machine.miner.startz", (Object[])new Object[]{this.getRecipeLogic().getZ()}));
        textList.add((class_2561)class_2561.method_43469((String)"gtceu.universal.tooltip.working_area", (Object[])new Object[]{workingArea, workingArea}));
        if (this.getRecipeLogic().isDone()) {
            textList.add((class_2561)class_2561.method_43471((String)"gtceu.multiblock.large_miner.done").method_10862(class_2583.field_24360.method_10977(class_124.field_1060)));
        } else if (this.getRecipeLogic().isWorking()) {
            textList.add((class_2561)class_2561.method_43471((String)"gtceu.multiblock.large_miner.working").method_10862(class_2583.field_24360.method_10977(class_124.field_1065)));
        } else if (!this.isWorkingEnabled()) {
            textList.add((class_2561)class_2561.method_43471((String)"gtceu.multiblock.work_paused"));
        }
        if (this.getRecipeLogic().isInventoryFull()) {
            textList.add((class_2561)class_2561.method_43471((String)"gtceu.multiblock.large_miner.invfull").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)));
        }
    }

    void addDisplayText2(List<class_2561> textList) {
        textList.add((class_2561)class_2561.method_43469((String)"gtceu.machine.miner.minex", (Object[])new Object[]{this.getRecipeLogic().getMineX()}));
        textList.add((class_2561)class_2561.method_43469((String)"gtceu.machine.miner.miney", (Object[])new Object[]{this.getRecipeLogic().getMineY()}));
        textList.add((class_2561)class_2561.method_43469((String)"gtceu.machine.miner.minez", (Object[])new Object[]{this.getRecipeLogic().getMineZ()}));
    }

    @Override
    public boolean drainInput(boolean simulate) {
        long resultSteam = this.steamTank.getFluidInTank(0).getAmount() - (long)this.energyPerTick;
        if (!this.isVentingBlocked() && resultSteam >= 0L && resultSteam <= this.steamTank.getTankCapacity(0)) {
            if (!simulate) {
                this.steamTank.drain(this.energyPerTick, true);
            }
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public class_2350 getVentingDirection() {
        return class_2350.field_11036;
    }

    @Override
    public boolean needsVenting() {
        return this.needsVenting;
    }

    @Override
    public void markVentingComplete() {
    }

    @Override
    public float getVentingDamage() {
        return 0.0f;
    }

    @Override
    public void setNeedsVenting(boolean needsVenting) {
        this.needsVenting = needsVenting;
    }
}

