/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.steam;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IExplosionMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDisplayUIMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3738;
import net.minecraft.class_5250;
import net.minecraft.class_6328;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6328
public class LargeBoilerMachine
extends WorkableMultiblockMachine
implements IExplosionMachine,
IDisplayUIMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(LargeBoilerMachine.class, WorkableMultiblockMachine.MANAGED_FIELD_HOLDER);
    private static final long STEAM_PER_WATER = 160L;
    public final int maxTemperature;
    public final int heatSpeed;
    @Persisted
    private int currentTemperature;
    @Persisted
    private int throttle;
    private boolean hasNoWater;
    @Nullable
    protected TickableSubscription temperatureSubs;

    public LargeBoilerMachine(IMachineBlockEntity holder, int maxTemperature, int heatSpeed, Object ... args) {
        super(holder, args);
        this.maxTemperature = maxTemperature;
        this.heatSpeed = heatSpeed;
        this.throttle = 100;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        class_1937 class_19372 = this.getLevel();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_8503().method_18858((Runnable)new class_3738(0, this::updateSteamSubscription));
        }
    }

    protected void updateSteamSubscription() {
        if (this.currentTemperature > 0) {
            this.temperatureSubs = this.subscribeServerTick(this.temperatureSubs, this::updateCurrentTemperature);
        } else if (this.temperatureSubs != null) {
            this.temperatureSubs.unsubscribe();
            this.temperatureSubs = null;
        }
    }

    protected void updateCurrentTemperature() {
        if (this.recipeLogic.isWorking()) {
            if (this.getOffsetTimer() % 10L == 0L && this.currentTemperature < this.getMaxTemperature()) {
                this.currentTemperature = class_3532.method_15340((int)(this.currentTemperature + this.heatSpeed * 10), (int)0, (int)this.getMaxTemperature());
            }
        } else if (this.currentTemperature > 0) {
            this.currentTemperature -= this.getCoolDownRate();
        }
        if (this.currentTemperature >= 100 && this.getOffsetTimer() % 5L == 0L) {
            boolean hasDrainedWater;
            IRecipeHandler tank;
            long maxDrain = (long)(this.currentTemperature * this.throttle * 5) * FluidHelper.getBucket() / 16000000L;
            List<FluidIngredient> drainWater = List.of(FluidIngredient.of(maxDrain, new class_3611[]{class_3612.field_15910}));
            ArrayList inputTanks = new ArrayList();
            if (this.getCapabilitiesProxy().contains((Object)IO.IN, (Object)FluidRecipeCapability.CAP)) {
                inputTanks.addAll(Objects.requireNonNull((List)this.getCapabilitiesProxy().get((Object)IO.IN, (Object)FluidRecipeCapability.CAP)));
            }
            if (this.getCapabilitiesProxy().contains((Object)IO.BOTH, (Object)FluidRecipeCapability.CAP)) {
                inputTanks.addAll(Objects.requireNonNull((List)this.getCapabilitiesProxy().get((Object)IO.BOTH, (Object)FluidRecipeCapability.CAP)));
            }
            Iterator iterator = inputTanks.iterator();
            while (iterator.hasNext() && (drainWater = (tank = (IRecipeHandler)iterator.next()).handleRecipe(IO.IN, null, drainWater, null, false)) != null) {
            }
            long drained = drainWater == null || drainWater.isEmpty() ? maxDrain : maxDrain - drainWater.get(0).getAmount();
            boolean bl = hasDrainedWater = drained > 0L;
            if (hasDrainedWater) {
                IRecipeHandler tank2;
                List<FluidIngredient> fillSteam = List.of(FluidIngredient.of(GTMaterials.Steam.getFluid(drained * 160L)));
                ArrayList outputTanks = new ArrayList();
                if (this.getCapabilitiesProxy().contains((Object)IO.OUT, (Object)FluidRecipeCapability.CAP)) {
                    outputTanks.addAll(Objects.requireNonNull((List)this.getCapabilitiesProxy().get((Object)IO.OUT, (Object)FluidRecipeCapability.CAP)));
                }
                if (this.getCapabilitiesProxy().contains((Object)IO.BOTH, (Object)FluidRecipeCapability.CAP)) {
                    outputTanks.addAll(Objects.requireNonNull((List)this.getCapabilitiesProxy().get((Object)IO.BOTH, (Object)FluidRecipeCapability.CAP)));
                }
                Iterator iterator2 = outputTanks.iterator();
                while (iterator2.hasNext() && (fillSteam = (tank2 = (IRecipeHandler)iterator2.next()).handleRecipe(IO.OUT, null, fillSteam, null, false)) != null) {
                }
            }
            if (this.hasNoWater && hasDrainedWater) {
                this.doExplosion(2.0f);
                class_2338 center = this.getPos().method_10074().method_10093(this.getFrontFacing().method_10153());
                if (GTValues.RNG.method_43048(100) > 80) {
                    this.doExplosion(center, 2.0f);
                }
                for (class_2350 x : class_2350.class_2353.field_11062) {
                    for (class_2350 y : class_2350.class_2353.field_11062) {
                        if (GTValues.RNG.method_43048(100) <= 80) continue;
                        this.doExplosion(center.method_10093(x).method_10093(y), 2.0f);
                    }
                }
            } else {
                this.hasNoWater = !hasDrainedWater;
            }
        } else {
            this.hasNoWater = false;
        }
        this.updateSteamSubscription();
    }

    protected int getCoolDownRate() {
        return 1;
    }

    @Override
    public void onWorking() {
        if (this.currentTemperature < this.getMaxTemperature()) {
            this.currentTemperature = Math.max(1, this.currentTemperature);
            this.updateSteamSubscription();
        }
    }

    @Nullable
    public static GTRecipe recipeModifier(MetaMachine machine, @Nonnull GTRecipe recipe) {
        if (machine instanceof LargeBoilerMachine) {
            LargeBoilerMachine largeBoilerMachine = (LargeBoilerMachine)machine;
            if (largeBoilerMachine.throttle < 100) {
                GTRecipe copied = recipe.copy();
                copied.duration = recipe.duration * 100 / largeBoilerMachine.throttle;
                return copied;
            }
            return recipe;
        }
        return null;
    }

    @Override
    public void addDisplayText(List<class_2561> textList) {
        IDisplayUIMachine.super.addDisplayText(textList);
        if (this.isFormed()) {
            textList.add((class_2561)class_2561.method_43469((String)"gtceu.multiblock.large_boiler.temperature", (Object[])new Object[]{(int)((double)this.currentTemperature + 274.15), (int)((double)this.maxTemperature + 274.15)}));
            textList.add((class_2561)class_2561.method_43469((String)"gtceu.multiblock.large_boiler.steam_output", (Object[])new Object[]{this.currentTemperature}));
            class_5250 throttleText = class_2561.method_43469((String)"gtceu.multiblock.large_boiler.throttle", (Object[])new Object[]{class_124.field_1075.toString() + this.getThrottle() + "%"}).method_27696(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"gtceu.multiblock.large_boiler.throttle.tooltip"))));
            textList.add((class_2561)throttleText);
            class_5250 buttonText = class_2561.method_43471((String)"gtceu.multiblock.large_boiler.throttle_modify");
            buttonText.method_27693(" ");
            buttonText.method_10852(ComponentPanelWidget.withButton((class_2561)class_2561.method_43470((String)"[-]"), (String)"sub"));
            buttonText.method_27693(" ");
            buttonText.method_10852(ComponentPanelWidget.withButton((class_2561)class_2561.method_43470((String)"[+]"), (String)"add"));
            textList.add((class_2561)buttonText);
        }
    }

    @Override
    public void handleDisplayClick(String componentData, ClickData clickData) {
        if (!clickData.isRemote) {
            int result = componentData.equals("add") ? 5 : -5;
            this.throttle = class_3532.method_15340((int)(this.throttle + result), (int)25, (int)100);
        }
    }

    @Override
    public IGuiTexture getScreenTexture() {
        return GuiTextures.DISPLAY_STEAM.get(this.maxTemperature > 800);
    }

    public int getMaxTemperature() {
        return this.maxTemperature;
    }

    public int getHeatSpeed() {
        return this.heatSpeed;
    }

    public int getCurrentTemperature() {
        return this.currentTemperature;
    }

    public int getThrottle() {
        return this.throttle;
    }

    public boolean isHasNoWater() {
        return this.hasNoWater;
    }
}

