/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IMachineModifyDrops;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IRotorHolderMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IWorkableMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.syncdata.RequireRerender;
import com.gregtechceu.gtceu.common.item.TurbineRotorBehaviour;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_6328;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6328
public class RotorHolderPartMachine
extends TieredPartMachine
implements IMachineModifyDrops,
IRotorHolderMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(RotorHolderPartMachine.class, TieredPartMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    public final NotifiableItemStackHandler inventory = new NotifiableItemStackHandler(this, 1, IO.NONE, IO.BOTH);
    public final int maxRotorHolderSpeed;
    @Persisted
    @DescSynced
    @RequireRerender
    public int rotorSpeed;
    @Persisted
    @DescSynced
    @RequireRerender
    public int rotorColor;
    @Nullable
    protected TickableSubscription rotorSpeedSubs;
    @Nullable
    protected ISubscription rotorInvSubs;

    public RotorHolderPartMachine(IMachineBlockEntity holder, int tier) {
        super(holder, tier);
        this.maxRotorHolderSpeed = 2000 + 1000 * tier;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onDrops(List<class_1799> drops, class_1657 entity) {
        RotorHolderPartMachine.clearInventory(drops, (IItemTransfer)this.inventory.storage);
    }

    @Override
    public int tintColor(int index) {
        if (index == 2) {
            return this.rotorColor;
        }
        return super.tintColor(index);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.updateRotorSubscription();
            this.rotorInvSubs = this.inventory.addChangedListener(this::onRotorInventoryChanged);
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.rotorInvSubs != null) {
            this.rotorInvSubs.unsubscribe();
        }
    }

    private void onRotorInventoryChanged() {
        class_1799 stack = this.getRotorStack();
        TurbineRotorBehaviour rotorBehaviour = TurbineRotorBehaviour.getBehaviour(stack);
        int color = 0;
        if (rotorBehaviour != null) {
            color = rotorBehaviour.getPartMaterial(stack).getMaterialARGB();
        }
        this.rotorColor = color;
    }

    @Override
    public boolean hasRotor() {
        return this.rotorColor != 0;
    }

    protected void updateRotorSubscription() {
        if (this.getRotorSpeed() > 0) {
            this.rotorSpeedSubs = this.subscribeServerTick(this.rotorSpeedSubs, this::updateRotorSpeed);
        } else if (this.rotorSpeedSubs != null) {
            this.rotorSpeedSubs.unsubscribe();
            this.rotorSpeedSubs = null;
        }
    }

    private void updateRotorSpeed() {
        for (IMultiController controller : this.getControllers()) {
            IWorkableMultiController workableMultiController;
            if (!(controller instanceof IWorkableMultiController) || !(workableMultiController = (IWorkableMultiController)controller).getRecipeLogic().isWorking()) continue;
            return;
        }
        if (!this.hasRotor()) {
            this.setRotorSpeed(0);
        } else if (this.getRotorSpeed() > 0) {
            this.setRotorSpeed(Math.max(0, this.getRotorSpeed() - 3));
        }
        this.updateRotorSubscription();
    }

    @Override
    public void onWorking(IWorkableMultiController controller) {
        if (this.getRotorSpeed() < this.getMaxRotorHolderSpeed()) {
            this.setRotorSpeed(this.getRotorSpeed() + 1);
            this.updateRotorSubscription();
        }
        if (this.self().getOffsetTimer() % 20L == 0L) {
            int numMaintenanceProblems = 0;
            for (IMultiPart part : controller.getParts()) {
                if (!(part instanceof IMaintenanceMachine)) continue;
                IMaintenanceMachine maintenance = (IMaintenanceMachine)part;
                numMaintenanceProblems = maintenance.getNumMaintenanceProblems();
                break;
            }
            this.damageRotor(1 + numMaintenanceProblems);
        }
    }

    @Override
    public int getTierDifference() {
        for (IMultiController controller : this.getControllers()) {
            if (!(controller instanceof ITieredMachine)) continue;
            ITieredMachine tieredMachine = (ITieredMachine)((Object)controller);
            return this.getTier() - tieredMachine.getTier();
        }
        return -1;
    }

    @Override
    public class_1799 getRotorStack() {
        return this.inventory.getStackInSlot(0);
    }

    @Override
    public void setRotorStack(class_1799 rotorStack) {
        this.inventory.setStackInSlot(0, rotorStack);
        this.inventory.onContentsChanged();
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 34, 34);
        WidgetGroup container = new WidgetGroup(4, 4, 26, 26);
        container.addWidget(new SlotWidget((IItemTransfer)this.inventory.storage, 0, 4, 4, true, true).setBackground(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.TURBINE_OVERLAY}));
        container.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        group.addWidget((Widget)container);
        return group;
    }

    @Override
    public int getMaxRotorHolderSpeed() {
        return this.maxRotorHolderSpeed;
    }

    @Override
    public int getRotorSpeed() {
        return this.rotorSpeed;
    }

    @Override
    public void setRotorSpeed(int rotorSpeed) {
        this.rotorSpeed = rotorSpeed;
    }

    public void setRotorColor(int rotorColor) {
        this.rotorColor = rotorColor;
    }
}

