/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineModifyDrops;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMaintenanceMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.syncdata.RequireRerender;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.ContainerTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_6328;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6328
public class MaintenanceHatchPartMachine
extends TieredPartMachine
implements IMachineModifyDrops,
IMaintenanceMachine,
IInteractedMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MaintenanceHatchPartMachine.class, MultiblockPartMachine.MANAGED_FIELD_HOLDER);
    private static final float MAX_DURATION_MULTIPLIER = 1.1f;
    private static final float MIN_DURATION_MULTIPLIER = 0.9f;
    private static final float DURATION_ACTION_AMOUNT = 0.01f;
    private final boolean isConfigurable;
    @Persisted
    private final NotifiableItemStackHandler itemStackHandler;
    @Persisted
    @DescSynced
    @RequireRerender
    private boolean isTaped;
    @Persisted
    protected int timeActive;
    @Persisted
    @DescSynced
    protected byte maintenanceProblems = this.startProblems();
    @Persisted
    private float durationMultiplier = 1.0f;
    @Nullable
    protected TickableSubscription maintenanceSubs;

    public MaintenanceHatchPartMachine(IMachineBlockEntity metaTileEntityId, boolean isConfigurable) {
        super(metaTileEntityId, isConfigurable ? 3 : 1);
        this.isConfigurable = isConfigurable;
        this.itemStackHandler = this.createInventory();
        this.itemStackHandler.setFilter(itemStack -> GTItems.DUCT_TAPE.is(itemStack));
    }

    protected NotifiableItemStackHandler createInventory() {
        return new NotifiableItemStackHandler(this, 1, IO.BOTH, IO.IN);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onDrops(List<class_1799> drops, class_1657 entity) {
        MaintenanceHatchPartMachine.clearInventory(drops, this.itemStackHandler);
    }

    @Override
    public byte startProblems() {
        return 0;
    }

    @Override
    public void setMaintenanceProblems(byte problems) {
        this.maintenanceProblems = problems;
        this.updateMaintenanceSubscription();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.updateMaintenanceSubscription();
        }
    }

    protected void updateMaintenanceSubscription() {
        if (this.hasMaintenanceProblems()) {
            this.maintenanceSubs = this.subscribeServerTick(this.maintenanceSubs, this::update);
        } else if (this.maintenanceSubs != null) {
            this.maintenanceSubs.unsubscribe();
            this.maintenanceSubs = null;
        }
    }

    public void update() {
        if (this.getOffsetTimer() % 20L == 0L) {
            if (this.hasMaintenanceProblems()) {
                if (this.consumeDuctTape(this.itemStackHandler, 0)) {
                    this.fixAllMaintenanceProblems();
                    this.setTaped(true);
                }
            } else {
                this.updateMaintenanceSubscription();
            }
        }
    }

    private void fixMaintenanceProblems(@Nullable class_1657 entityPlayer) {
        if (!this.hasMaintenanceProblems()) {
            return;
        }
        if (entityPlayer != null) {
            if (entityPlayer.method_7337()) {
                this.fixAllMaintenanceProblems();
                return;
            }
            for (int i = 0; i < entityPlayer.method_31548().field_7547.size(); ++i) {
                if (!this.consumeDuctTape((IItemTransfer)new ContainerTransfer((class_1263)entityPlayer.method_31548()), i)) continue;
                this.fixAllMaintenanceProblems();
                this.setTaped(true);
                return;
            }
            this.fixProblemsWithTools(this.getMaintenanceProblems(), entityPlayer);
        }
    }

    private boolean consumeDuctTape(IItemTransfer handler, int slot) {
        class_1799 stored = handler.getStackInSlot(slot);
        if (!stored.method_7960() && stored.method_31574((class_1792)GTItems.DUCT_TAPE.get())) {
            return handler.extractItem(slot, 1, false).method_31574((class_1792)GTItems.DUCT_TAPE.get());
        }
        return false;
    }

    private boolean consumeDuctTape(class_1657 player, class_1268 hand) {
        class_1799 held = player.method_5998(hand);
        if (!held.method_7960() && held.method_31574((class_1792)GTItems.DUCT_TAPE.get())) {
            if (!player.method_7337()) {
                held.method_7934(1);
            }
            return true;
        }
        return false;
    }

    private void fixProblemsWithTools(byte problems, class_1657 entityPlayer) {
        List<GTToolType> toolsToMatch = Arrays.asList(new GTToolType[6]);
        boolean proceed = false;
        block8: for (int index = 0; index < 6; index = (int)((byte)(index + 1))) {
            if ((problems >> index & 1) != 0) continue;
            proceed = true;
            switch (index) {
                case 0: {
                    toolsToMatch.set(0, GTToolType.WRENCH);
                    continue block8;
                }
                case 1: {
                    toolsToMatch.set(1, GTToolType.SCREWDRIVER);
                    continue block8;
                }
                case 2: {
                    toolsToMatch.set(2, GTToolType.SOFT_MALLET);
                    continue block8;
                }
                case 3: {
                    toolsToMatch.set(3, GTToolType.HARD_HAMMER);
                    continue block8;
                }
                case 4: {
                    toolsToMatch.set(4, GTToolType.WIRE_CUTTER);
                    continue block8;
                }
                case 5: {
                    toolsToMatch.set(5, GTToolType.CROWBAR);
                }
            }
        }
        if (!proceed) {
            return;
        }
        for (int i = 0; i < toolsToMatch.size(); ++i) {
            GTToolType toolToMatch = toolsToMatch.get(i);
            if (toolToMatch == null) continue;
            class_1799 heldItem = entityPlayer.field_7512.method_34255();
            if (ToolHelper.is(heldItem, toolToMatch)) {
                this.fixProblemWithTool(i, heldItem, entityPlayer);
                if (toolsToMatch.stream().allMatch(Objects::isNull)) {
                    return;
                }
            }
            for (class_1799 itemStack : entityPlayer.method_31548().field_7547) {
                if (!ToolHelper.is(itemStack, toolToMatch)) continue;
                this.fixProblemWithTool(i, itemStack, entityPlayer);
                if (!toolsToMatch.stream().allMatch(Objects::isNull)) continue;
                return;
            }
            if (!(entityPlayer instanceof class_3222)) continue;
            class_3222 player = (class_3222)entityPlayer;
            for (class_1799 stack : entityPlayer.method_31548().field_7547) {
                if (!ToolHelper.is(stack, toolToMatch)) continue;
                this.setMaintenanceFixed(i);
                ToolHelper.damageItem(stack, (class_1309)player, 1);
                if (!toolsToMatch.stream().allMatch(Objects::isNull)) continue;
                return;
            }
        }
    }

    private void fixProblemWithTool(int problemIndex, class_1799 stack, class_1657 player) {
        this.setMaintenanceFixed(problemIndex);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            ToolHelper.damageItem(stack, (class_1309)serverPlayer, 1);
        }
        this.setTaped(false);
    }

    public void fixAllMaintenanceProblems() {
        for (int i = 0; i < 6; ++i) {
            this.setMaintenanceFixed(i);
        }
    }

    @Override
    public boolean isFullAuto() {
        return false;
    }

    @Override
    public float getTimeMultiplier() {
        float result = 1.0f;
        result = (double)this.durationMultiplier < 1.0 ? -20.0f * this.durationMultiplier + 21.0f : -8.0f * this.durationMultiplier + 9.0f;
        return BigDecimal.valueOf(result).setScale(2, RoundingMode.HALF_UP).floatValue();
    }

    private void incInternalMultiplier() {
        if (this.durationMultiplier >= 1.1f) {
            this.durationMultiplier = 1.1f;
            return;
        }
        this.durationMultiplier += 0.01f;
    }

    private void decInternalMultiplier() {
        if (this.durationMultiplier <= 0.9f) {
            this.durationMultiplier = 0.9f;
            return;
        }
        this.durationMultiplier -= 0.01f;
    }

    @Override
    public class_1269 onUse(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (this.hasMaintenanceProblems() && this.consumeDuctTape(player, hand)) {
            this.fixAllMaintenanceProblems();
            this.setTaped(true);
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group;
        if (this.isConfigurable) {
            group = new WidgetGroup(0, 0, 150, 70);
            group.addWidget((Widget)new DraggableScrollableWidgetGroup(4, 4, 142, 62).setBackground((IGuiTexture)GuiTextures.DISPLAY).addWidget((Widget)new ComponentPanelWidget(4, 5, list -> {
                list.add(MaintenanceHatchPartMachine.getTextWidgetText("duration", this::getDurationMultiplier));
                list.add(MaintenanceHatchPartMachine.getTextWidgetText("time", this::getTimeMultiplier));
                class_5250 buttonText = class_2561.method_43471((String)"gtceu.maintenance.configurable_duration.modify");
                buttonText.method_27693(" ");
                buttonText.method_10852(ComponentPanelWidget.withButton((class_2561)class_2561.method_43470((String)"[-]"), (String)"sub"));
                buttonText.method_27693(" ");
                buttonText.method_10852(ComponentPanelWidget.withButton((class_2561)class_2561.method_43470((String)"[+]"), (String)"add"));
                list.add(buttonText);
            }).setMaxWidthLimit(130).clickHandler((componentData, clickData) -> {
                if (!clickData.isRemote) {
                    if (componentData.equals("sub")) {
                        this.decInternalMultiplier();
                    } else if (componentData.equals("add")) {
                        this.incInternalMultiplier();
                    }
                }
            })));
        } else {
            group = new WidgetGroup(0, 0, 26, 46);
        }
        group.addWidget(new SlotWidget((IItemTransfer)this.itemStackHandler, 0, group.getSize().width - 4 - 18, 4).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.DUCT_TAPE_OVERLAY})).setHoverTooltips(new String[]{"gtceu.machine.maintenance_hatch_tape_slot.tooltip"}));
        group.addWidget(new ButtonWidget(group.getSize().width - 4 - 18, 24, 18, 18, (IGuiTexture)GuiTextures.MAINTENANCE_BUTTON, data -> this.fixMaintenanceProblems(group.getGui().entityPlayer)).setHoverTooltips(new String[]{"gtceu.machine.maintenance_hatch_tool_slot.tooltip"}));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    private static class_2561 getTextWidgetText(String type, Supplier<Float> multiplier) {
        class_5250 tooltip = (double)multiplier.get().floatValue() == 1.0 ? class_2561.method_43471((String)("gtceu.maintenance.configurable_" + type + ".unchanged_description")) : class_2561.method_43469((String)("gtceu.maintenance.configurable_" + type + ".changed_description"), (Object[])new Object[]{multiplier.get()});
        return class_2561.method_43469((String)("gtceu.maintenance.configurable_" + type), (Object[])new Object[]{multiplier.get()}).method_10862(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)tooltip)));
    }

    public boolean isConfigurable() {
        return this.isConfigurable;
    }

    @Override
    public boolean isTaped() {
        return this.isTaped;
    }

    @Override
    public void setTaped(boolean isTaped) {
        this.isTaped = isTaped;
    }

    @Override
    public int getTimeActive() {
        return this.timeActive;
    }

    @Override
    public void setTimeActive(int timeActive) {
        this.timeActive = timeActive;
    }

    @Override
    public byte getMaintenanceProblems() {
        return this.maintenanceProblems;
    }

    @Override
    public float getDurationMultiplier() {
        return this.durationMultiplier;
    }
}

