/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredIOPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3965;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class DiodePartMachine
extends TieredIOPartMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(DiodePartMachine.class, TieredIOPartMachine.MANAGED_FIELD_HOLDER);
    public static int MAX_AMPS = 16;
    @Persisted
    protected NotifiableEnergyContainer energyContainer;
    @Persisted(key="amp_mode")
    private int amps;

    public DiodePartMachine(IMachineBlockEntity holder, int tier) {
        super(holder, tier, IO.BOTH);
        long tierVoltage = GTValues.V[this.getTier()];
        this.amps = 1;
        this.energyContainer = new NotifiableEnergyContainer(this, tierVoltage * (long)MAX_AMPS * 2L, tierVoltage, MAX_AMPS, tierVoltage, MAX_AMPS);
        this.reinitializeEnergyContainer();
    }

    private void cycleAmpMode() {
        int n = this.amps = this.amps == this.getMaxAmperage() ? 1 : this.amps << 1;
        if (!this.getLevel().field_9236) {
            this.reinitializeEnergyContainer();
            this.notifyBlockUpdate();
            this.markDirty();
        }
    }

    protected int getMaxAmperage() {
        return MAX_AMPS;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!LDLib.isRemote()) {
            this.reinitializeEnergyContainer();
        }
    }

    protected void reinitializeEnergyContainer() {
        long tierVoltage = GTValues.V[this.getTier()];
        this.energyContainer.resetBasicInfo(tierVoltage * (long)MAX_AMPS * 2L, tierVoltage, this.amps, tierVoltage, this.amps);
        this.energyContainer.setSideInputCondition(s -> s != this.getFrontFacing());
        this.energyContainer.setSideOutputCondition(s -> s == this.getFrontFacing());
    }

    @Override
    public boolean isFacingValid(class_2350 facing) {
        return true;
    }

    @Override
    protected class_1269 onSoftMalletClick(class_1657 playerIn, class_1268 hand, class_2350 gridSide, class_3965 hitResult) {
        if (this.getLevel().field_9236) {
            this.scheduleRenderUpdate();
            return class_1269.field_21466;
        }
        this.cycleAmpMode();
        playerIn.method_43496((class_2561)class_2561.method_43469((String)"gtceu.machine.diode.message", (Object[])new Object[]{this.amps}));
        return class_1269.field_21466;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }
}

