/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.FluidTankProxyTrait;
import com.gregtechceu.gtceu.api.machine.trait.ItemHandlerProxyTrait;
import com.gregtechceu.gtceu.common.machine.multiblock.primitive.CokeOvenMachine;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3965;
import net.minecraft.class_6328;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6328
public class CokeOvenHatch
extends MultiblockPartMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(CokeOvenHatch.class, MultiblockPartMachine.MANAGED_FIELD_HOLDER);
    public final ItemHandlerProxyTrait inputInventory = new ItemHandlerProxyTrait(this, IO.IN);
    public final ItemHandlerProxyTrait outputInventory = new ItemHandlerProxyTrait(this, IO.OUT);
    public final FluidTankProxyTrait tank = new FluidTankProxyTrait(this, IO.BOTH);
    @Nullable
    protected TickableSubscription autoIOSubs;
    @Nullable
    protected ISubscription outputInventorySubs;
    @Nullable
    protected ISubscription outputTankSubs;

    public CokeOvenHatch(IMachineBlockEntity holder, Object ... args) {
        super(holder);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onUnload() {
        super.onUnload();
        this.inputInventory.setProxy(null);
        this.outputInventory.setProxy(null);
        this.tank.setProxy(null);
        if (this.outputInventorySubs != null) {
            this.outputInventorySubs.unsubscribe();
            this.outputInventorySubs = null;
        }
        if (this.outputTankSubs != null) {
            this.outputTankSubs.unsubscribe();
            this.outputTankSubs = null;
        }
    }

    @Override
    public void addedToController(IMultiController controller) {
        super.addedToController(controller);
        if (controller instanceof CokeOvenMachine) {
            CokeOvenMachine cokeOven = (CokeOvenMachine)controller;
            this.outputInventorySubs = cokeOven.exportItems.addChangedListener(this::updateAutoIOSubscription);
            this.outputTankSubs = cokeOven.exportFluids.addChangedListener(this::updateAutoIOSubscription);
            this.inputInventory.setProxy(cokeOven.importItems);
            this.outputInventory.setProxy(cokeOven.exportItems);
            this.tank.setProxy(cokeOven.exportFluids);
        }
    }

    @Override
    public void removedFromController(IMultiController controller) {
        super.removedFromController(controller);
        this.inputInventory.setProxy(null);
        this.outputInventory.setProxy(null);
        this.tank.setProxy(null);
        if (this.outputInventorySubs != null) {
            this.outputInventorySubs.unsubscribe();
            this.outputInventorySubs = null;
        }
        if (this.outputTankSubs != null) {
            this.outputTankSubs.unsubscribe();
            this.outputTankSubs = null;
        }
    }

    @Override
    public boolean canShared() {
        return false;
    }

    @Override
    public boolean replacePartModelWhenFormed() {
        return false;
    }

    @Override
    public void onNeighborChanged(class_2248 block, class_2338 fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoIOSubscription();
    }

    @Override
    public void onRotated(class_2350 oldFacing, class_2350 newFacing) {
        super.onRotated(oldFacing, newFacing);
        this.updateAutoIOSubscription();
    }

    protected void updateAutoIOSubscription() {
        if (!this.outputInventory.isEmpty() && ItemTransferHelper.getItemTransfer((class_1937)this.getLevel(), (class_2338)this.getPos().method_10093(this.getFrontFacing()), (class_2350)this.getFrontFacing().method_10153()) != null || !this.tank.isEmpty() && FluidTransferHelper.getFluidTransfer((class_1937)this.getLevel(), (class_2338)this.getPos().method_10093(this.getFrontFacing()), (class_2350)this.getFrontFacing().method_10153()) != null) {
            this.autoIOSubs = this.subscribeServerTick(this.autoIOSubs, this::autoIO);
        } else if (this.autoIOSubs != null) {
            this.autoIOSubs.unsubscribe();
            this.autoIOSubs = null;
        }
    }

    protected void autoIO() {
        if (this.getOffsetTimer() % 5L == 0L) {
            this.outputInventory.exportToNearby(this.getFrontFacing());
            this.tank.exportToNearby(this.getFrontFacing());
            this.updateAutoIOSubscription();
        }
    }

    @Override
    public boolean shouldOpenUI(class_1657 player, class_1268 hand, class_3965 hit) {
        return false;
    }
}

