/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.IFusionCasingType;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.OverclockingLogic;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.common.block.FusionCasingBlock;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_6328;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6328
public class FusionReactorMachine
extends WorkableElectricMultiblockMachine
implements ITieredMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(FusionReactorMachine.class, WorkableMultiblockMachine.MANAGED_FIELD_HOLDER);
    private final int tier;
    @Nullable
    protected EnergyContainerList inputEnergyContainers;
    @Persisted
    protected long heat = 0L;
    @Persisted
    protected final NotifiableEnergyContainer energyContainer;
    @Nullable
    protected TickableSubscription preHeatSubs;

    public FusionReactorMachine(IMachineBlockEntity holder, int tier) {
        super(holder, new Object[0]);
        this.tier = tier;
        this.energyContainer = this.createEnergyContainer();
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public NotifiableEnergyContainer createEnergyContainer() {
        NotifiableEnergyContainer container = new NotifiableEnergyContainer(this, 0L, 0L, 0L, 0L, 0L);
        container.setCapabilityValidator(Objects::isNull);
        return container;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            this.updatePreHeatSubscription();
        }
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        ArrayList<IEnergyContainer> energyContainers = new ArrayList<IEnergyContainer>();
        Map ioMap = (Map)this.getMultiblockState().getMatchContext().getOrCreate("ioMap", Long2ObjectMaps::emptyMap);
        for (IMultiPart part : this.getParts()) {
            IO io = ioMap.getOrDefault(part.self().getPos().method_10063(), IO.BOTH);
            if (io == IO.NONE || io == IO.OUT) continue;
            for (IRecipeHandlerTrait handler : part.getRecipeHandlers()) {
                if (io != IO.BOTH && handler.getHandlerIO() != IO.BOTH && io != handler.getHandlerIO() || handler.getCapability() != EURecipeCapability.CAP || !(handler instanceof IEnergyContainer)) continue;
                IEnergyContainer container = (IEnergyContainer)((Object)handler);
                energyContainers.add(container);
                this.traitSubscriptions.add(handler.addChangedListener(this::updatePreHeatSubscription));
            }
        }
        this.inputEnergyContainers = new EnergyContainerList(energyContainers);
        this.energyContainer.resetBasicInfo(FusionReactorMachine.calculateEnergyStorageFactor(this.getTier(), energyContainers.size()), 0L, 0L, 0L, 0L);
        this.updatePreHeatSubscription();
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.inputEnergyContainers = null;
        this.heat = 0L;
        this.energyContainer.resetBasicInfo(0L, 0L, 0L, 0L, 0L);
        this.energyContainer.setEnergyStored(0L);
        this.updatePreHeatSubscription();
    }

    protected void updatePreHeatSubscription() {
        if (this.heat > 0L || this.inputEnergyContainers != null && this.inputEnergyContainers.getEnergyStored() > 0L && this.energyContainer.getEnergyStored() < this.energyContainer.getEnergyCapacity()) {
            this.preHeatSubs = this.subscribeServerTick(this.preHeatSubs, this::updateHeat);
        } else if (this.preHeatSubs != null) {
            this.preHeatSubs.unsubscribe();
            this.preHeatSubs = null;
        }
    }

    @Nullable
    public static GTRecipe recipeModifier(MetaMachine machine, @Nonnull GTRecipe recipe) {
        if (machine instanceof FusionReactorMachine) {
            FusionReactorMachine fusionReactorMachine = (FusionReactorMachine)machine;
            if (RecipeHelper.getRecipeEUtTier(recipe) > fusionReactorMachine.getTier() || !recipe.data.method_10545("eu_to_start") || recipe.data.method_10537("eu_to_start") > fusionReactorMachine.energyContainer.getEnergyCapacity()) {
                return null;
            }
            long heatDiff = recipe.data.method_10537("eu_to_start") - fusionReactorMachine.heat;
            if (heatDiff <= 0L) {
                return RecipeHelper.applyOverclock(new OverclockingLogic(2.0, 2.0), recipe, fusionReactorMachine.getMaxVoltage());
            }
            if (fusionReactorMachine.energyContainer.getEnergyStored() < heatDiff) {
                return null;
            }
            fusionReactorMachine.energyContainer.removeEnergy(heatDiff);
            fusionReactorMachine.heat += heatDiff;
            fusionReactorMachine.updatePreHeatSubscription();
            return RecipeHelper.applyOverclock(new OverclockingLogic(2.0, 2.0), recipe, fusionReactorMachine.getMaxVoltage());
        }
        return null;
    }

    public void updateHeat() {
        if ((this.getRecipeLogic().isIdle() || !this.isWorkingEnabled() || this.getRecipeLogic().isWaiting() && this.getRecipeLogic().getProgress() == 0) && this.heat > 0L) {
            this.heat = this.heat <= 10000L ? 0L : this.heat - 10000L;
        }
        long leftStorage = this.energyContainer.getEnergyCapacity() - this.energyContainer.getEnergyStored();
        if (this.inputEnergyContainers != null && leftStorage > 0L) {
            this.energyContainer.addEnergy(this.inputEnergyContainers.removeEnergy(leftStorage));
        }
        this.updatePreHeatSubscription();
    }

    @Override
    public void afterWorking() {
        super.afterWorking();
    }

    @Override
    public long getMaxVoltage() {
        return Math.min(GTValues.V[this.tier], super.getMaxVoltage());
    }

    @Override
    public void addDisplayText(List<class_2561> textList) {
        super.addDisplayText(textList);
        if (this.isFormed()) {
            textList.add((class_2561)class_2561.method_43469((String)"gtceu.multiblock.fusion_reactor.energy", (Object[])new Object[]{this.energyContainer.getEnergyStored(), this.energyContainer.getEnergyCapacity()}));
            textList.add((class_2561)class_2561.method_43469((String)"gtceu.multiblock.fusion_reactor.heat", (Object[])new Object[]{this.heat}));
        }
    }

    public static long calculateEnergyStorageFactor(int tier, int energyInputAmount) {
        return (long)energyInputAmount * (long)Math.pow(2.0, tier - 6) * 10000000L;
    }

    public static class_2248 getCasingState(int tier) {
        return switch (tier) {
            case 6 -> (FusionCasingBlock)GTBlocks.FUSION_CASING.get();
            case 7 -> (FusionCasingBlock)GTBlocks.FUSION_CASING_MK2.get();
            default -> (FusionCasingBlock)GTBlocks.FUSION_CASING_MK3.get();
        };
    }

    public static class_2248 getCoilState(int tier) {
        if (tier == 6) {
            return (class_2248)GTBlocks.SUPERCONDUCTING_COIL.get();
        }
        return (class_2248)GTBlocks.FUSION_COIL.get();
    }

    public static IFusionCasingType getCasingType(int tier) {
        return switch (tier) {
            case 6 -> FusionCasingBlock.CasingType.FUSION_CASING;
            case 7 -> FusionCasingBlock.CasingType.FUSION_CASING_MK2;
            case 8 -> FusionCasingBlock.CasingType.FUSION_CASING_MK3;
            default -> FusionCasingBlock.CasingType.FUSION_CASING;
        };
    }

    @Override
    public int getTier() {
        return this.tier;
    }
}

