/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.IMiner;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.WidgetUtils;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.gui.editor.EditableUI;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.WorkableTieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.machine.trait.miner.MinerLogic;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.FluidTransferList;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3738;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_6179;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6179
public class MinerMachine
extends WorkableTieredMachine
implements IMiner,
IControllable,
IFancyUIMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MinerMachine.class, WorkableTieredMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    protected final ItemStackTransfer chargerInventory;
    private final long energyPerTick;
    @Nullable
    protected TickableSubscription autoOutputSubs;
    @Nullable
    protected TickableSubscription batterySubs;
    @Nullable
    protected ISubscription exportItemSubs;
    @Nullable
    protected ISubscription energySubs;
    public static BiFunction<class_2960, Integer, EditableMachineUI> EDITABLE_UI_CREATOR = class_156.method_34865((path, inventorySize) -> new EditableMachineUI("misc", (class_2960)path, () -> {
        WidgetGroup template = MinerMachine.createTemplate(inventorySize).createDefault();
        ProgressWidget energyBar = MinerMachine.createEnergyBar().createDefault();
        SlotWidget batterySlot = MinerMachine.createBatterySlot().createDefault();
        WidgetGroup energyGroup = new WidgetGroup(0, 0, energyBar.getSize().width, energyBar.getSize().height + 20);
        batterySlot.setSelfPosition(new Position((energyBar.getSize().width - 18) / 2, energyBar.getSize().height + 1));
        energyGroup.addWidget((Widget)energyBar);
        energyGroup.addWidget((Widget)batterySlot);
        WidgetGroup group = new WidgetGroup(0, 0, Math.max(energyGroup.getSize().width + template.getSize().width + 4 + 8, 172), Math.max(template.getSize().height + 8, energyGroup.getSize().height + 8));
        Size size = group.getSize();
        energyGroup.setSelfPosition(new Position(3, (size.height - energyGroup.getSize().height) / 2));
        template.setSelfPosition(new Position((size.width - energyGroup.getSize().width - 4 - template.getSize().width) / 2 + 2 + energyGroup.getSize().width + 2, (size.height - template.getSize().height) / 2));
        group.addWidget((Widget)energyGroup);
        group.addWidget((Widget)template);
        return group;
    }, (template, machine) -> {
        if (machine instanceof MinerMachine) {
            MinerMachine minerMachine = (MinerMachine)machine;
            minerMachine.getRecipeType().createEditableUITemplate(false, false).setupUI((WidgetGroup)template, new GTRecipeType.RecipeHolder(minerMachine.recipeLogic::getProgressPercent, (IItemTransfer)minerMachine.importItems.storage, (IItemTransfer)minerMachine.exportItems.storage, (IFluidTransfer)new FluidTransferList((IFluidTransfer[])minerMachine.importFluids.storages), (IFluidTransfer)new FluidTransferList((IFluidTransfer[])minerMachine.exportFluids.storages), false, false));
            MinerMachine.createTemplate(inventorySize).setupUI((WidgetGroup)template, minerMachine);
            MinerMachine.createEnergyBar().setupUI((WidgetGroup)template, minerMachine);
            MinerMachine.createBatterySlot().setupUI((WidgetGroup)template, minerMachine);
        }
    }));

    public MinerMachine(IMachineBlockEntity holder, int tier, int speed, int maximumRadius, int fortune, Object ... args) {
        super(holder, tier, GTMachines.defaultTankSizeFunction, new Object[]{args, (tier + 1) * (tier + 1), fortune, speed, maximumRadius});
        this.energyPerTick = GTValues.V[tier - 1];
        this.chargerInventory = this.createChargerItemHandler(new Object[0]);
    }

    protected ItemStackTransfer createChargerItemHandler(Object ... args) {
        ItemStackTransfer transfer = new ItemStackTransfer();
        transfer.setFilter(item -> GTCapabilityHelper.getElectricItem(item) != null);
        return transfer;
    }

    @Override
    protected NotifiableItemStackHandler createImportItemHandler(Object ... args) {
        return new NotifiableItemStackHandler(this, 0, IO.NONE);
    }

    @Override
    protected NotifiableItemStackHandler createExportItemHandler(Object ... args) {
        Object object;
        if (args.length > 3 && (object = args[args.length - 4]) instanceof Integer) {
            Integer invSize = (Integer)object;
            return new NotifiableItemStackHandler(this, invSize, IO.OUT, IO.BOTH);
        }
        throw new IllegalArgumentException("MinerMachine need args [inventorySize, fortune, speed, maximumRadius] for initialization");
    }

    @Override
    protected RecipeLogic createRecipeLogic(Object ... args) {
        Object object;
        if (args.length > 2 && (object = args[args.length - 3]) instanceof Integer) {
            Integer fortune = (Integer)object;
            object = args[args.length - 2];
            if (object instanceof Integer) {
                Integer speed = (Integer)object;
                object = args[args.length - 1];
                if (object instanceof Integer) {
                    Integer maxRadius = (Integer)object;
                    return new MinerLogic(this, fortune, speed, maxRadius);
                }
            }
        }
        throw new IllegalArgumentException("MinerMachine need args [inventorySize, fortune, speed, maximumRadius] for initialization");
    }

    @Override
    public void onDrops(List<class_1799> drops, class_1657 entity) {
        MinerMachine.clearInventory(drops, (IItemTransfer)this.exportItems.storage);
        MinerMachine.clearInventory(drops, (IItemTransfer)this.chargerInventory);
    }

    @Override
    public MinerLogic getRecipeLogic() {
        return (MinerLogic)super.getRecipeLogic();
    }

    @Override
    public void onNeighborChanged(class_2248 block, class_2338 fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoOutputSubscription();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            class_1937 class_19372 = this.getLevel();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                serverLevel.method_8503().method_18858((Runnable)new class_3738(0, this::updateAutoOutputSubscription));
            }
            this.updateBatterySubscription();
            this.exportItemSubs = this.exportItems.addChangedListener(this::updateAutoOutputSubscription);
            this.energySubs = this.energyContainer.addChangedListener(this::updateBatterySubscription);
            this.chargerInventory.setOnContentsChanged(this::updateBatterySubscription);
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.exportItemSubs != null) {
            this.exportItemSubs.unsubscribe();
            this.exportItemSubs = null;
        }
        if (this.energySubs != null) {
            this.energySubs.unsubscribe();
            this.energySubs = null;
        }
    }

    protected void updateAutoOutputSubscription() {
        class_2350 outputFacingItems = this.getFrontFacing();
        if (!this.exportItems.isEmpty() && ItemTransferHelper.getItemTransfer((class_1937)this.getLevel(), (class_2338)this.getPos().method_10093(outputFacingItems), (class_2350)outputFacingItems.method_10153()) != null) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::autoOutput);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    protected void updateBatterySubscription() {
        if (this.energyContainer.dischargeOrRechargeEnergyContainers((IItemTransfer)this.chargerInventory, 0, true)) {
            this.batterySubs = this.subscribeServerTick(this.batterySubs, this::chargeBattery);
        } else if (this.batterySubs != null) {
            this.batterySubs.unsubscribe();
            this.batterySubs = null;
        }
    }

    protected void autoOutput() {
        if (this.getOffsetTimer() % 5L == 0L) {
            this.exportItems.exportToNearby(this.getFrontFacing());
        }
        this.updateAutoOutputSubscription();
    }

    protected void chargeBattery() {
        if (!this.energyContainer.dischargeOrRechargeEnergyContainers((IItemTransfer)this.chargerInventory, 0, false)) {
            this.updateBatterySubscription();
        }
    }

    protected static EditableUI<WidgetGroup, MinerMachine> createTemplate(int inventorySize) {
        return new EditableUI<WidgetGroup, MinerMachine>("energy_container", WidgetGroup.class, () -> {
            int rowSize = (int)Math.sqrt(inventorySize);
            int width = rowSize * 18 + 120;
            int height = Math.max(rowSize * 18, 80);
            WidgetGroup group = new WidgetGroup(0, 0, width, height);
            WidgetGroup slots = new WidgetGroup(120, (height - rowSize * 18) / 2, rowSize * 18, rowSize * 18);
            for (int y = 0; y < rowSize; ++y) {
                for (int x = 0; x < rowSize; ++x) {
                    int index = y * rowSize + x;
                    SlotWidget slot = new SlotWidget();
                    slot.initTemplate();
                    slot.setSelfPosition(new Position(x * 18, y * 18));
                    slot.setBackground(new IGuiTexture[]{GuiTextures.SLOT});
                    slot.setId("slot_" + index);
                    slots.addWidget((Widget)slot);
                }
            }
            ComponentPanelWidget componentPanel = new ComponentPanelWidget(4, 5, list -> {});
            componentPanel.setMaxWidthLimit(110);
            componentPanel.setId("component_panel");
            WidgetGroup container = new WidgetGroup(0, 0, 117, height);
            container.addWidget((Widget)new DraggableScrollableWidgetGroup(4, 4, container.getSize().width - 8, container.getSize().height - 8).setBackground((IGuiTexture)GuiTextures.DISPLAY).addWidget((Widget)componentPanel));
            container.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
            group.addWidget((Widget)container);
            group.addWidget((Widget)slots);
            return group;
        }, (group, machine) -> {
            WidgetUtils.widgetByIdForEach(group, "^slot_[0-9]+$", SlotWidget.class, slot -> {
                int index = WidgetUtils.widgetIdIndex((Widget)slot);
                if (index >= 0 && index < machine.exportItems.getSlots()) {
                    slot.setHandlerSlot((IItemTransfer)machine.exportItems, index);
                    slot.setCanTakeItems(true);
                    slot.setCanPutItems(false);
                }
            });
            WidgetUtils.widgetByIdForEach(group, "^component_panel$", ComponentPanelWidget.class, panel -> panel.textSupplier(machine::addDisplayText));
        });
    }

    protected static EditableUI<SlotWidget, MinerMachine> createBatterySlot() {
        return new EditableUI<SlotWidget, MinerMachine>("battery_slot", SlotWidget.class, () -> {
            SlotWidget slotWidget = new SlotWidget();
            slotWidget.setBackground(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.CHARGER_OVERLAY});
            return slotWidget;
        }, (slotWidget, machine) -> {
            slotWidget.setHandlerSlot((IItemTransfer)machine.chargerInventory, 0);
            slotWidget.setCanPutItems(true);
            slotWidget.setCanTakeItems(true);
            slotWidget.setHoverTooltips((class_2561[])LangHandler.getMultiLang("gtceu.gui.charger_slot.tooltip", GTValues.VNF[machine.getTier()], GTValues.VNF[machine.getTier()]).toArray(new class_5250[0]));
        });
    }

    private void addDisplayText(@Nonnull List<class_2561> textList) {
        int workingArea = IMiner.getWorkingArea(this.getRecipeLogic().getCurrentRadius());
        textList.add((class_2561)class_2561.method_43469((String)"gtceu.machine.miner.startx", (Object[])new Object[]{this.getRecipeLogic().getX()}).method_27693(" ").method_10852((class_2561)class_2561.method_43469((String)"gtceu.machine.miner.minex", (Object[])new Object[]{this.getRecipeLogic().getMineX()})));
        textList.add((class_2561)class_2561.method_43469((String)"gtceu.machine.miner.starty", (Object[])new Object[]{this.getRecipeLogic().getY()}).method_27693(" ").method_10852((class_2561)class_2561.method_43469((String)"gtceu.machine.miner.miney", (Object[])new Object[]{this.getRecipeLogic().getMineY()})));
        textList.add((class_2561)class_2561.method_43469((String)"gtceu.machine.miner.startz", (Object[])new Object[]{this.getRecipeLogic().getZ()}).method_27693(" ").method_10852((class_2561)class_2561.method_43469((String)"gtceu.machine.miner.minez", (Object[])new Object[]{this.getRecipeLogic().getMineZ()})));
        textList.add((class_2561)class_2561.method_43469((String)"gtceu.universal.tooltip.working_area", (Object[])new Object[]{workingArea, workingArea}));
        if (this.getRecipeLogic().isDone()) {
            textList.add((class_2561)class_2561.method_43471((String)"gtceu.multiblock.large_miner.done").method_10862(class_2583.field_24360.method_10977(class_124.field_1060)));
        } else if (this.getRecipeLogic().isWorking()) {
            textList.add((class_2561)class_2561.method_43471((String)"gtceu.multiblock.large_miner.working").method_10862(class_2583.field_24360.method_10977(class_124.field_1065)));
        } else if (!this.isWorkingEnabled()) {
            textList.add((class_2561)class_2561.method_43471((String)"gtceu.multiblock.work_paused"));
        }
        if (this.getRecipeLogic().isInventoryFull()) {
            textList.add((class_2561)class_2561.method_43471((String)"gtceu.multiblock.large_miner.invfull").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)));
        }
        if (!this.drainInput(true)) {
            textList.add((class_2561)class_2561.method_43471((String)"gtceu.multiblock.large_miner.needspower").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)));
        }
    }

    @Override
    public boolean drainInput(boolean simulate) {
        long resultEnergy = this.energyContainer.getEnergyStored() - this.energyPerTick;
        if (resultEnergy >= 0L && resultEnergy <= this.energyContainer.getEnergyCapacity()) {
            if (!simulate) {
                this.energyContainer.removeEnergy(this.energyPerTick);
            }
            return true;
        }
        return false;
    }

    @Override
    protected class_1269 onScrewdriverClick(class_1657 playerIn, class_1268 hand, class_2350 gridSide, class_3965 hitResult) {
        if (this.isRemote()) {
            return class_1269.field_5812;
        }
        if (!this.isActive()) {
            int currentRadius = this.getRecipeLogic().getCurrentRadius();
            if (currentRadius == 1) {
                this.getRecipeLogic().setCurrentRadius(this.getRecipeLogic().getMaximumRadius());
            } else if (playerIn.method_18276()) {
                this.getRecipeLogic().setCurrentRadius(Math.max(1, Math.round((float)currentRadius / 2.0f)));
            } else {
                this.getRecipeLogic().setCurrentRadius(Math.max(1, currentRadius - 1));
            }
            this.getRecipeLogic().resetArea();
            int workingArea = IMiner.getWorkingArea(this.getRecipeLogic().getCurrentRadius());
            playerIn.method_43496((class_2561)class_2561.method_43469((String)"gtceu.universal.tooltip.working_area", (Object[])new Object[]{workingArea, workingArea}));
        } else {
            playerIn.method_43496((class_2561)class_2561.method_43471((String)"gtceu.multiblock.large_miner.errorradius"));
        }
        return class_1269.field_5812;
    }

    public ItemStackTransfer getChargerInventory() {
        return this.chargerInventory;
    }
}

