/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.WidgetUtils;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.gui.editor.EditableUI;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.TieredEnergyMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineModifyDrops;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.syncdata.RequireRerender;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1536;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3738;
import net.minecraft.class_39;
import net.minecraft.class_3965;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_6328;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6328
public class FisherMachine
extends TieredEnergyMachine
implements IAutoOutputItem,
IFancyUIMachine,
IMachineModifyDrops {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(FisherMachine.class, TieredEnergyMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DescSynced
    @RequireRerender
    protected class_2350 outputFacingItems;
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean autoOutputItems;
    @Persisted
    protected final NotifiableItemStackHandler cache;
    @Persisted
    protected boolean allowInputFromOutputSideItems;
    @Persisted
    protected final NotifiableItemStackHandler baitHandler;
    @Persisted
    protected final ItemStackTransfer chargerInventory;
    @Nullable
    protected TickableSubscription autoOutputSubs;
    @Nullable
    protected TickableSubscription batterySubs;
    @Nullable
    protected TickableSubscription fishingSubs;
    @Nullable
    protected ISubscription exportItemSubs;
    @Nullable
    protected ISubscription energySubs;
    @Nullable
    protected ISubscription baitSubs;
    private final long energyPerTick;
    private final int inventorySize;
    public final int fishingTicks;
    public static final int WATER_CHECK_SIZE = 5;
    private static final class_1799 fishingRod = new class_1799((class_1935)class_1802.field_8378);
    public static BiFunction<class_2960, Integer, EditableMachineUI> EDITABLE_UI_CREATOR = class_156.method_34865((path, inventorySize) -> new EditableMachineUI("misc", (class_2960)path, () -> {
        WidgetGroup template = FisherMachine.createTemplate(inventorySize).createDefault();
        ProgressWidget energyBar = FisherMachine.createEnergyBar().createDefault();
        SlotWidget batterySlot = FisherMachine.createBatterySlot().createDefault();
        WidgetGroup energyGroup = new WidgetGroup(0, 0, energyBar.getSize().width, energyBar.getSize().height + 20);
        batterySlot.setSelfPosition(new Position((energyBar.getSize().width - 18) / 2, energyBar.getSize().height + 1));
        energyGroup.addWidget((Widget)energyBar);
        energyGroup.addWidget((Widget)batterySlot);
        WidgetGroup group = new WidgetGroup(0, 0, Math.max(energyGroup.getSize().width + template.getSize().width + 4 + 8, 172), Math.max(template.getSize().height + 8, energyGroup.getSize().height + 8));
        Size size = group.getSize();
        energyGroup.setSelfPosition(new Position(3, (size.height - energyGroup.getSize().height) / 2));
        template.setSelfPosition(new Position((size.width - energyGroup.getSize().width - 4 - template.getSize().width) / 2 + 2 + energyGroup.getSize().width + 2, (size.height - template.getSize().height) / 2));
        group.addWidget((Widget)energyGroup);
        group.addWidget((Widget)template);
        return group;
    }, (template, machine) -> {
        if (machine instanceof FisherMachine) {
            FisherMachine fisherMachine = (FisherMachine)machine;
            FisherMachine.createTemplate(inventorySize).setupUI((WidgetGroup)template, fisherMachine);
            FisherMachine.createEnergyBar().setupUI((WidgetGroup)template, fisherMachine);
            FisherMachine.createBatterySlot().setupUI((WidgetGroup)template, fisherMachine);
        }
    }));

    public FisherMachine(IMachineBlockEntity holder, int tier, Object ... args) {
        super(holder, tier, new Object[0]);
        this.inventorySize = (tier + 1) * (tier + 1);
        this.fishingTicks = 1000 - tier * 200;
        this.energyPerTick = GTValues.V[tier - 1];
        this.cache = this.createCacheItemHandler(args);
        this.baitHandler = this.createBaitItemHandler(args);
        this.chargerInventory = this.createChargerItemHandler(new Object[0]);
        this.setOutputFacingItems(this.getFrontFacing());
    }

    protected ItemStackTransfer createChargerItemHandler(Object ... args) {
        ItemStackTransfer transfer = new ItemStackTransfer();
        transfer.setFilter(item -> GTCapabilityHelper.getElectricItem(item) != null);
        return transfer;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableItemStackHandler createCacheItemHandler(Object ... args) {
        return new NotifiableItemStackHandler(this, this.inventorySize, IO.BOTH, IO.OUT);
    }

    protected NotifiableItemStackHandler createBaitItemHandler(Object ... args) {
        NotifiableItemStackHandler handler = new NotifiableItemStackHandler(this, 1, IO.BOTH, IO.IN);
        handler.setFilter(item -> item.method_31574(class_1802.field_8276));
        return handler;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            class_1937 class_19372 = this.getLevel();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                serverLevel.method_8503().method_18858((Runnable)new class_3738(0, this::updateAutoOutputSubscription));
            }
            this.exportItemSubs = this.cache.addChangedListener(this::updateAutoOutputSubscription);
            this.energySubs = this.energyContainer.addChangedListener(() -> {
                this.updateBatterySubscription();
                this.updateFishingUpdateSubscription();
            });
            this.baitSubs = this.baitHandler.addChangedListener(this::updateFishingUpdateSubscription);
            this.chargerInventory.setOnContentsChanged(this::updateBatterySubscription);
            this.updateFishingUpdateSubscription();
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.energySubs != null) {
            this.energySubs.unsubscribe();
            this.energySubs = null;
        }
        if (this.exportItemSubs != null) {
            this.exportItemSubs.unsubscribe();
            this.exportItemSubs = null;
        }
        if (this.baitSubs != null) {
            this.baitSubs.unsubscribe();
            this.baitSubs = null;
        }
    }

    @Override
    public boolean shouldWeatherOrTerrainExplosion() {
        return false;
    }

    @Override
    public void onDrops(List<class_1799> drops, class_1657 entity) {
        FisherMachine.clearInventory(drops, (IItemTransfer)this.chargerInventory);
        FisherMachine.clearInventory(drops, (IItemTransfer)this.baitHandler.storage);
        FisherMachine.clearInventory(drops, (IItemTransfer)this.cache.storage);
    }

    public void updateFishingUpdateSubscription() {
        if (this.drainEnergy(true) && this.baitHandler.getStackInSlot(0).method_31574(class_1802.field_8276)) {
            this.fishingSubs = this.subscribeServerTick(this.fishingSubs, this::fishingUpdate);
        } else if (this.fishingSubs != null) {
            this.fishingSubs.unsubscribe();
            this.fishingSubs = null;
        }
    }

    public void fishingUpdate() {
        this.drainEnergy(false);
        if (this.getOffsetTimer() % (long)this.fishingTicks == 0L) {
            int waterCount = 0;
            int edgeSize = 5;
            for (int x = 0; x < edgeSize; ++x) {
                for (int z = 0; z < edgeSize; ++z) {
                    class_2338 waterCheckPos = this.getPos().method_10074().method_10069(x - edgeSize / 2, 0, z - edgeSize / 2);
                    if (!this.getLevel().method_8320(waterCheckPos).method_26227().method_39360((class_3611)class_3612.field_15910)) continue;
                    ++waterCount;
                }
            }
            if (waterCount < 25) {
                return;
            }
            class_52 lootTable = this.getLevel().method_8503().method_3857().getLootTable(class_39.field_353);
            class_1536 simulatedHook = new class_1536(class_1299.field_6103, this.getLevel()){

                public boolean method_26088() {
                    return true;
                }
            };
            class_8567 lootContext = new class_8567.class_8568((class_3218)this.getLevel()).method_51877(class_181.field_1226, (Object)simulatedHook).method_51874(class_181.field_1229, (Object)fishingRod).method_51874(class_181.field_24424, (Object)new class_243((double)this.getPos().method_10263(), (double)this.getPos().method_10264(), (double)this.getPos().method_10260())).method_51875(class_173.field_1176);
            class_2371 generatedLoot = class_2371.method_10211();
            generatedLoot.addAll((Collection)lootTable.method_51878(lootContext));
            boolean useBait = false;
            for (class_1799 itemStack : generatedLoot) {
                useBait |= this.tryFillCache(itemStack);
            }
            if (useBait) {
                this.baitHandler.extractItem(0, 1, false);
            }
            this.updateFishingUpdateSubscription();
        }
    }

    private boolean tryFillCache(class_1799 stack) {
        for (int i = 0; i < this.cache.getSlots(); ++i) {
            if (this.cache.insertItemInternal(i, stack, false).method_7947() >= stack.method_7947()) continue;
            return true;
        }
        return false;
    }

    public boolean drainEnergy(boolean simulate) {
        long resultEnergy = this.energyContainer.getEnergyStored() - this.energyPerTick;
        if (resultEnergy >= 0L && resultEnergy <= this.energyContainer.getEnergyCapacity()) {
            if (!simulate) {
                this.energyContainer.removeEnergy(this.energyPerTick);
            }
            return true;
        }
        return false;
    }

    @Override
    public void setAutoOutputItems(boolean allow) {
        this.autoOutputItems = allow;
        this.updateAutoOutputSubscription();
    }

    @Override
    public void setOutputFacingItems(@Nullable class_2350 outputFacing) {
        this.outputFacingItems = outputFacing;
        this.updateAutoOutputSubscription();
    }

    protected void updateBatterySubscription() {
        if (this.energyContainer.dischargeOrRechargeEnergyContainers((IItemTransfer)this.chargerInventory, 0, true)) {
            this.batterySubs = this.subscribeServerTick(this.batterySubs, this::chargeBattery);
        } else if (this.batterySubs != null) {
            this.batterySubs.unsubscribe();
            this.batterySubs = null;
        }
    }

    protected void updateAutoOutputSubscription() {
        class_2350 outputFacing = this.getOutputFacingItems();
        if (this.isAutoOutputItems() && !this.cache.isEmpty() && outputFacing != null && ItemTransferHelper.getItemTransfer((class_1937)this.getLevel(), (class_2338)this.getPos().method_10093(outputFacing), (class_2350)outputFacing.method_10153()) != null) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::checkAutoOutput);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    protected void checkAutoOutput() {
        if (this.getOffsetTimer() % 5L == 0L) {
            if (this.isAutoOutputItems() && this.getOutputFacingItems() != null) {
                this.cache.exportToNearby(this.getOutputFacingItems());
            }
            this.updateAutoOutputSubscription();
        }
    }

    protected void chargeBattery() {
        if (!this.energyContainer.dischargeOrRechargeEnergyContainers((IItemTransfer)this.chargerInventory, 0, false)) {
            this.updateBatterySubscription();
        }
    }

    @Override
    public boolean isFacingValid(class_2350 facing) {
        if (facing == this.getOutputFacingItems()) {
            return false;
        }
        return super.isFacingValid(facing);
    }

    @Override
    public void onNeighborChanged(class_2248 block, class_2338 fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoOutputSubscription();
    }

    protected static EditableUI<SlotWidget, FisherMachine> createBatterySlot() {
        return new EditableUI<SlotWidget, FisherMachine>("battery_slot", SlotWidget.class, () -> {
            SlotWidget slotWidget = new SlotWidget();
            slotWidget.setBackground(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.CHARGER_OVERLAY});
            return slotWidget;
        }, (slotWidget, machine) -> {
            slotWidget.setHandlerSlot((IItemTransfer)machine.chargerInventory, 0);
            slotWidget.setCanPutItems(true);
            slotWidget.setCanTakeItems(true);
            slotWidget.setHoverTooltips((class_2561[])LangHandler.getMultiLang("gtceu.gui.charger_slot.tooltip", GTValues.VNF[machine.getTier()], GTValues.VNF[machine.getTier()]).toArray(new class_5250[0]));
        });
    }

    protected static EditableUI<WidgetGroup, FisherMachine> createTemplate(int inventorySize) {
        return new EditableUI<WidgetGroup, FisherMachine>("functional_container", WidgetGroup.class, () -> {
            int rowSize = (int)Math.sqrt(inventorySize);
            WidgetGroup main = new WidgetGroup(0, 0, rowSize * 18 + 8 + 20, rowSize * 18 + 8);
            for (int y = 0; y < rowSize; ++y) {
                for (int x = 0; x < rowSize; ++x) {
                    int index = y * rowSize + x;
                    SlotWidget slotWidget = new SlotWidget();
                    slotWidget.initTemplate();
                    slotWidget.setSelfPosition(new Position(24 + x * 18, 4 + y * 18));
                    slotWidget.setBackground(new IGuiTexture[]{GuiTextures.SLOT});
                    slotWidget.setId("slot_" + index);
                    main.addWidget((Widget)slotWidget);
                }
            }
            SlotWidget baitSlotWidget = new SlotWidget();
            baitSlotWidget.initTemplate();
            baitSlotWidget.setSelfPosition(new Position(4, (main.getSize().height - baitSlotWidget.getSize().height) / 2));
            baitSlotWidget.setBackground(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.STRING_SLOT_OVERLAY});
            baitSlotWidget.setId("bait_slot");
            main.addWidget((Widget)baitSlotWidget);
            main.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
            return main;
        }, (group, machine) -> {
            WidgetUtils.widgetByIdForEach(group, "^slot_[0-9]+$", SlotWidget.class, slot -> {
                int index = WidgetUtils.widgetIdIndex((Widget)slot);
                if (index >= 0 && index < machine.cache.getSlots()) {
                    slot.setHandlerSlot((IItemTransfer)machine.cache, index);
                    slot.setCanTakeItems(true);
                    slot.setCanPutItems(false);
                }
            });
            WidgetUtils.widgetByIdForEach(group, "^bait_slot$", SlotWidget.class, slot -> {
                slot.setHandlerSlot((IItemTransfer)machine.baitHandler.storage, 0);
                slot.setCanTakeItems(true);
                slot.setCanPutItems(true);
            });
        });
    }

    @Override
    public ResourceTexture sideTips(class_1657 player, Set<GTToolType> toolTypes, class_2350 side) {
        if (!(!toolTypes.contains(GTToolType.WRENCH) || player.method_18276() || this.hasFrontFacing() && side == this.getFrontFacing())) {
            return GuiTextures.TOOL_IO_FACING_ROTATION;
        }
        if (toolTypes.contains(GTToolType.SCREWDRIVER) && side == this.getOutputFacingItems()) {
            return GuiTextures.TOOL_ALLOW_INPUT;
        }
        return super.sideTips(player, toolTypes, side);
    }

    @Override
    protected class_1269 onWrenchClick(class_1657 playerIn, class_1268 hand, class_2350 gridSide, class_3965 hitResult) {
        if (!playerIn.method_18276() && !this.isRemote()) {
            class_1799 tool = playerIn.method_5998(hand);
            if (tool.method_7919() >= tool.method_7936()) {
                return class_1269.field_5811;
            }
            if (this.hasFrontFacing() && gridSide == this.getFrontFacing()) {
                return class_1269.field_5811;
            }
            class_2350 itemFacing = this.outputFacingItems;
            if (gridSide != itemFacing) {
                this.setOutputFacingItems(gridSide);
            } else {
                this.setOutputFacingItems(null);
            }
            return class_1269.field_21466;
        }
        return super.onWrenchClick(playerIn, hand, gridSide, hitResult);
    }

    @Override
    public class_2350 getOutputFacingItems() {
        return this.outputFacingItems;
    }

    @Override
    public boolean isAutoOutputItems() {
        return this.autoOutputItems;
    }

    @Override
    public boolean isAllowInputFromOutputSideItems() {
        return this.allowInputFromOutputSideItems;
    }

    @Override
    public void setAllowInputFromOutputSideItems(boolean allowInputFromOutputSideItems) {
        this.allowInputFromOutputSideItems = allowInputFromOutputSideItems;
    }

    public ItemStackTransfer getChargerInventory() {
        return this.chargerInventory;
    }
}

