/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.electric;

import com.gregtechceu.gtceu.api.capability.PlatformEnergyCompat;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TieredEnergyMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.common.machine.trait.ConverterTrait;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3965;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class ConverterMachine
extends TieredEnergyMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ConverterMachine.class, TieredEnergyMachine.MANAGED_FIELD_HOLDER);

    public ConverterMachine(IMachineBlockEntity holder, int tier, int amps, Object ... args) {
        super(holder, tier, args, amps);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    protected NotifiableEnergyContainer createEnergyContainer(Object ... args) {
        Object object;
        if (args.length > 0 && (object = args[args.length - 1]) instanceof Integer) {
            Integer ampsValue = (Integer)object;
            return new ConverterTrait(this, ampsValue);
        }
        throw new IllegalArgumentException("ConverterMachine need args [amps] for initialization");
    }

    public ConverterTrait getConverterTrait() {
        return (ConverterTrait)this.energyContainer;
    }

    @Override
    public class_1269 onSoftMalletClick(class_1657 playerIn, class_1268 hand, class_2350 facing, class_3965 hitResult) {
        if (!this.isRemote()) {
            if (this.getConverterTrait().isFeToEu()) {
                this.setFeToEu(false);
                playerIn.method_43496((class_2561)class_2561.method_43469((String)"gtceu.machine.energy_converter.message_conversion_eu", (Object[])new Object[]{this.getConverterTrait().getAmps(), this.getConverterTrait().getVoltage(), PlatformEnergyCompat.toNativeLong(this.getConverterTrait().getVoltage() * (long)this.getConverterTrait().getAmps(), PlatformEnergyCompat.ratio(false))}));
            } else {
                this.setFeToEu(true);
                playerIn.method_43496((class_2561)class_2561.method_43469((String)"gtceu.machine.energy_converter.message_conversion_native", (Object[])new Object[]{PlatformEnergyCompat.toNativeLong(this.getConverterTrait().getVoltage() * (long)this.getConverterTrait().getAmps(), PlatformEnergyCompat.ratio(true)), this.getConverterTrait().getAmps(), this.getConverterTrait().getVoltage()}));
            }
        }
        return class_1269.field_21466;
    }

    public void setFeToEu(boolean feToEu) {
        this.getConverterTrait().setFeToEu(feToEu);
    }

    public boolean isFeToEu() {
        return this.getConverterTrait().isFeToEu();
    }

    @Override
    public boolean isFacingValid(class_2350 facing) {
        return true;
    }

    @Override
    public ResourceTexture sideTips(class_1657 player, Set<GTToolType> toolTypes, class_2350 side) {
        if (toolTypes.contains(GTToolType.SOFT_MALLET)) {
            return this.isFeToEu() ? GuiTextures.TOOL_SWITCH_CONVERTER_NATIVE : GuiTextures.TOOL_SWITCH_CONVERTER_EU;
        }
        return super.sideTips(player, toolTypes, side);
    }

    @Override
    protected long getMaxInputOutputAmperage() {
        return this.getConverterTrait().getAmps();
    }

    @Override
    protected boolean isEnergyEmitter() {
        return this.getConverterTrait().isFeToEu();
    }
}

