/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.rotation;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.common.item.tool.rotation.ICustomRotationBehavior;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2377;
import net.minecraft.class_2383;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import org.jetbrains.annotations.ApiStatus;

public class CustomBlockRotations {
    private static final Map<class_2248, ICustomRotationBehavior> CUSTOM_BEHAVIOR_MAP = new Object2ObjectOpenHashMap();
    public static final ICustomRotationBehavior BLOCK_HORIZONTAL_BEHAVIOR = new ICustomRotationBehavior(){

        @Override
        public boolean customRotate(class_2680 state, class_1937 world, class_2338 pos, class_3965 hitResult) {
            class_2350 gridSide = ICoverable.determineGridSideHit(hitResult);
            if (gridSide == null) {
                return false;
            }
            if (gridSide.method_10166() == class_2350.class_2351.field_11052) {
                return false;
            }
            if (gridSide != state.method_11654((class_2769)class_2383.field_11177)) {
                state = (class_2680)state.method_11657((class_2769)class_2383.field_11177, (Comparable)gridSide);
                world.method_8501(pos, state);
                return true;
            }
            return false;
        }

        @Override
        public boolean showXOnSide(class_2680 state, class_2350 facing) {
            return state.method_11654((class_2769)class_2383.field_11177) == facing;
        }
    };
    public static final ICustomRotationBehavior BLOCK_DIRECTIONAL_BEHAVIOR = new ICustomRotationBehavior(){

        @Override
        public boolean customRotate(class_2680 state, class_1937 world, class_2338 pos, class_3965 hitResult) {
            class_2350 gridSide = ICoverable.determineGridSideHit(hitResult);
            if (gridSide == null) {
                return false;
            }
            if (gridSide != state.method_11654((class_2769)class_2318.field_10927)) {
                state = (class_2680)state.method_11657((class_2769)class_2318.field_10927, (Comparable)gridSide);
                world.method_8501(pos, state);
                return true;
            }
            return false;
        }

        @Override
        public boolean showXOnSide(class_2680 state, class_2350 facing) {
            return state.method_11654((class_2769)class_2318.field_10927) == facing;
        }
    };

    @ApiStatus.Internal
    public static void init() {
        CustomRotations.init();
    }

    public static void registerCustomRotation(class_2248 block, ICustomRotationBehavior behavior) {
        CUSTOM_BEHAVIOR_MAP.put(block, behavior);
    }

    public static ICustomRotationBehavior getCustomRotation(class_2248 block) {
        return CUSTOM_BEHAVIOR_MAP.get(block);
    }

    private static enum CustomRotations {
        PISTON(class_2246.field_10560, BLOCK_DIRECTIONAL_BEHAVIOR),
        STICKY_PISTON(class_2246.field_10615, BLOCK_DIRECTIONAL_BEHAVIOR),
        DROPPER(class_2246.field_10228, BLOCK_DIRECTIONAL_BEHAVIOR),
        DISPENSER(class_2246.field_10200, BLOCK_DIRECTIONAL_BEHAVIOR),
        OBSERVER(class_2246.field_10282, BLOCK_DIRECTIONAL_BEHAVIOR),
        FURNACE(class_2246.field_10181, BLOCK_HORIZONTAL_BEHAVIOR),
        PUMPKIN(class_2246.field_10261, BLOCK_HORIZONTAL_BEHAVIOR),
        LIT_PUMPKIN(class_2246.field_10009, BLOCK_HORIZONTAL_BEHAVIOR),
        CHEST(class_2246.field_10034, BLOCK_HORIZONTAL_BEHAVIOR),
        TRAPPED_CHEST(class_2246.field_10380, BLOCK_HORIZONTAL_BEHAVIOR),
        ENDER_CHEST(class_2246.field_10443, BLOCK_HORIZONTAL_BEHAVIOR),
        HOPPER(class_2246.field_10312, new ICustomRotationBehavior(){

            @Override
            public boolean customRotate(class_2680 state, class_1937 world, class_2338 pos, class_3965 hitResult) {
                class_2350 gridSide = ICoverable.determineGridSideHit(hitResult);
                if (gridSide == null || gridSide == class_2350.field_11036) {
                    return false;
                }
                if (gridSide != state.method_11654((class_2769)class_2377.field_11129)) {
                    state = (class_2680)state.method_11657((class_2769)class_2377.field_11129, (Comparable)gridSide);
                    world.method_8501(pos, state);
                    return true;
                }
                return false;
            }

            @Override
            public boolean showXOnSide(class_2680 state, class_2350 facing) {
                return state.method_11654((class_2769)class_2377.field_11129) == facing;
            }
        });


        private CustomRotations(class_2248 block, ICustomRotationBehavior behavior) {
            CustomBlockRotations.registerCustomRotation(block, behavior);
        }

        private static void init() {
        }
    }
}

