/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.google.common.collect.ImmutableSet;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.aoe.AoESymmetrical;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.fabric.ScrapeBehaviorImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5955;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrapeBehavior
implements IToolBehavior {
    public static final ScrapeBehavior INSTANCE = ScrapeBehavior.create();

    protected ScrapeBehavior() {
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    protected static ScrapeBehavior create() {
        return ScrapeBehaviorImpl.create();
    }

    @Override
    @NotNull
    public class_1269 onItemUse(class_1838 context) {
        Object blocks;
        class_1937 level = context.method_8045();
        class_1657 player = context.method_8036();
        class_2338 pos = context.method_8037();
        class_1268 hand = context.method_20287();
        class_1799 stack = player.method_5998(hand);
        AoESymmetrical aoeDefinition = ToolHelper.getAoEDefinition(stack);
        if (this.isBlockScrapable(stack, level, player, pos, context)) {
            if (aoeDefinition == AoESymmetrical.none()) {
                blocks = ImmutableSet.of((Object)pos);
            } else {
                class_239 rayTraceResult = ToolHelper.getPlayerDefaultRaytrace(player);
                if (rayTraceResult == null) {
                    return class_1269.field_5811;
                }
                if (rayTraceResult.method_17783() != class_239.class_240.field_1332) {
                    return class_1269.field_5811;
                }
                if (!(rayTraceResult instanceof class_3965)) {
                    return class_1269.field_5811;
                }
                class_3965 blockHitResult = (class_3965)rayTraceResult;
                if (blockHitResult.method_17780() == null) {
                    return class_1269.field_5811;
                }
                blocks = ScrapeBehavior.getScrapableBlocks(stack, aoeDefinition, level, player, rayTraceResult);
                blocks.add(blockHitResult.method_17777());
            }
        } else {
            return class_1269.field_5811;
        }
        boolean pathed = false;
        Iterator iterator = blocks.iterator();
        while (iterator.hasNext()) {
            class_2338 blockPos = (class_2338)iterator.next();
            pathed |= level.method_8652(blockPos, this.getScraped(level.method_8320(blockPos), new class_1838(player, hand, context.method_30344().method_29328(blockPos))), 3);
            level.method_8444(player, 3005, blockPos, 0);
            if (!player.method_7337()) {
                ToolHelper.damageItem(context.method_8041(), (class_1309)context.method_8036());
            }
            if (!stack.method_7960()) continue;
            break;
        }
        if (pathed) {
            level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_29542, class_3419.field_15248, 1.0f, 1.0f);
            player.method_6104(hand);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static Set<class_2338> getScrapableBlocks(class_1799 stack, AoESymmetrical aoeDefinition, class_1937 Level2, class_1657 player, class_239 rayTraceResult) {
        return ToolHelper.iterateAoE(stack, aoeDefinition, Level2, player, rayTraceResult, INSTANCE::isBlockScrapable);
    }

    protected boolean isBlockScrapable(class_1799 stack, class_1937 level, class_1657 player, class_2338 pos, class_1838 context) {
        class_2680 state = level.method_8320(pos);
        return class_5955.method_34735((class_2680)state).isPresent();
    }

    protected class_2680 getScraped(class_2680 unscrapedState, class_1838 context) {
        return class_5955.method_34735((class_2680)unscrapedState).orElse(unscrapedState);
    }

    @Override
    public void addInformation(@NotNull class_1799 stack, @Nullable class_1937 Level2, @NotNull List<class_2561> tooltip, @NotNull class_1836 flag) {
        tooltip.add((class_2561)class_2561.method_43471((String)"item.gtceu.tool.behavior.scrape"));
    }
}

